/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file DotPolyShadingMethod.h
    \brief Definition of the Template class DotPolyShadingMethod.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 25-Aug-2004
    
    Changes:
    
*/

#ifndef DotPolyShadingMethod_H
#define DotPolyShadingMethod_H

#include "magics.h"
#include "MagException.h"

#include "PolyShadingMethod.h"
#include "DotPolyShadingMethodAttributes.h"
#include "IntervalMap.h"

namespace magics {

template <class P>
class DotPolyShadingMethod: public map<double, pair<double, double> >, public PolyShadingMethod<P>, public DotPolyShadingMethodAttributes {

public:
	DotPolyShadingMethod() {}
	virtual ~DotPolyShadingMethod() {}
    
    virtual void set(const map<string, string>& map) { DotPolyShadingMethodAttributes::set(map); }
    virtual void set(const XmlNode& node) { DotPolyShadingMethodAttributes::set(node); }
    virtual bool accept(const string& node) { return DotPolyShadingMethodAttributes::accept(node); }


    virtual PolyShadingMethod<P>* clone() const {
		DotPolyShadingMethod<P>* object = new DotPolyShadingMethod<P>();
		object->copy(*this);
		return object;
	}
    
    virtual void prepare(const LevelSelection& levels) { 
		if (levels.empty() )return;
        float step = (max_density_ - min_density_)/(levels.size() - 1);
        
            	LevelSelection::const_iterator from = levels.begin();
            	LevelSelection::const_iterator level = levels.begin();
            	level++;
            	float density = min_density_;
            	for (  ;  level != levels.end(); ++level) {
            		indexes_.insert(make_pair(Interval(*from, *level), density)); 		
            		
            		from++;
            		density+=step; 
            	
            	}
            }
    
    
    
   
    virtual void operator()(Polyline& poly, const ColourTechnique& colours) const { 
        DotShadingProperties* shading = new DotShadingProperties();
        
        double value = poly.front().value();
        Colour colour = poly.getFillColour();
        Colour left = colours.left(value);
        Colour right = colours.right(value);
        
        
     
        shading->size_ = size_;
        shading->angle_ = angle_;
        shading->density_ =  indexes_.find(value, 40.);

		poly.setStroke(false);
        poly.setShading(shading);
        //MagLog::dev() << "Attach DotShading Information" << *shading << "\n";
    };
      virtual void operator()(Polyline& poly, double value, const ColourTechnique& colours) const { 
    	static int i = 0;
    	
    	i++;
    	 
    	 poly.setFilled(true);
    	  Colour colour = poly.getFillColour();
    	        Colour left = colours.left(value);
    	        Colour right = colours.right(value);
    	        
    	        DotShadingProperties* shading = new DotShadingProperties();
    	     
    	        shading->size_ = size_;
    	        shading->angle_ = angle_;
    	      
    	
    	
 
        
        	  shading->density_ =    indexes_.find(value, 40.);
        
 
        poly.setShading(shading);
		poly.setStroke(false);
        //MagLog::dev() << "Attach DotShading Information [" << i << "]=" << value << "--->" << *shading << "\n";
    };

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const {} 

	 IntervalMap<float> indexes_;
private:
    //! Copy constructor - No copy allowed
	DotPolyShadingMethod(const DotPolyShadingMethod&);
    //! Overloaded << operator to copy - No copy allowed
	DotPolyShadingMethod& operator=(const DotPolyShadingMethod&);
    
// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const DotPolyShadingMethod<P>& p)
		{ p.print(s); return s; }

};

} // namespace magics

#endif
