/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file AxisTickLabel.cc
    \brief Implementation of the Template class AxisTickLabel.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 7-Oct-2005
    
    Changes:
    
*/



#include "AxisTickLabel.h"
#include "PaperPoint.h"
#include "Text.h"
#include "MagicsFormat.h"
#include "Transformation.h"
#include "TagHandler.h"
#include <cfloat>
using namespace magics;

AxisTickLabel::AxisTickLabel() 
{
}


AxisTickLabel::~AxisTickLabel() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void AxisTickLabel::print(ostream& out)  const
{
	out << "AxisTickLabel[";
	out << "]";
}

void AxisTickLabel::horizontal(const AxisItems& ticks,const Colour& colour, HorizontalAxisVisitor& axis)
{
	Justification justification =  axis.justificationTickLabel();
	const Transformation& transformation = axis.transformation();
	double angle = ( magCompare(orientation_, "horizontal") ) ? 0 : -1.57;
    justification = ( magCompare(orientation_, "horizontal") ) ? justification: MRIGHT ;
	int count = -1;

	for (AxisItems::const_iterator x = ticks.begin(); x != ticks.end(); ++x)
	{
		    if ( !transformation.inX((*x)->position()) ) continue;
			if ( (*x)->filter(*this) == false) 
				continue;
        	if ( (*x)->isFirst() && !first_ ) continue;
        	if ( (*x)->isLast() && !last_ ) continue;
        	string label = (*x)->label(*type_);
          if ( label.empty() ) continue;
        	 count++;
        	if ( count % frequency_  ) continue;

		double height = ((*x)->height() == DBL_MIN || (*x)->height() == 0) ? height_ : (*x)->height();
		double pos = axis.offsetTickLabel(height, (*x)->level());
		
		PaperPoint point(transformation.x((*x)->position()), pos); 
		
		bool out = false;
		if ( magCompare(position_, "inter_tick") ) {
			AxisItems::const_iterator next = x;
			next++;
			while (next!=ticks.end() && !(*next)->filter(*this) )
				next++;
			out = true;
			if (next != ticks.end() && (*x)->level() == (*next)->level() ) {	
				string nlabel = (*next)->label(*type_);
				const double x1 = transformation.x((*x)->position());
				const double x2 = transformation.x((*next)->position());
				point = PaperPoint((x2+x1)/2, pos);
				out = (!transformation.in(point)) ;
			}
		}


		if ( out ) 
			continue;
		Text* text = new Text();

		Colour newcolour;
		if ((*x)->colour() != "undef" ) 
			newcolour =  Colour((*x)->colour());
		else 
			newcolour =  (colour_->automatic()) ? colour : *colour_;
		

		MagFont font(font_);
		font.colour(newcolour);
		font.style(font_style_);
	    font.size( height );
	   TagHandler dummy;
	    TagConverter converter(dummy);;
	    		converter.font(font); 
	    		
	    		converter.decode(label, text);	
	    
	    text->setJustification(justification);
	    text->setVerticalAlign(MTOP);
	    text->setAngle(angle);

	    text->push_back(point);
	    axis.push_back(text);
	 }
}




void AxisTickLabel::vertical(const AxisItems& ticks,const Colour& colour, VerticalAxisVisitor& axis)
{
	Justification justification =  axis.justificationTickLabel();
	const Transformation& transformation = axis.transformation();
	
	int count = -1;
	
	PaperPoint point;
	
	for (AxisItems::const_iterator y = ticks.begin(); y != ticks.end(); ++y)
	{	
		if ( (*y)->filter(*this) == false) 
			continue;
		if ( !transformation.inY((*y)->position()) ) continue;

		if ( (*y)->isFirst()   && !first_ ) continue;
		if ( (*y)->isLast() && !last_ ) continue;
		string label = (*y)->label(*type_);
		    if ( label.empty() ) continue;

		count++;
		if ( count % frequency_  ) continue;


		double height = ((*y)->height() == DBL_MIN || (*y)->height() == 0 ) ? height_ : (*y)->height();
		double pos =  axis.offsetTickLabel(height, (*y)->level());
    
        PaperPoint point(pos, transformation.y((*y)->position()));

		bool out = false;

	
		if ( magCompare(position_, "inter_tick") ) {
			AxisItems::const_iterator next = y;
			next++;
			while (next!=ticks.end() && !(*next)->filter(*this) )
				next++;
			out = true;
			if (next != ticks.end() && (*y)->level() == (*next)->level()) {	
        			const double y1 = transformation.y((*y)->position());
        			const double y2 = transformation.y((*next)->position());
        			point = PaperPoint(pos, (y2+y1)/2);
					out = !transformation.in(point);
			}
		}
		

		if ( out) 
			continue;
		Text* text = new Text();
		text->setJustification(justification);
		//(*text).setAngle(angle);
		Colour newcolour =  (colour_->automatic()) ? colour : *colour_;

		MagFont font(font_);
		font.colour(newcolour);
		font.style(font_style_);
		font.size( height );
		TagHandler helper;
		TagConverter converter(helper);
		converter.font(font);
		
		converter.decode(label, text);
		
		text->setJustification(justification);
		text->setVerticalAlign(MHALF);

		text->push_back(point);

		axis.push_back(text);
	}
}
