/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file ViewNode.cc
    \brief Implementation of the Template class ViewNode.
    
    Magics Team - ECMWF 2007
    
    Started: Tue 6-Mar-2007
    
    Changes:
    
*/

#include "PreviewVisitor.h"
#include "Transformation.h"
#include "Layout.h"
#include "BaseDriver.h"

using namespace magics;



PreviewVisitor::PreviewVisitor()
{
name("preview");
}

PreviewVisitor::~PreviewVisitor()
{


}
void PreviewVisitor::print(ostream& s) const
{
	s << "PreviewVisitor[]";
}
void NoPreviewVisitor::print(ostream& s) const
{
	s << "NoPreviewVisitor[]";
}
void PreviewVisitor::visit(BasicGraphicsObjectContainer& tree)
{

	tree.push_back(this);
	// the Layout has been added to a Container, it will be delted automatically!
	
}
void PreviewVisitor::redisplay(const BaseDriver& driver) const { 
	MagLog::dev() << " I am a PreviewVisitor!" << endl;	
	driver.redisplay(*this);
}
void PreviewVisitor::visit(BasicSceneObject& object) { 
		object.visit(*this); 
}
