%module (docstring="This is a Python interface to Magics++") Magics

%{
#define SWIG_FILE_WITH_INIT
/* Includes the header in the wrapper code */
#include "Magics_interface.cc"
#include "numpy/arrayobject.h"
%}

// This tells SWIG to treat char ** as a special case
//
//  see http://www.swig.org/Doc1.3/Python.html#Python_nn59
//
%typemap(in) (const char **data, const int dim)
{
  /* Check if is a list */
  if (PyList_Check($input))
  {
    int size = PyList_Size($input);
    int i = 0;
    $1 = (char **) malloc((size+1)*sizeof(char *));
    $2 = size;
    for (i = 0; i < size; i++) {
      PyObject *o = PyList_GetItem($input,i);
      if (PyString_Check(o))
	$1[i] = PyString_AsString(PyList_GetItem($input,i));
      else {
	PyErr_SetString(PyExc_TypeError,"list must contain strings");
	free($1);
	return NULL;
      }
    }
    $1[i] = 0;
  }
  else
  {
    PyErr_SetString(PyExc_TypeError,"not a list");
    return NULL;
  }
}

// This cleans up the char ** array we malloced before the function call
%typemap(freearg) (const char **data, int dim)
{
  free((char *) $1);
}


/* 
  N U M E R I C A L   A R R A Y S 
*/
%init %{
        import_array();
%}

//
// for pset1r        -> array
// 
%typemap(in) (double *data, int dim)
{
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.float64");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 1)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be one dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_DOUBLE)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be DOUBLE type.");
           return NULL;
       }
       $1 = (double*)array->data;
       $2 = array->dimensions[0];
}

//
// for pset1i        -> array
// 
%typemap(in) (int *data, int dim)
{
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.int32");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 1)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be one dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_INT)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be INT type.");
           return NULL;
       }
       $1 = (int*)array->data;
       $2 = array->dimensions[0];
}



//
// Interface from a Numpy 2D int array, to plain unsigned int*.
//  
%typemap(in) (int *data, const int dim1, const int dim2)
{
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.int32");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 2)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be two dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_INT)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be INT type.");
           return NULL;
       }
       $1 = (int*)array->data;
       $2 = array->dimensions[1];
       $3 = array->dimensions[0];
}

//
// Interface from a Numpy 3D int array, to plain int*
// 
%typemap(in) (int *data, const int dim1, const int dim2, const int dim3)
{
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.int32");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 3)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be three dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_INT)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be INT type.");
           return NULL;
       }
       $1 = (int*)array->data;
       $2 = array->dimensions[2];
       $3 = array->dimensions[1];
       $4 = array->dimensions[0];
}

//
// Interface from a Numpy 2D float64 array, to plain unsigned double*
//
%typemap(in) (double *data, const int dim1, const int dim2)
{
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.float64");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 2)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be two dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_DOUBLE)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be DOUBLE type.");
           return NULL;
       }
       $1 = (double*)array->data;
       $2 = array->dimensions[1];
       $3 = array->dimensions[0];
}

//
// Interface from a Numpy 3D float64 array, to plain unsigned double*
//
%typemap(in) (double *data, const int dim1, const int dim2, const int dim3)
{
       if (!PyArray_Check($input)) 
       {
           PyErr_SetString(PyExc_TypeError,"Expected array of type dtype=numpy.float64");
           return NULL;
       }
       PyArrayObject *array = (PyArrayObject *) $input;
       if (array->nd != 3)
       {
           PyErr_SetString(PyExc_TypeError,"Numpy array must be three dimensional.");
           return NULL;
       }
       if (array->descr->type_num != PyArray_DOUBLE)
       {
           PyErr_SetString(PyExc_TypeError,"Numpyc array must be DOUBLE type.");
           return NULL;
       }
       $1 = (double*)array->data;
       $2 = array->dimensions[2];
       $3 = array->dimensions[1];
       $4 = array->dimensions[0];
}

/* Parse the header file to generate wrappers */
%include "Magics_interface.cc"
