/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file OdaDecoder.cc
    \brief Implementation of the Template class OdaDecoder.
    
    Magics Team - ECMWF 2004
    
    Started: Fri 16-Jan-2004
    
    Changes:
    
*/

#include "oda.h"
extern "C" {
#include "odacapi.h"
}

#include "OdaDecoder.h"

#include "TextVisitor.h"


OdaDecoder::OdaDecoder() 
{
}


OdaDecoder::~OdaDecoder() 
{
	
}

/*!
 Class information are given to the output-stream.
*/		
void OdaDecoder::print(ostream& out)  const
{
	out << "OdaDecoder[";
        OdaDecoderAttributes::print(out);
        out << "]";
}

void OdaDecoder::decode(const Transformation& transformation)
{    
/*    	if ( !empty() ) 
    		return;  
 
	oda_init();
    	ODA oda("");
	string select = string("select lat, lon, ") + value_ + " from \"" + path_ + "\";";
	Log::info() << select << endl;

	for (ODA::select_iterator it = oda.select(select);
		it != oda.selectEnd();
		++it) 
	{
		push_back(GeoPoint(it->data(1)*180/3.14, it->data(0)*180/3.14, it->data(2)));
	}
*/
	if ( !empty() ) 
		return;  

 	oda_init();
    	ODA oda(path_);

	ODA::iterator it = oda.begin(false, true);

	size_t latIndex = it.columns().columnIndex(latitude_);
	size_t lonIndex = it.columns().columnIndex(longitude_);
	size_t valueIndex = it.columns().columnIndex(value_);	
  
	Log::info() <<  "Indices: " << latIndex << " " << lonIndex << " " << valueIndex << endl;

	unsigned int row=0;
	if(nb_rows_== -1)
	{
		for (; it != oda.end(); ++it, row++) 
		{			
			double lat = it->data(latIndex)*180/3.14;
							double lon = it->data(lonIndex)*180/3.14;
			if ( transformation.in(lon, lat)  ) {
				CustomisedPoint* point = new CustomisedPoint();		
				point->longitude(lon);
				point->latitude(lat);
				statistics_.push_back(it->data(valueIndex));
				push_back(GeoPoint(it->data(lonIndex)*180/3.14,
				it->data(latIndex)*180/3.14,
				it->data(valueIndex)));
			}
		}
	}
	else
	{
		for (; it != oda.end(); ++it, row++) 
		{
			double lat = it->data(latIndex)*180/3.14;
			double lon = it->data(lonIndex)*180/3.14;
			if ( transformation.in(lon, lat)  ) {
				CustomisedPoint* point = new CustomisedPoint();		
				point->longitude(lon);
				point->latitude(lat);
				statistics_.push_back(it->data(valueIndex));
				push_back(GeoPoint(it->data(lonIndex)*180/3.14,
				it->data(latIndex)*180/3.14,
				it->data(valueIndex)));
			}
			
			if (row >= nb_rows_)
			{
				break;
			}
		}
	}
 
	Log::info() <<  "Number of rows: " << row << endl;
}
void OdaDecoder:: visit(TextVisitor& title)
{
	if ( !title_.empty() )
		title.add(new TextEntry(title_));
	title.add(new TextEntry("OdbDatabase: " + path_));
	double min = *std::min_element(statistics_.begin(), statistics_.end());
	double max = *std::max_element(statistics_.begin(), statistics_.end());
	title.add(new TextEntry("Min: " + tostring(min) + "  Max: " + tostring(max) + "    ( " + tostring(statistics_.size()) + " points) " ));
}



void OdaDecoder::customisedPoints(const std::set<string>&, CustomisedPointsList& list)
{
     oda_init();
	   
     ODA oda(path_);

		ODA::iterator it = oda.begin(false, true);

		size_t latIndex = it.columns().columnIndex(latitude_);
		size_t lonIndex = it.columns().columnIndex(longitude_);
		size_t valueIndex = it.columns().columnIndex(value_);	
		size_t xIndex = it.columns().columnIndex(x_);	
		size_t yIndex = it.columns().columnIndex(y_);	
		
		Log::info() <<  "Indices: " << latIndex << " " << lonIndex << " " << valueIndex << endl;

		unsigned int row=0;
		if(nb_rows_== -1)
		{
			for (; it != oda.end(); ++it, row++) 
			{			
				double lat = it->data(latIndex)*180/3.14;
				double lon = it->data(lonIndex)*180/3.14;
				
									CustomisedPoint* point = new CustomisedPoint();		
									point->longitude(lon);
									point->latitude(lat);
				
									(*point)["x_component"] = it->data(xIndex);
									(*point)["y_component"] = it->data(yIndex);
									(*point)["colour_component"] = it->data(valueIndex);
									statistics_.push_back(it->data(valueIndex));
									list.push_back(point);		
			
			}
					
		}
		else
		{
			for (; it != oda.end(); ++it, row++) 
			{
				
				double lat = it->data(latIndex)*180/3.14;
				double lon = it->data(lonIndex)*180/3.14;
			
								CustomisedPoint* point = new CustomisedPoint();		
								point->longitude(lon);
								point->latitude(lat);
								(*point)["x_component"] = it->data(xIndex); 
								(*point)["y_component"] = it->data(yIndex);
								(*point)["colour_component"] = it->data(valueIndex);
								list.push_back(point);	
								statistics_.push_back(it->data(valueIndex));	
				
				if(row >= nb_rows_)
				{
					break;
				}
			}
		}
	 
		Log::info() <<  "Number of rows: " << row << endl;
	
}

void OdaDecoder::customisedPoints(const Transformation& transformation, const std::set<string>&, CustomisedPointsList& list)
{
     oda_init();
	   
     ODA oda(path_);

		ODA::iterator it = oda.begin(false, true);

		size_t latIndex = it.columns().columnIndex(latitude_);
		size_t lonIndex = it.columns().columnIndex(longitude_);
		size_t valueIndex = it.columns().columnIndex(value_);	
		size_t xIndex = it.columns().columnIndex(x_);	
		size_t yIndex = it.columns().columnIndex(y_);	
		
		Log::info() <<  "Indices: " << latIndex << " " << lonIndex << " " << valueIndex << endl;

		unsigned int row=0;
		
		if(nb_rows_== -1)
		{
			for (; it != oda.end(); ++it, row++) 
			{			
				
				double lat = it->data(latIndex)*180/3.14;
				double lon = it->data(lonIndex)*180/3.14;
				if ( transformation.in(lon, lat)  ) {
					CustomisedPoint* point = new CustomisedPoint();		
					point->longitude(lon);
					point->latitude(lat);
					statistics_.push_back(it->data(valueIndex));
					(*point)["x_component"] = it->data(xIndex);
					(*point)["y_component"] = it->data(yIndex);
					(*point)["colour_component"] = it->data(valueIndex);
					list.push_back(point);		
					
				}
			}
					
		}
		else
		{
			for (; it != oda.end(); ++it, row++) 
			{
				CustomisedPoint* point = new CustomisedPoint();		
				 double lat = it->data(latIndex)*180/3.14;
				double lon = it->data(lonIndex)*180/3.14;
				if ( transformation.in(lon, lat)  ) {							  
								point->longitude(lon);
								point->latitude(lat);
								(*point)["x_component"] = it->data(xIndex); 
								(*point)["y_component"] = it->data(yIndex);
								(*point)["colour_component"] = it->data(valueIndex);
								list.push_back(point);	
								statistics_.push_back(it->data(valueIndex));
				}
				if(row >= nb_rows_)
				{
					break;
				}
			}
		}
	 
		Log::info() <<  "Number of rows: " << row << endl;
		
		
	
}
