/*! \file SceneVisitor.cc
    \brief Implementation of the Template class SceneVisitor.
    
    Magics Team - ECMWF 2008
    
    Started: Mon 29-Dec-2008
    
    Changes:
    
*/



#include "SceneVisitor.h"
#include "BaseDriver.h"
#include "AnimationRules.h"
#include "Transformation.h"

using namespace magics;

SceneVisitor::SceneVisitor() 
{
}


SceneVisitor::~SceneVisitor() 
{
}

bool SceneVisitor::reproject(BasicGraphicsObjectContainer&) const
{
	return true;
}

void  LayoutVisitor::redisplay(const BaseDriver& driver) const
{
	driver.redisplay(*this);
}

/*!
 Class information are given to the output-stream.
*/		
void SceneVisitor::print(ostream& out)  const
{
	out << "SceneVisitor[";
	out << "]";
}

DrawingVisitor::DrawingVisitor() 
{
	name("drawing");
}


DrawingVisitor::~DrawingVisitor() 
{
}

Layout* DrawingVisitor::execute(AnimationStep& step,  const Layout* visitor)
{
	if ( this != visitor ) {
		Log::dev() << "DrawingVisitor::execute--> Nothing to do" << endl;
		return 0;
	}
	Log::dev() << "YOUPIII--> jsut need to implement!" << endl;
	// Clone the drawing..
	DrawingVisitor* drawing = new DrawingVisitor();
	drawing->parent_ = const_cast<DrawingVisitor * >(this);

	drawing->transformation(transformation_);
	//Visitr the step!
	step.visit(*drawing);
	
	return drawing;
}

void LayoutVisitor::print(ostream& out) const
{
    out << "LayoutVisitor[";
    Layout::print(out);
    out << "]";
}

HorizontalAxisVisitor::HorizontalAxisVisitor(const DrawingVisitor&)
{	
}

HorizontalAxisVisitor::~HorizontalAxisVisitor()
{
}

VerticalAxisVisitor::VerticalAxisVisitor(const DrawingVisitor&)
{
}

VerticalAxisVisitor::~VerticalAxisVisitor()
{
}

void VerticalAxisVisitor::tick(double&, double&)
{
}

void VerticalAxisVisitor::minortick(double&, double&) {}
double VerticalAxisVisitor::offsetTickLabel(double, int) { return 0; }
double VerticalAxisVisitor::angleTickLabel() {return 0;}
double VerticalAxisVisitor::angleTitle() {return 0;}
double VerticalAxisVisitor::offsetTitle() {return 0;}

void HorizontalAxisVisitor::tick(double&, double&) {}
void HorizontalAxisVisitor::minortick(double&, double&) {}
double HorizontalAxisVisitor::offsetTickLabel(double, int) {return 0;}
double HorizontalAxisVisitor::angleTickLabel() {return 0;}
double HorizontalAxisVisitor::angleTitle() {return 0;}
double HorizontalAxisVisitor::offsetTitle() {return 0;} 

TopAxisVisitor::TopAxisVisitor(const DrawingVisitor& drawing): 
    HorizontalAxisVisitor(drawing)
{
	name("top");
	drawing.transformation(*this);
}

TopAxisVisitor::~TopAxisVisitor()
{
}

BottomAxisVisitor::BottomAxisVisitor(const DrawingVisitor& drawing): 
    HorizontalAxisVisitor(drawing)
{
	name("bottom");
	drawing.transformation(*this);
}

BottomAxisVisitor::~BottomAxisVisitor()
{
}

RightAxisVisitor::RightAxisVisitor(const DrawingVisitor& drawing): 
    VerticalAxisVisitor(drawing)
{
	name("right");
	drawing.transformation(*this);
}

RightAxisVisitor::~RightAxisVisitor()
{
}

LeftAxisVisitor::LeftAxisVisitor(const DrawingVisitor& drawing):
    VerticalAxisVisitor(drawing)
{
	name("left");
	drawing.transformation(*this);
}

LeftAxisVisitor::~LeftAxisVisitor()
{
}

void LeftAxisVisitor::tick(double& x1, double& x2)
{
	double length =  ((xmax_ - xmin_)/absoluteWidth()) * 0.2; 
	x2 = xmax_;
	x1 = xmax_ - length;
}

void LeftAxisVisitor::minortick(double& x1, double& x2)
{
	double length =  ((xmax_ - xmin_)/absoluteWidth()) * 0.1; 
	x2 = xmax_;
	x1 = xmax_ - length;
}

double  LeftAxisVisitor::offsetTickLabel(double, int level)
{
	return xmax_ -  ((xmax_ - xmin_)/absoluteWidth()) * 0.3 * (level+1); 
}

double  LeftAxisVisitor::angleTickLabel()
{
	return 0;
}

double  LeftAxisVisitor::angleTitle()
{
	return 3*3.14/2;
}

double  LeftAxisVisitor::offsetTitle()
{
	return xmin_;
}

void RightAxisVisitor::tick(double& x1, double& x2)
{
	double length =  ((xmax_ - xmin_)/absoluteWidth()) * 0.2; 
	x2 = xmin_;
	x1 = x2 + length;
}

void RightAxisVisitor::minortick(double& x1, double& x2)
{
	double length =  ((xmax_ - xmin_)/absoluteWidth()) * 0.1; 
	x2 = xmin_;
	x1 = x2 + length;
}

double  RightAxisVisitor::offsetTickLabel(double, int level)
{
	return xmin_ +  ((xmax_ - xmin_)/absoluteWidth()) * 0.4 * (level+1); 
}

double  RightAxisVisitor::angleTickLabel()
{
	return 0;
}

double  RightAxisVisitor::angleTitle()
{
	return 3.14/2;
}

double  RightAxisVisitor::offsetTitle()
{
	return xmax_;
}

void TopAxisVisitor::tick(double& y1, double& y2)
{
	double length =  ((ymax_ - ymin_)/absoluteHeight()) * 0.18; 
	y2 = ymin_;
	y1 = y2 + length;
}

void TopAxisVisitor::minortick(double& y1, double& y2)
{
	double length =  ((ymax_ - ymin_)/absoluteHeight()) * 0.1; 
	y2 = ymin_;
	y1 = y2 + length;
}

double  TopAxisVisitor::offsetTickLabel(double height, int level)
{
	return   ymin_ + ((ymax_ - ymin_)/absoluteHeight() * height* 1.25 * (level+1)); 
}

double  TopAxisVisitor::angleTickLabel()
{
	return 0;
}

double  TopAxisVisitor::angleTitle()
{
	return 0;
}

double  TopAxisVisitor::offsetTitle()
{
	return ymax_;
}

void BottomAxisVisitor::tick(double& y1, double& y2)
{
	double length =  ((ymax_ - ymin_)/absoluteHeight()) * 0.15; 
	y2 = ymax_;
	y1 = y2 - length;
}

void BottomAxisVisitor::minortick(double& y1, double& y2)
{
	double length =  ((ymax_ - ymin_)/absoluteHeight()) * 0.1; 
	y2 = ymax_;
	y1 = y2 - length;
}

double  BottomAxisVisitor::offsetTickLabel(double height, int level)
{
	return   ymax_ - ((ymax_ - ymin_)/absoluteHeight() * height* 1.25 *(level+1)); 
}

double  BottomAxisVisitor::angleTickLabel()
{
	return 0;
}

double  BottomAxisVisitor::angleTitle()
{
	return 0;
}

double  BottomAxisVisitor::offsetTitle()
{
	return ymin_;
}
