# Helpers for the tessts
#
# Author: Facundo Batista <facundo@taniquetil.com.ar>
#
# Copyright 2010 Chicharreros
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Helpers for the tests."""

import logging


class MementoHandler(logging.Handler):
    """A handler class which store logging records in a list."""

    def __init__(self, *args, **kwargs):
        """Create the instance, and add a records attribute."""
        logging.Handler.__init__(self, *args, **kwargs)
        self.records = []

    def emit(self, record):
        """Just add the record to self.records."""
        self.records.append(record)

    def check(self, level, *msgs):
        """Check that something is logged."""
        for rec in self.records:
            if rec.levelname == level and all(m in rec.message for m in msgs):
                return True
        return False

    def check_error(self, *msgs):
        """Shortcut for ERROR check."""
        return self.check('ERROR', *msgs)

    def check_info(self, *msgs):
        """Shortcut for INFO check."""
        return self.check('INFO', *msgs)

    def check_debug(self, *msgs):
        """Shortcut for DEBUG check."""
        return self.check('DEBUG', *msgs)
