function gfxInitMouse(el) {
    el.onmousedown = gfxMouseDown;
    el.onmouseleave = gfxMouseLeave;
    el.onmouseup = gfxMouseUp;
    el.onmousemove = gfxMouseMove;
    el.onclick = gfxMouseClick;
}

function gfxInitData(el) {
    if (el.namespaceURI!="http://www.w3.org/2000/svg") return;
    if (el.classList.contains("gfxauto")) return;
    if (!el.gfxdata) {
	el.gfxdata={};
	for (var v in el.dataset)
	    el.gfxdata[v]=eval("("+el.dataset[v]+")");
	// just in case, start the computation of matrices... (see gfxRecompute() for details)
	var mat = el.gfxdata.pmatrix? el.gfxdata.pmatrix : el.parentElement.gfxdata.cmatrix;
	if (!el.gfxdata.matrix) el.gfxdata.cmatrix = mat; else { el.gfxdata.cmatrix = new Matrix(el.gfxdata.matrix); el.gfxdata.cmatrix.leftmultiply(mat); }
	checkData(el);
	for (var i=0; i<el.children.length; i++)
	    gfxInitData(el.children[i]);
    }
}

// auto-rotation button
function gfxToggleRotation(event) {
    //    this.blur();
    //    var svgel=document.getElementById(svgid);
    //    if (!svgel) return;
    var svgel = this.parentElement; // weak but works
    if (!svgel.gfxdata) gfxInitData(svgel);
    if (!this.ondblclick) this.ondblclick= function(event) { event.stopPropagation(); }; // weak
    
    // the perspective matrix should *always* exist

    if (!svgel.gfxdata.cmatrix) svgel.gfxdata.cmatrix = new Matrix(svgel.gfxdata.pmatrix);
    if (this.classList.contains("active")) {
	clearInterval(this.intervalId);
	this.classList.remove("active");
    }
    else
    {
	this.classList.add("active");
	this.intervalId=setInterval(() => {
	    if ((!svgel)||(!document.body.contains(svgel))) {
		svgel=null; // for garbage collecting
		this.classList.remove("active");
		clearInterval(this.intervalId);
	    } else {
		gfxAutoRotate(svgel);
		gfxRecompute(svgel);
	    }
	},50);
    }
    event.stopPropagation();
}

var mouseDown=false;

// mouse handling
function gfxMouseDown(event) {
    if (!this.gfxdata) gfxInitData(this);
    if (!this.onmouseup) gfxInitMouse(this); // weak
    mouseDown=true;
    event.preventDefault();
    event.stopPropagation();
}

function gfxMouseUp(event) {
    mouseDown=false;
    event.preventDefault();
    event.stopPropagation();
}

function gfxMouseLeave(event) {
    mouseDown=false;
    event.preventDefault();
    event.stopPropagation();
}

function gfxMouseMove(event) {
    if (!mouseDown) return;

    var x=event.movementX/this.width.baseVal.value;
    var y=event.movementY/this.height.baseVal.value;

    var d=x*x+y*y;
    x*=1+d/3; y*=1+d/3; // nonlinear correction

    var mat=new Matrix([[1-x*x+y*y,2*x*y,2*x,0],[2*x*y,1+x*x-y*y,-2*y,0],[-2*x,2*y,1-x*x-y*y,0],[0,0,0,1+x*x+y*y]]);
    mat.leftmultiply(1/(1+x*x+y*y));
    gfxRotate(this,mat);

    gfxRecompute(this);

    event.preventDefault();
    event.stopPropagation();
}

function gfxMouseClick(event) {
    event.stopPropagation();
}


function gfxAutoRotate(el) {
    if (el.namespaceURI!="http://www.w3.org/2000/svg"||el.classList.contains("gfxauto")) return;
    gfxAutoRotateInt(el,el.gfxdata.dmatrix);
    for (var i=0; i<el.children.length; i++) gfxAutoRotate(el.children[i]);
}
function gfxAutoRotateInt(el,dmatrix) { // returns true if can move to next in list
    if (!dmatrix) return true;
    else if (dmatrix instanceof Matrix) { gfxRotate(el,dmatrix); return true; } // single
    else if ((dmatrix instanceof Array)&&(dmatrix.length>0)) { // list
	if (!dmatrix.index) dmatrix.index=0;
	if (gfxAutoRotateInt(el,dmatrix[dmatrix.index])) {
	    dmatrix.index++;
	    if (dmatrix.index==dmatrix.length) { dmatrix.index=0; return true; } else return false;
	} else return false;
    } else { // repeated
	if (!dmatrix.index) dmatrix.index=0;
	if (gfxAutoRotateInt(el,dmatrix.content)) {
	    dmatrix.index++;
	    if (dmatrix.index==dmatrix.number) { dmatrix.index=0; return true; } else return false;
	} else return false;
    }
}

function gfxRotate(el,mat) {
    if (el.namespaceURI!="http://www.w3.org/2000/svg"||el.classList.contains("gfxauto")) return;
    if (!el.gfxdata.matrix) el.gfxdata.matrix = new Matrix(mat); else el.gfxdata.matrix.leftmultiply(mat);
}

function gfxRecompute(el) {
    if (el.namespaceURI!="http://www.w3.org/2000/svg"||el.classList.contains("gfxauto")) return; // gadgets and non svg aren't affected by transformations
    var mat;
    if (el.gfxdata.pmatrix) mat = el.gfxdata.pmatrix; else { // if not unmoving, get the ancestors' cmatrix
	var el1=el.parentElement;
	if (!el1.gfxdata.cmatrix) return; // shouldn't happen
	mat = el1.gfxdata.cmatrix;
    }
    // cmatrix is the compound rotation matrix (just an optimization to avoid repeated multiplications)
    // at the end of the day "cmatrix" is the *ordered* product over ancestors of matrices "matrix" (plus the leftmost perspective matrix "pmatrix"
    if (!el.gfxdata.matrix) el.gfxdata.cmatrix = mat; else { el.gfxdata.cmatrix = new Matrix(el.gfxdata.matrix); el.gfxdata.cmatrix.leftmultiply(mat); }

    if ((el.tagName=="polyline")||(el.tagName=="polygon")||(el.tagName=="path")) {
	var pth,s,coords,distance;
	// parse path
	s = ""; coords=[]; distance=0; var flag=false;
	for (var j=0; j<el.gfxdata.coords.length; j++) {
	    if (el.gfxdata.coords[j] instanceof Float32Array) {
		var u=el.gfxdata.cmatrix.vectmultiply(el.gfxdata.coords[j]);
		if (u[3]<=0) flag=true; else {
		    var v=[u[0]/u[3],u[1]/u[3]];
		    coords.push(u);
		    s+=v[0]+" "+v[1]+" ";
		    distance+=u[2]; // not homogenous?
		}
	    }
	    else s+=el.gfxdata.coords[j]+" ";
	}
	if (flag) el.style.display="none"; else {
	    el.style.display="";
	    // rewrite "d" or "points"
	    if (el.tagName=="path") el.setAttribute("d",s); else el.setAttribute("points",s);
	    // recompute distance as average of distances of vertices
	    el.gfxdata.distance=distance/coords.length;
	    if (coords.length>2) {
		var det = coords[0][2]*coords[1][1]*coords[2][0]-coords[0][1]*coords[1][2]*coords[2][0]-coords[0][2]*coords[1][0]*coords[2][1]+coords[0][0]*coords[1][2]*coords[2][1]+coords[0][1]*coords[1][0]*coords[2][2]-coords[0][0]*coords[1][1]*coords[2][2]; // TODO optimize
		// visibility
		if (el.gfxdata.onesided) {
		    if (det<0) { el.style.visibility="hidden"; return; } else el.style.visibility="visible";
		}
		// lighting
		var lightname = el.getAttribute("filter");
		if (lightname) {
		    lightname=lightname.substring(5,lightname.length-1); // eww. what is correct way??
		    var lightel=document.getElementById(lightname);
		    var u=[coords[1][0]-coords[0][0],coords[1][1]-coords[0][1],coords[1][2]-coords[0][2]];
		    var v=[coords[2][0]-coords[0][0],coords[2][1]-coords[0][1],coords[2][2]-coords[0][2]];
		    var w=[u[1]*v[2]-v[1]*u[2],u[2]*v[0]-v[2]*u[0],u[0]*v[1]-v[0]*u[1]];
		    var w2=w[0]*w[0]+w[1]*w[1]+w[2]*w[2];
		    for (var j=0; j<lightel.children.length; j++)
			if (lightel.children[j].tagName == "feSpecularLighting") {
			    var lightel2=lightel.children[j].firstElementChild; // eww
			    // move the center of the light to its mirror image in the plane of the polygon
			    //var origin=document.getElementById(lightel2.gfxdata.origin);
			    var origin=lightel2.gfxdata.origin; // eval acts as getElementById
			    if (!origin.gfxdata.pcenter) gfxRecompute(origin); // hopefully won't create infinite loops
			    var light = new Float32Array(origin.gfxdata.pcenter); // phew
			    var sp = w[0]*(light[0]-coords[0][0])+w[1]*(light[1]-coords[0][1])+w[2]*(light[2]-coords[0][2]);
			    var c = 2*sp/w2;
			    var p = light[2]/light[3]; // eww
			    for (var i=0; i<3; i++) light[i]-=c*w[i];
			    if (det<0) sp=-sp;
			    if (sp<0) lightel.children[j].setAttribute("lighting-color","#000000"); else {
				lightel.children[j].setAttribute("lighting-color",origin.style.fill);
				lightel2.setAttribute("x",light[0]*p/light[2]);
				lightel2.setAttribute("y",light[1]*p/light[2]);
				lightel2.setAttribute("z",sp/Math.sqrt(w2));
			    }
			}
		}
	    }
	}
    }
    else if (el.tagName=="line") {
	var u1=el.gfxdata.cmatrix.vectmultiply(el.gfxdata.point1);
	var u2=el.gfxdata.cmatrix.vectmultiply(el.gfxdata.point2);
	if ((u1[3]<=0)||(u2[3]<=0)) el.style.display="none"; else {
	    el.style.display="";
	    var v1=[u1[0]/u1[3],u1[1]/u1[3]];
	    var v2=[u2[0]/u2[3],u2[1]/u2[3]];
	    el.gfxdata.distance=0.5*(u1[2]+u2[2]);
	    el.setAttribute("x1",v1[0]);
	    el.setAttribute("y1",v1[1]);
	    el.setAttribute("x2",v2[0]);
	    el.setAttribute("y2",v2[1]);
	}
    }
    else if ((el.tagName=="text")||(el.tagName=="foreignObject")) {
	if (!el.gfxdata.fontsize) el.gfxdata.fontsize=14;
	var u=el.gfxdata.cmatrix.vectmultiply(el.gfxdata.point);
	if (u[3]<=0) el.style.display="none"; else {
	    el.style.display="";
	    var v=[u[0]/u[3],u[1]/u[3]];
	    el.gfxdata.distance=u[2];
	    el.setAttribute("x",v[0]);
	    el.setAttribute("y",v[1]);
	    // rescale font size
	    el.style.fontSize = el.gfxdata.fontsize/u[3]+"px"; // chrome doesn't mind absence of units but firefox does
	}
    }
    else if ((el.tagName=="circle")||(el.tagName=="ellipse")) {
	var u=el.gfxdata.cmatrix.vectmultiply(el.gfxdata.center);
	el.gfxdata.pcenter = u; // in case someone needs it ... (light)
	if (u[3]<=0) el.style.display="none"; else {
	    el.style.display="";
	    var v=[u[0]/u[3],u[1]/u[3]];
	    el.gfxdata.distance=u[2];
	    el.setAttribute("cx",v[0]);
	    el.setAttribute("cy",v[1]);
	    // also, rescale radius
	    if (el.tagName=="circle")
		el.setAttribute("r", el.gfxdata.r/u[3]);
	    else {
		el.setAttribute("rx", el.gfxdata.rx/u[3]);
		el.setAttribute("ry", el.gfxdata.ry/u[3]);
	    }
	}
    }
    else if ((el.tagName=="svg")||(el.tagName=="g")) {
	// must call inductively children's
	for (var i=0; i<el.children.length; i++) gfxRecompute(el.children[i]);
	gfxReorder(el);
	// recompute distance as average of distances of children
	el.gfxdata.distance=0; var cnt = 0;
	for (var i=0; i<el.children.length; i++)
	    if (el.children[i].gfxdata) {
		el.gfxdata.distance+=el.children[i].gfxdata.distance;
		cnt++;
	    }
	if (cnt>0) el.gfxdata.distance/=cnt;
    }
    else el.gfxdata.distance=0; // bit of a hack -- for filters...
}

function gfxReorder(el) {
    if (el.namespaceURI!="http://www.w3.org/2000/svg") return;
    if ((el.tagName=="svg")||(el.tagName=="g")) {
	// order children according to distance
	for (i=1; i<el.children.length; i++) if (el.children[i].gfxdata) {
	    var child = el.children[i];
	    j=i; while ((j>0)&&(child.gfxdata.distance>el.children[j-1].gfxdata.distance)) j--;
	    if (j<i) el.insertBefore(child,el.children[j]);
	}
    }
}

function checkData(el) {
    var mat = el.gfxdata.cmatrix.transpose();
    if ((el.tagName=="polyline")||(el.tagName=="polygon")) {
	if (!el.gfxdata.coords) {
	    var pts = el.points;
	    el.gfxdata.coords = [];
	    for (var i=0; i<pts.length; i++)
		el.gfxdata.coords.push(mat.vectmultiply(vector([pts[i].x,pts[i].y,0,1])));
	}
    }
    else if (el.tagName=="path") {
	if (!el.gfxdata.coords) {
	    var path = el.getAttribute("d").split(" "); // for lack of better
	    el.gfxdata.coords=[];
	    for (var i=0; i<path.length; i++)
		if ( path[i] >= "A" && path[i] <= "Z" ) el.gfxdata.coords.push(path[i]);
	    else {
		el.gfxdata.coords.push(mat.vectmultiply(vector([+path[i],+path[i+1],0,1])));
		i++;
	    }
	}
    }
    else if (el.tagName=="line") {
	if (!el.gfxdata.point1 || !el.gfxdata.point2) {
	    el.gfxdata.point1=mat.vectmultiply(vector([el.x1.baseVal.value,el.y1.baseVal.value,0,1]));
	    el.gfxdata.point2=mat.vectmultiply(vector([el.x2.baseVal.value,el.y2.baseVal.value,0,1]));
	}
    }
    else if (el.tagName=="text") {
	if (!el.gfxdata.point) {
	    el.gfxdata.point=mat.vectmultiply(vector([el.x.baseVal[0].value,el.y.baseVal[0].value,0,1])); // weird
	    el.gfxdata.fontsize=el.style.fontSize.substring(0,el.style.fontSize.length-2);
	}
    }
    else if (el.tagName=="foreignObject") {
	if (!el.gfxdata.point) {
	    el.gfxdata.point=mat.vectmultiply(vector([el.x.baseVal.value,el.y.baseVal.value,0,1]));
	    el.gfxdata.fontsize=el.style.fontSize.substring(0,el.style.fontSize.length-2);
	}
    }
    else if (el.tagName=="circle") {
	if (!el.gfxdata.center) {
	    el.gfxdata.center=mat.vectmultiply(vector([el.cx.baseVal.value,el.cy.baseVal.value,0,1]));
	    el.gfxdata.r=el.r.baseVal.value;
	}
    }
    else if (el.tagName=="ellipse") {
	if (!el.gfxdata.center) {
	    el.gfxdata.center=mat.vectmultiply(vector([el.cx.baseVal.value,el.cy.baseVal.value,0,1]));
	    el.gfxdata.rx=el.rx.baseVal.value;
	    el.gfxdata.ry=el.ry.baseVal.value;
	}
    }
}

// a simple square matrix type
var dim=4;
var matrix_identity=new Array(dim); for (var i=0; i<dim; i++) { matrix_identity[i]=new Array(dim); for (var j=0; j<dim; j++) if (i==j) matrix_identity[i][j]=1.; else matrix_identity[i][j]=0.; }

class Vector extends Float32Array {
    constructor(v) {
	if ((v instanceof Array)&&(v.length===dim))
	    super(v);
	else
	    super(dim);
    }
    add(v)
    {
	if (v instanceof Vector)
	{
	    for (var i=0; i<dim; i++)
		this[i]+=v[i];
	}
    }
}

function doubleArrayToFloat32Array(mat,fl) // used internally
{
    var i,j;
    for (i=0; i<dim; i++)
	for (j=0; j<dim; j++)
	    fl[i+dim*j]=mat[i][j]; // note the transposition to conform to openGL's silly convention
    return fl;
}

class Matrix extends Float32Array {
    constructor(mat) // simple constructor
    {
	if (typeof(mat)=='number') // a number means multiple of identity
	{
	    super(dim*dim);
	    doubleArrayToFloat32Array(matrix_identity,this);
	    this.leftmultiply(mat);
	}
	else if (mat instanceof Array)
	{
	    super(dim*dim);
	    doubleArrayToFloat32Array(mat,this);
	}
	else if (mat instanceof Float32Array)
	{
	    super(mat);
	}
	else super(dim*dim);
    }

    // Returns element (i,j) of the matrix
    e(i,j) { return this[i+dim*j]; }

    zero()
    {
	this.fill(0);
    }

    // display
    print()
    { 
	a="{"; 
	for (var i=0; i<dim; i++)
	    {
		a+="{";
		for (var j=0; j<dim; j++)
		    {
			a+=this.e(i,j);
			if (j<dim-1) a+=",";
		    }
		a+="}";
		if (i<dim-1) a+=",";
	    }
	a+="}";
	return a;
    }

    // add another matrix or a scalar (multiple of identity)
    add(mat)
    {
	if (typeof(mat)=='number')
	    {
		for (var i=0; i<dim; i++)
		    this[i*(dim+1)]+=mat;
	    }
	else if (mat instanceof Matrix)
	    {
		for (var i=0; i<dim*dim; i++)
		    this[i]+=mat[i];
	    }
    }

    // left multiply by a matrix or scalar
    leftmultiply(mat)
    {
	if (typeof(mat)=='number')
	    {
		for (var i=0; i<dim*dim; i++)
		    this[i]*=mat;
	    }
	else if (mat instanceof Matrix)
	    {
		var temp=new Matrix(this); // it's assumed mat is *not* this
		this.zero();
		for (var i=0; i<dim; i++)
		    for (var j=0; j<dim; j++)
			for (var k=0; k<dim; k++)
			    this[i+dim*k]+=mat[i+dim*j]*temp[j+dim*k];
	    }
    }

    vectmultiply(vec)
    {
	var u=new Vector();
	for (var k=0; k<dim; k++)
	{
	    for (var l=0; l<dim; l++)
		u[k]+=this[k+dim*l]*vec[l];
	}
	return u;
    }

    transpose()
    {
	var m=new Matrix();
	for (var i=0; i<dim; i++)
	    for (var j=0; j<dim; j++)
		m[i+dim*j]=this[j+dim*i];
	return m;
    }
};

function vector(v) { return new Vector(v); }
function matrix(m) { return new Matrix(m); }
function times(n,x) { return { number: n, content: x }; }
