/* icon.c -- Icons for boot menu of Atari LILO
 *
 * Copyright (C) 1997 Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 *
 * This program is free software.  You can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation: either version 2 or
 * (at your option) any later version.
 * 
 * $Id: icon.c,v 1.2 1998/03/02 13:08:52 rnhodek Exp $
 * 
 * $Log: icon.c,v $
 * Revision 1.2  1998/03/02 13:08:52  rnhodek
 * Don't include this file if NO_GUI is defined.
 *
 * Revision 1.1  1997/08/12 15:27:08  rnhodek
 * Import of Amiga and newly written Atari lilo sources, with many mods
 * to separate out common parts.
 *
 * 
 */

#include "loader_config.h"
#ifndef NO_GUI

#include <vdibind.h>
#include <gemfast.h>

static unsigned short icon0data[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x00E0, 0x0000, 0x00E0, 0x0000, 
  0x01C0, 0x0000, 0x7FFF, 0xFFFC, 
  0x41C0, 0x0004, 0x37D5, 0x5548, 
  0x1B80, 0x0010, 0x0BB5, 0x5540, 
  0x0F30, 0x0020, 0x0755, 0x5540, 
  0x0737, 0xEDF6, 0x0F77, 0x7DB6, 
  0x0EB6, 0x6D9C, 0x0E77, 0x7DB6, 
  0x1C76, 0x6FB6, 0x1C37, 0x7400, 
  0x1FD0, 0x0400, 0x3FFF, 0x4800, 
  0x3FFF, 0xF000, 0x001F, 0xFC00, 
  0x0002, 0x2000, 0x0001, 0x4000, 
  0x0001, 0x4000, 0x0000, 0x8000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000
};
#define	ICON0_W	32
#define	ICON0_H	32

static unsigned short icon1data[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0004, 0x4444, 
  0x4444, 0x4444, 0x4444, 0x4000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0001, 0x0101, 
  0x0101, 0x0101, 0x0101, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x4444, 
  0x4444, 0x4444, 0x4444, 0x0000, 
  0x03FF, 0xE000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x03FF, 0xF111, 
  0x1111, 0x1111, 0x1110, 0x0000, 
  0x003E, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x003C, 0x4444, 
  0x4444, 0x4444, 0x4444, 0x0000, 
  0x003C, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x007C, 0x5151, 
  0x5151, 0x5151, 0x5150, 0x0000, 
  0x007C, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x00E0, 0x0078, 0xFFC5, 
  0xFFC7, 0xDF7C, 0x6440, 0x01E0, 
  0x0078, 0x31E0, 0xC303, 0x0E30, 
  0x67F1, 0xF8C0, 0x00F8, 0x35F5, 
  0xD757, 0x5775, 0x5F73, 0x8CC0, 
  0x00F8, 0x31F0, 0x8603, 0x0640, 
  0xCC03, 0x0CC0, 0x00F8, 0x7575, 
  0xC747, 0x47C5, 0xCD03, 0x1CCE, 
  0x00F0, 0x6138, 0x8606, 0x0381, 
  0x9BC3, 0xB9D6, 0x01F0, 0x635D, 
  0xD757, 0x5755, 0xDDE3, 0xF1A0, 
  0x01F0, 0x6319, 0x8E06, 0x0781, 
  0x9867, 0x39E0, 0x01F0, 0xE35D, 
  0x5D5F, 0x5DD7, 0x5C6E, 0x19E0, 
  0x01E0, 0xC20D, 0x0C0E, 0x09C3, 
  0x186C, 0x19E0, 0x01E0, 0xC65F, 
  0x5D5D, 0x5DD7, 0x58EC, 0x1BF2, 
  0x03E0, 0xC607, 0x0E3C, 0x30E6, 
  0x19CE, 0x3B34, 0x03E3, 0xFF57, 
  0x57F5, 0xFDF7, 0x5F83, 0xF33C, 
  0x03E0, 0x0000, 0x8080, 0x8080, 
  0x8000, 0x0000, 0x03C5, 0x5555, 
  0x5555, 0x5555, 0x5555, 0x5555, 
  0x07CF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0x07C5, 0x55D5, 
  0x5555, 0x5555, 0x5555, 0x5555, 
  0x07C0, 0x0188, 0x8888, 0x8888, 
  0x8000, 0x0000, 0x07C0, 0x0385, 
  0x5555, 0x5555, 0x0000, 0x0000, 
  0x0F80, 0x0300, 0x2020, 0x2020, 
  0x0000, 0x0000, 0x0F80, 0x0F01, 
  0x5555, 0x5555, 0x0000, 0x0000, 
  0x0FC0, 0x3F00, 0x8888, 0x8888, 
  0x0000, 0x0000, 0xFFFF, 0xFF01, 
  0x5555, 0x5554, 0x0000, 0x0000, 
  0xFFFF, 0xFE00, 0x22A2, 0x22A0, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x5555, 0x5550, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0888, 0x8888, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x1555, 0x5550, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x2AAA, 0xAAA0, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x1555, 0x5540, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0888, 0x8880, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0555, 0x5540, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x02AA, 0xAA80, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0555, 0x5500, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x00AA, 0xA800, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0155, 0x5400, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x00AA, 0xAA00, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0155, 0x5400, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x00EA, 0xA800, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0055, 0x5000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x002A, 0xA800, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0015, 0x5000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x002E, 0xE000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0015, 0x4000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x000A, 0x8000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0005, 0x4000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0006, 0x8000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0005, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0003, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000
};
#define	ICON1_W 96
#define	ICON1_H 63

static unsigned short icon2data[] = {
  0x0000, 0x0002, 0x0202, 0x0202, 
  0x0202, 0x0202, 0x0202, 0x0202, 
  0x0202, 0x0202, 0x0202, 0x0202, 
  0x0202, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0002, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2220, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2220, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0808, 0x0808, 0x0808, 0x0808, 
  0x0808, 0x0808, 0x0808, 0x0808, 
  0x0808, 0x0808, 0x0800, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2200, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0880, 0x8880, 0x8880, 0x8880, 
  0x8880, 0x8880, 0x8880, 0x8880, 
  0x8880, 0x8880, 0x8800, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2200, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0xFFFF, 
  0xFFFF, 0x0888, 0x0888, 0x0888, 
  0x0888, 0x0888, 0x0888, 0x0888, 
  0x0888, 0x0888, 0x0800, 0x0000, 
  0x0000, 0x0000, 0xFFFF, 0xFFFF, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0xFFFF, 0xFFFF, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2000, 0x0000, 0x0000, 0x0000, 
  0xFFFF, 0xFFFF, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x00FF, 
  0xFC88, 0x8888, 0x8888, 0x8888, 
  0x8888, 0x8888, 0x8888, 0x8888, 
  0x8888, 0x8888, 0x8000, 0x0000, 
  0x0000, 0x0000, 0x007F, 0xF800, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x007F, 0xF822, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x007F, 0xF800, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x007F, 
  0xF00A, 0x8A8A, 0x8A8A, 0x8A8A, 
  0x8A8A, 0x8A8A, 0x8A8A, 0x8A8A, 
  0x8A8A, 0x8A8A, 0x8000, 0x0000, 
  0x0000, 0x0000, 0x00FF, 0xF000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x00FF, 0xF022, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x00FF, 0xE000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x00FF, 
  0xE008, 0xAAA8, 0xAAA8, 0xAAA8, 
  0xAAA8, 0xAAA8, 0xAAA8, 0xAAA8, 
  0xAAA8, 0xAAA8, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x01FF, 0xE000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x01FF, 0xE002, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2222, 
  0x2222, 0x2222, 0x2222, 0x2220, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x01FF, 0xC000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0007, 0xF000, 0x0000, 0x01FF, 
  0xC002, 0x8A8A, 0x8A8A, 0x8A8A, 
  0x8A8A, 0x8A8A, 0x8A8A, 0x8A8A, 
  0x9E8A, 0x8A88, 0x0000, 0x003F, 
  0xF000, 0x0000, 0x01FF, 0xC07F, 
  0xFCFF, 0xC003, 0xFF87, 0xFF80, 
  0x7FFD, 0xFFF0, 0x7FF0, 0x1E00, 
  0x3F80, 0x007F, 0x8007, 0xE000, 
  0x0000, 0x03FF, 0xC0FF, 0xFEFF, 
  0xE223, 0xFFA7, 0xFFA2, 0x7FFF, 
  0xFFF2, 0x7FF2, 0x3E22, 0xFFE0, 
  0x01FF, 0xE003, 0xE000, 0x0000, 
  0x03FF, 0xC00F, 0xC00F, 0xE000, 
  0x3C00, 0xFC00, 0x07C0, 0x3F00, 
  0x1F00, 0x3C03, 0xF3F0, 0x03F3, 
  0xF003, 0xE000, 0x0000, 0x03FF, 
  0x8007, 0xAAAF, 0xEAAA, 0xBAAA, 
  0xFAAA, 0xAFEA, 0xBFAA, 0xBEAA, 
  0xBAAF, 0xEBF8, 0x07C0, 0xF803, 
  0xE000, 0x0000, 0x03FF, 0x800F, 
  0x801F, 0xF000, 0x3801, 0xF800, 
  0x07C0, 0x1F00, 0x3C00, 0x780F, 
  0x80F8, 0x0F80, 0xF803, 0xC000, 
  0x0000, 0x07FF, 0x800F, 0xAA3F, 
  0xFA22, 0x7A23, 0xFA22, 0x2FA2, 
  0x2FA2, 0x7A22, 0x7A3F, 0x2AF8, 
  0x1F80, 0x7807, 0xC000, 0x0000, 
  0x07FF, 0x800F, 0x801D, 0xF000, 
  0x7001, 0xF000, 0x0F80, 0x0F80, 
  0xF000, 0x703E, 0x0078, 0x1F00, 
  0x7C07, 0xC000, 0x0000, 0x07FF, 
  0x000F, 0xAABB, 0xFAAA, 0xFAAB, 
  0xFAAA, 0xAFAA, 0xAFEB, 0xEAAA, 
  0xFABE, 0xAA70, 0x1F00, 0x7807, 
  0xC000, 0x0000, 0x07FF, 0x001F, 
  0x0038, 0xF800, 0x6001, 0xF000, 
  0x0F80, 0x07C1, 0xC000, 0xF07C, 
  0x0000, 0x1F00, 0x7807, 0x801C, 
  0x0000, 0x07FF, 0x001F, 0x023A, 
  0xFE22, 0xE223, 0xE222, 0xBF22, 
  0xA7E3, 0xA222, 0xE27E, 0xA200, 
  0x1F00, 0x780F, 0x807E, 0x0000, 
  0x0FFF, 0x001F, 0x0038, 0x7C00, 
  0xE003, 0xE000, 0x1F00, 0x03E7, 
  0x0001, 0xE0F8, 0x0000, 0x1E00, 
  0xF80F, 0x80FE, 0x0000, 0x0FFE, 
  0x001F, 0x02BA, 0xFEAA, 0xEAAB, 
  0xEAAA, 0xBFAA, 0xABFE, 0xAAAB, 
  0xEAFA, 0xA800, 0x1F00, 0xF00F, 
  0x83FE, 0x0000, 0x0FFE, 0x003E, 
  0x0030, 0x3E00, 0xE003, 0xE000, 
  0x1F00, 0x01FC, 0x0003, 0xC1F8, 
  0x0000, 0x0F01, 0xF00F, 0x07FE, 
  0x0000, 0x0FFE, 0x003E, 0x027A, 
  0x3F2A, 0xEA2B, 0xEA2A, 0x3E2A, 
  0x2BFE, 0x2A2B, 0xEBFB, 0xFE00, 
  0x0787, 0xE01F, 0x0E10, 0x0000, 
  0x1FFE, 0x003E, 0x0070, 0x1F00, 
  0xC007, 0xC000, 0x3E00, 0x01F8, 
  0x0003, 0x81F7, 0xFF80, 0x03FF, 
  0x801F, 0x1C00, 0x0000, 0x1FFE, 
  0x003E, 0x00FA, 0xBFAB, 0xEAAF, 
  0xEAAA, 0xBEAA, 0xAAFA, 0xAAAF, 
  0xABFF, 0xBFC0, 0x0FFF, 0x801F, 
  0x3800, 0x0000, 0x1FFC, 0x007C, 
  0x0060, 0x0F81, 0xC007, 0xC000, 
  0x3E00, 0x01FC, 0x0007, 0x83FC, 
  0x07C0, 0x1F8F, 0xC01E, 0xF000, 
  0x0000, 0x1FFC, 0x007C, 0x00EA, 
  0xAFAB, 0xAAAF, 0xEAAA, 0xBEAA, 
  0xABFE, 0xAAAF, 0xABFA, 0x83E0, 
  0x7E03, 0xE03F, 0xE000, 0x0000, 
  0x1FFC, 0x007C, 0x00E0, 0x0FC1, 
  0x8007, 0x8000, 0x7C00, 0x03FE, 
  0x000F, 0x03F0, 0x03E0, 0x7C01, 
  0xE03F, 0xE000, 0x0000, 0x3FFC, 
  0x007C, 0x00EA, 0xAFEB, 0xAAAF, 
  0xAAAA, 0xFEAA, 0xAFBE, 0xAAAF, 
  0xABEA, 0x81E0, 0xF801, 0xF03F, 
  0xE000, 0x0000, 0x3FF8, 0x00F8, 
  0x00C0, 0x07E3, 0x800F, 0x8000, 
  0x7C00, 0x0E3F, 0x001E, 0x03E0, 
  0x01E0, 0xF000, 0xF03F, 0xE000, 
  0x0000, 0x3FF8, 0x00F8, 0x00CA, 
  0xABEB, 0xAAAF, 0xAAAA, 0xFEAA, 
  0xBEBF, 0xAABE, 0xABEA, 0x01E1, 
  0xF000, 0xF07D, 0xF000, 0x0000, 
  0x3FF8, 0x00F8, 0x01C0, 0x07F3, 
  0x040F, 0x8400, 0xFC00, 0x3C1F, 
  0x041C, 0x07E0, 0x01E1, 0xF000, 
  0xF07D, 0xF000, 0x0000, 0x7FF8, 
  0x00F8, 0x01CA, 0xABFB, 0xAAAF, 
  0xAAAA, 0xFAAA, 0xBABF, 0xAABE, 
  0xABEA, 0x03E1, 0xE001, 0xF07C, 
  0xF800, 0x0000, 0x7FF0, 0x01F0, 
  0x0180, 0x01FF, 0x000F, 0x0000, 
  0xF800, 0x700F, 0x803C, 0x03C0, 
  0x03E1, 0xE001, 0xF07C, 0xF800, 
  0x0000, 0x7FF0, 0x01F0, 0x0382, 
  0xAAFF, 0xAAAF, 0xAAAB, 0xFAAA, 
  0xEAAF, 0xEABA, 0xABE8, 0x03C1, 
  0xE001, 0xF078, 0xFC08, 0x0000, 
  0x7FF0, 0x01F0, 0x0380, 0x40FE, 
  0x400F, 0xC001, 0xF001, 0xE007, 
  0xC078, 0x43E0, 0x07C1, 0xE003, 
  0xF0F8, 0x7C0C, 0x0000, 0x7FF0, 
  0x01F0, 0x0382, 0xAAFE, 0xAAAF, 
  0xAAAB, 0xEAAB, 0xEAAF, 0xEAFA, 
  0xABE0, 0x07C1, 0xF003, 0xE0F8, 
  0x7E18, 0x0000, 0xFFF0, 0x03F0, 
  0x0780, 0x007E, 0x000F, 0xC007, 
  0xC007, 0x8003, 0xE070, 0x01F0, 
  0x0F81, 0xF007, 0xE0F8, 0x3E18, 
  0x0000, 0xFFE0, 0x03E0, 0x0780, 
  0xAABE, 0xAAAF, 0xEAAF, 0xEAAF, 
  0xAAAB, 0xFAFA, 0xAAF0, 0x1F00, 
  0xF80F, 0xC0F0, 0x3F30, 0x0000, 
  0xFFE0, 0x3FFF, 0x7FF8, 0x043E, 
  0x0407, 0xFC7F, 0x04FF, 0xF41F, 
  0xFFF4, 0x04FC, 0x7E00, 0x7E3F, 
  0x81F0, 0x1FF0, 0x0000, 0xFFE0, 
  0x3FFE, 0x7FF8, 0x2ABE, 0xAAAB, 
  0xFFFE, 0xAAFF, 0xFABF, 0xFFEA, 
  0xAABF, 0xFC00, 0x3FFE, 0x01F0, 
  0x0FE0, 0x0001, 0xFFE0, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x3FF0, 
  0x0000, 0x0000, 0x01E0, 0x001F, 
  0xF000, 0x0FF8, 0x01F0, 0x0780, 
  0x0001, 0xFFC0, 0x0000, 0x0000, 
  0x2AAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAA80, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0001, 
  0xFFC0, 0x0000, 0x0000, 0x0444, 
  0x4444, 0x4444, 0x4444, 0x4444, 
  0x4444, 0x4400, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0001, 0xFFC2, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0x0001, 0xFFC3, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x0003, 0xFF82, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0x0003, 
  0xFF83, 0x7F7F, 0x7F7F, 0x7F7F, 
  0x7F7F, 0x7F7F, 0x7F7F, 0x7F7F, 
  0x7F7F, 0x7F7F, 0x7F7F, 0x7F7F, 
  0x7F7F, 0x7F7F, 0x0003, 0xFF82, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0x0003, 0xFF83, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x0007, 0xFF02, 0xAAAA, 0xAABE, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0x0007, 
  0xFF03, 0x7777, 0x777F, 0x7777, 
  0x7777, 0x7777, 0x7777, 0x7777, 
  0x7777, 0x7777, 0x7777, 0x7777, 
  0x7777, 0x7777, 0x0007, 0xFF00, 
  0x0000, 0x003C, 0x00AA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xA000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0007, 0xFF00, 0x0000, 
  0x003C, 0x0001, 0x0001, 0x0001, 
  0x0001, 0x0001, 0x0001, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x000F, 0xFF00, 0x0000, 0x007C, 
  0x002A, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0x8000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x000F, 
  0xFE00, 0x0000, 0x007C, 0x0044, 
  0x4444, 0x4444, 0x4444, 0x4444, 
  0x4444, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x000F, 0xFE00, 
  0x0000, 0x00F8, 0x002A, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAAA, 
  0x8000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x000F, 0xFE00, 0x0000, 
  0x01F8, 0x0010, 0x1010, 0x1010, 
  0x1010, 0x1010, 0x1010, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x000F, 0xFE00, 0x0000, 0x01F8, 
  0x000A, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAAA, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x001F, 
  0xFE00, 0x0000, 0x03F0, 0x0004, 
  0x4444, 0x4444, 0x4444, 0x4444, 
  0x4444, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x001F, 0xFE00, 
  0x0000, 0x07F0, 0x000A, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAA8, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x001F, 0xFE00, 0x0000, 
  0x0FF0, 0x0001, 0x1111, 0x1111, 
  0x1111, 0x1111, 0x1110, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x003F, 0xFE00, 0x0000, 0x3FE0, 
  0x0002, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAA8, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x003F, 
  0xFF00, 0x0000, 0xFFE0, 0x0000, 
  0x4444, 0x4444, 0x4444, 0x4444, 
  0x4440, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x00FF, 0xFFF0, 
  0x001F, 0xFFE0, 0x0000, 0xAAAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAAA0, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFE0, 0x0001, 0x1511, 0x1511, 
  0x1511, 0x1511, 0x1500, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFC0, 
  0x0000, 0xAAAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAAA0, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFC0, 0x0000, 
  0x4444, 0x4444, 0x4444, 0x4444, 
  0x4440, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFC0, 0x0000, 0x2AAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAA80, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x5111, 0x5111, 
  0x5111, 0x5111, 0x5100, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x2AAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xAA00, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0444, 0x4444, 0x4444, 0x4444, 
  0x4400, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0AAA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xAA00, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0515, 0x1515, 
  0x1515, 0x1515, 0x1400, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0AAA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xA800, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0444, 0x4444, 0x4444, 0x4444, 
  0x4000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x02AA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xA800, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0155, 0x5555, 
  0x5555, 0x5555, 0x5000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x00AA, 0xAAAA, 0xAAAA, 
  0xAAAA, 0xA000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0044, 0x4444, 0x4444, 0x4444, 
  0x4000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x00AA, 
  0xAAAA, 0xAAAA, 0xAAAA, 0xA000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0055, 0x5555, 
  0x5555, 0x5555, 0x4000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x002A, 0xAAAA, 0xAAAA, 
  0xAAAA, 0x8000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0004, 0x4444, 0x4444, 0x4444, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x002A, 
  0xAAAA, 0xAAAA, 0xAAAA, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0015, 0x5555, 
  0x5555, 0x5555, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x000A, 0xAAAA, 0xAAAA, 
  0xAAAA, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0004, 0x5454, 0x5454, 0x5454, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0002, 
  0xAAAA, 0xAAAA, 0xAAA8, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0005, 0x5555, 
  0x5555, 0x5550, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0002, 0xAAAA, 0xAAAA, 
  0xAAA8, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0001, 0x4555, 0x4555, 0x4550, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0xAAAA, 0xAAAA, 0xAAA0, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x5555, 
  0x5555, 0x5540, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0xAAAA, 0xAAAA, 
  0xAA80, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x5455, 0x5455, 0x5440, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x2AAA, 0xAAAA, 0xAA80, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x1555, 
  0x5555, 0x5500, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x2AAA, 0xAAAA, 
  0xAA00, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x1555, 0x5555, 0x5400, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0AAA, 0xAAAA, 0xAA00, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0555, 
  0x5555, 0x5400, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x02AA, 0xAAAA, 
  0xA800, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0757, 0x5757, 0x5000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x02AA, 0xAAAA, 0xA000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0155, 
  0x5555, 0x5000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x00AA, 0xAAAA, 
  0xA000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0075, 0x7575, 0x6000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x00AA, 0xAAAA, 0x8000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0055, 
  0x5555, 0x4000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x002A, 0xAAAA, 
  0x8000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0017, 0x7757, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x000A, 0xAAAA, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0015, 
  0x5554, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x000A, 0xAAAA, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0007, 0x7774, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0002, 0xAAA8, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0001, 
  0x5550, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0002, 0xAAA0, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0001, 0x7770, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0xAAA0, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x5D40, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0xAA80, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x7700, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x2A80, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x1500, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0A00, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x1600, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0800, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000, 
  0x0400, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x0000
};
#define	ICON2_W	240
#define	ICON2_H	156

MFDB iconMFDB[3] = {
	{ (long)icon0data, ICON0_W, ICON0_H, ICON0_W/16, 1, 1 },
	{ (long)icon1data, ICON1_W, ICON1_H, ICON1_W/16, 1, 1 },
	{ (long)icon2data, ICON2_W, ICON2_H, ICON2_W/16, 1, 1 }
};

#endif /* NO_GUI */
