// -*- C++ -*-
/**
 *  File:        math_root.h
 *  Purpose:     Declaration of the root object
 *  Author:      Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 *  Created:     January 1999
 *  Description: Root math object
 *
 *  Copyright: 1999 Alejandro Aguilar Sierra
 *
 *   You are free to use and modify this code under the terms of
 *   the GNU General Public Licence version 2 or later.
 */

#ifndef MATH_ROOT_H
#define MATH_ROOT_H

#include "math_nestinset.h"

/** The general n-th root inset.
 *  \author Alejandro Aguilar Sierra
 *
 * Full author contact details are available in file CREDITS
    \version January 1999
 */
class MathRootInset : public MathNestInset {
public:
	///
	MathRootInset();
	///
	MathInset * clone() const;
	///
	bool idxUpDown(idx_type & idx, pos_type & pos, bool up, int targetx) const;
	///
	void metrics(MathMetricsInfo & mi) const;
	///
	void draw(MathPainterInfo & pi, int x, int y) const;

	///
	void write(WriteStream & os) const;
	///
	void normalize(NormalStream &) const;
	///
	void mathmlize(MathMLStream &) const;
	///
	void maplize(MapleStream &) const;
	///
	void octavize(OctaveStream &) const;
};

#endif
