/**
 * \file ControlCommand.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Angus Leeming
 *
 * Full author contact details are available in file CREDITS
 */

#include <config.h>

#include "ControlCommand.h"

#include "BufferView.h"
#include "funcrequest.h"
#include "lyxfunc.h"


ControlCommand::ControlCommand(LyXView & lv, Dialogs & d, kb_action ac)
	: ControlInset<InsetCommand, InsetCommandParams>(lv, d),
	  action_(ac)
{}


InsetCommandParams const ControlCommand::getParams(string const & arg)
{
	InsetCommandParams params;
	params.setFromString(arg);
	return params;
}


InsetCommandParams const ControlCommand::getParams(InsetCommand const & inset)
{
	return inset.params();
}


void ControlCommand::applyParamsToInset()
{
	inset()->setParams(params());
	bufferview()->updateInset(inset(), true);
}


void ControlCommand::applyParamsNoInset()
{
	if (action_ == LFUN_NOACTION)
		return;
	lyxfunc().dispatch(FuncRequest(action_, params().getAsString()));
}
