/* $Id: offline.h,v 1.8 2001/06/04 17:45:33 linus Exp $
 *
 * Copyright (C) 1999  Lysator Computer Club,
 *                     Linkoping University, Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author: Linus Tolke
 */

#ifndef OFFLINE_H
#define OFFLINE_H
#include "main.h"

/* Routines to write different objects. */
void fprintf_Time(FILE * fp, const Time * t);
void fprintf_Membership(FILE * fp, const Membership * ms);
void fprintf_Membership_list(FILE * fp, const Membership_list * ml);
void fprintf_String(FILE * fp, const String * s);
void fprintf_Conf_type(FILE * fp, const Conf_type * ct);
void fprintf_Conference(FILE * fp, const Conference * cs);
void fprintf_Text_list(FILE * fp, const Text_list * tl);
void fprintf_Misc_infos(FILE * fp, 
			unsigned short no_of_miscs, 
			const Misc_info * misc_items);

/* Routines to store and fetch. */
int store_person_number(Pers_no pno);
int fetch_person_number(Pers_no * pno);
int store_Membership_list(Membership_list * ml);
int fetch_Membership_list(Membership_list * ml);
int store_Conference(Conf_no cno, Conference * cs);
int fetch_Conference(Conf_no cno, Conference * cs);
int store_map(Conf_no cno, Text_list * tl, Time * ts);
int fetch_map(Conf_no cno, Text_list * tl, Time * ts);
int store_text(Text_no tno, String * tm);
int fetch_text(Text_no tno, String * tm);
int store_Text_stat(Text_no tno, Text_stat * ts);
int fetch_Text_stat(Text_no tno, Text_stat * ts);

int store_mark_in_conf(Conf_no cno, Local_text_no ltno); /* Append one */
int fetch_marks_in_conf(Conf_no cno, int * len, Local_text_no ** ltnos);
int done_with_marks_in_conf(Conf_no cno);

int store_created_text(const String message, 
		       unsigned short no_of_miscs, const Misc_info * misc);
int fetch_created_text(String * message, 
		       unsigned short * no_of_miscs, Misc_info ** misc);
int done_with_created_text(int ind);

/* Checking macro. */
#define OFFLINE1() \
xprintf(gettext("Detta kommando kan inte utfras i frnkopplat lge.\n"))

#define OFFLINE2() OFFLINE1(); RETURN (FAILURE)

#define OFFLINE()				\
if (offline)					\
{						\
    OFFLINE2();					\
}

/* Functions that "replace" cache functions. */
int offline_get_unread_confs_count(void);
Success offline_get_unread_confs(Conf_no_list *);

int offline_get_unread_confs_start(void);
Conf_no offline_get_unread_confs_next(void);
#endif
