/*
 * $Id: pom.h,v 1.2 1994/11/04 19:14:05 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 * $Id: pom.h,v 1.2 1994/11/04 19:14:05 linus Exp $
 *
 *  pom.h
 *	Calculate the phase of the moon at any given time.
 *
 *
 *  This file is in the public domain.  No rights reserved.
 */


#ifndef POM_H_INCLUDED__
#define POM_H_INCLUDED__


struct	pom {
	enum quarter { pom_NM, pom_FQ, pom_FM, pom_LQ }
			  quarter;	/* Nearest quarter */
	/* Time since nearest quarter.  All fields are negative if
	 * nearest quarter is in the future.			*/
	int		  days;
	int		  hours;
	int		  minutes;
	int		  seconds;
};


/*
 *  Calculate the phase of the moon at the time WHEN, which should be
 *  the GMT time.
 */
extern  struct pom
phase_of_the_moon (struct tm	* when);
    

#endif  /* POM_H_INCLUDED__ */
