/* dbus-gnome-session.c generated by valac 0.16.1, the Vala compiler
 * generated from dbus-gnome-session.vala, do not modify */

/* 
 *      Copyright 2011 Julien Lavergne <gilir@ubuntu.com>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */
/* http://live.gnome.org/Vala/DBusServerSample#Using_GDBus */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define LXSESSION_TYPE_GNOME_SESSION_SERVER (lxsession_gnome_session_server_get_type ())
#define LXSESSION_GNOME_SESSION_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LXSESSION_TYPE_GNOME_SESSION_SERVER, LxsessionGnomeSessionServer))
#define LXSESSION_GNOME_SESSION_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LXSESSION_TYPE_GNOME_SESSION_SERVER, LxsessionGnomeSessionServerClass))
#define LXSESSION_IS_GNOME_SESSION_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LXSESSION_TYPE_GNOME_SESSION_SERVER))
#define LXSESSION_IS_GNOME_SESSION_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LXSESSION_TYPE_GNOME_SESSION_SERVER))
#define LXSESSION_GNOME_SESSION_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LXSESSION_TYPE_GNOME_SESSION_SERVER, LxsessionGnomeSessionServerClass))

typedef struct _LxsessionGnomeSessionServer LxsessionGnomeSessionServer;
typedef struct _LxsessionGnomeSessionServerClass LxsessionGnomeSessionServerClass;
typedef struct _LxsessionGnomeSessionServerPrivate LxsessionGnomeSessionServerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _lxsession_gnome_session_server_RegisterClientData lxsession_gnome_session_server_RegisterClientData;
typedef struct _lxsession_gnome_session_server_UnregisterClientData lxsession_gnome_session_server_UnregisterClientData;

#define LXSESSION_TYPE_CONTROL_OBJECT (lxsession_control_object_get_type ())
#define LXSESSION_CONTROL_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LXSESSION_TYPE_CONTROL_OBJECT, LxsessionControlObject))
#define LXSESSION_CONTROL_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LXSESSION_TYPE_CONTROL_OBJECT, LxsessionControlObjectClass))
#define LXSESSION_IS_CONTROL_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LXSESSION_TYPE_CONTROL_OBJECT))
#define LXSESSION_IS_CONTROL_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LXSESSION_TYPE_CONTROL_OBJECT))
#define LXSESSION_CONTROL_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LXSESSION_TYPE_CONTROL_OBJECT, LxsessionControlObjectClass))

typedef struct _LxsessionControlObject LxsessionControlObject;
typedef struct _LxsessionControlObjectClass LxsessionControlObjectClass;
typedef struct _lxsession_gnome_session_server_InhibitData lxsession_gnome_session_server_InhibitData;
typedef struct _lxsession_gnome_session_server_UninhibitData lxsession_gnome_session_server_UninhibitData;

#define LXSESSION_TYPE_SESSION_OBJECT (lxsession_session_object_get_type ())
#define LXSESSION_SESSION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LXSESSION_TYPE_SESSION_OBJECT, LxsessionSessionObject))
#define LXSESSION_SESSION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LXSESSION_TYPE_SESSION_OBJECT, LxsessionSessionObjectClass))
#define LXSESSION_IS_SESSION_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LXSESSION_TYPE_SESSION_OBJECT))
#define LXSESSION_IS_SESSION_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LXSESSION_TYPE_SESSION_OBJECT))
#define LXSESSION_SESSION_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LXSESSION_TYPE_SESSION_OBJECT, LxsessionSessionObjectClass))

typedef struct _LxsessionSessionObject LxsessionSessionObject;
typedef struct _LxsessionSessionObjectClass LxsessionSessionObjectClass;
typedef struct _lxsession_gnome_session_server_CanShutdownData lxsession_gnome_session_server_CanShutdownData;

struct _LxsessionGnomeSessionServer {
	GObject parent_instance;
	LxsessionGnomeSessionServerPrivate * priv;
};

struct _LxsessionGnomeSessionServerClass {
	GObjectClass parent_class;
};

struct _LxsessionGnomeSessionServerPrivate {
	gchar* not_implemented;
	gchar* gnome_session_version;
	gint _something;
};

struct _lxsession_gnome_session_server_RegisterClientData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LxsessionGnomeSessionServer* self;
	gchar* app_id;
	gchar* client_startup_id;
	const gchar* _tmp0_;
};

struct _lxsession_gnome_session_server_UnregisterClientData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LxsessionGnomeSessionServer* self;
	const gchar* _tmp0_;
};

struct _lxsession_gnome_session_server_InhibitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LxsessionGnomeSessionServer* self;
	gchar* app_id;
	guint toplevel_xid;
	gchar* reason;
	guint flags;
	guint inhibit_cookie;
	guint _tmp0_;
	LxsessionControlObject* _tmp1_;
	LxsessionControlObject* control;
	LxsessionControlObject* _tmp2_;
	guint _tmp3_;
	guint32 _tmp4_;
	guint cookie;
	guint _tmp5_;
};

struct _lxsession_gnome_session_server_UninhibitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LxsessionGnomeSessionServer* self;
	guint inhibit_cookie;
	LxsessionControlObject* _tmp0_;
	LxsessionControlObject* control;
};

struct _lxsession_gnome_session_server_CanShutdownData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	LxsessionGnomeSessionServer* self;
	gboolean is_available;
	LxsessionSessionObject* _tmp0_;
	LxsessionSessionObject* session;
	gboolean _tmp1_;
};


static gpointer lxsession_gnome_session_server_parent_class = NULL;

GType lxsession_gnome_session_server_get_type (void) G_GNUC_CONST;
guint lxsession_gnome_session_server_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define LXSESSION_GNOME_SESSION_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), LXSESSION_TYPE_GNOME_SESSION_SERVER, LxsessionGnomeSessionServerPrivate))
enum  {
	LXSESSION_GNOME_SESSION_SERVER_DUMMY_PROPERTY,
	LXSESSION_GNOME_SESSION_SERVER_SOMETHING
};
void lxsession_gnome_session_server_Setenv (LxsessionGnomeSessionServer* self, const gchar* value);
void lxsession_gnome_session_server_InitializationError (LxsessionGnomeSessionServer* self, const gchar* mess, gboolean fatal);
static void lxsession_gnome_session_server_RegisterClient_data_free (gpointer _data);
void lxsession_gnome_session_server_RegisterClient (LxsessionGnomeSessionServer* self, const gchar* app_id, const gchar* client_startup_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void lxsession_gnome_session_server_RegisterClient_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_);
static gboolean lxsession_gnome_session_server_RegisterClient_co (lxsession_gnome_session_server_RegisterClientData* _data_);
static void lxsession_gnome_session_server_UnregisterClient_data_free (gpointer _data);
void lxsession_gnome_session_server_UnregisterClient (LxsessionGnomeSessionServer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void lxsession_gnome_session_server_UnregisterClient_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_);
static gboolean lxsession_gnome_session_server_UnregisterClient_co (lxsession_gnome_session_server_UnregisterClientData* _data_);
static void lxsession_gnome_session_server_Inhibit_data_free (gpointer _data);
void lxsession_gnome_session_server_Inhibit (LxsessionGnomeSessionServer* self, const gchar* app_id, guint toplevel_xid, const gchar* reason, guint flags, GAsyncReadyCallback _callback_, gpointer _user_data_);
void lxsession_gnome_session_server_Inhibit_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_, guint* inhibit_cookie);
static gboolean lxsession_gnome_session_server_Inhibit_co (lxsession_gnome_session_server_InhibitData* _data_);
LxsessionControlObject* lxsession_control_object_new (void);
LxsessionControlObject* lxsession_control_object_construct (GType object_type);
GType lxsession_control_object_get_type (void) G_GNUC_CONST;
void lxsession_control_object_set_status_busy (LxsessionControlObject* self, guint toplevel_xid);
static void lxsession_gnome_session_server_Uninhibit_data_free (gpointer _data);
void lxsession_gnome_session_server_Uninhibit (LxsessionGnomeSessionServer* self, guint inhibit_cookie, GAsyncReadyCallback _callback_, gpointer _user_data_);
void lxsession_gnome_session_server_Uninhibit_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_);
static gboolean lxsession_gnome_session_server_Uninhibit_co (lxsession_gnome_session_server_UninhibitData* _data_);
void lxsession_control_object_exit_status_busy (LxsessionControlObject* self);
void lxsession_gnome_session_server_Shutdown (LxsessionGnomeSessionServer* self);
LxsessionSessionObject* lxsession_session_object_new (void);
LxsessionSessionObject* lxsession_session_object_construct (GType object_type);
GType lxsession_session_object_get_type (void) G_GNUC_CONST;
void lxsession_session_object_lxsession_shutdown (LxsessionSessionObject* self);
static void lxsession_gnome_session_server_CanShutdown_data_free (gpointer _data);
void lxsession_gnome_session_server_CanShutdown (LxsessionGnomeSessionServer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void lxsession_gnome_session_server_CanShutdown_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_, gboolean* is_available);
static gboolean lxsession_gnome_session_server_CanShutdown_co (lxsession_gnome_session_server_CanShutdownData* _data_);
void lxsession_session_object_lxsession_can_shutdown (LxsessionSessionObject* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean lxsession_session_object_lxsession_can_shutdown_finish (LxsessionSessionObject* self, GAsyncResult* _res_);
static void lxsession_gnome_session_server_CanShutdown_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void lxsession_gnome_session_server_Logout (LxsessionGnomeSessionServer* self, guint mode);
void lxsession_gnome_session_server_IsSessionRunning (LxsessionGnomeSessionServer* self, gboolean* running);
LxsessionGnomeSessionServer* lxsession_gnome_session_server_new (void);
LxsessionGnomeSessionServer* lxsession_gnome_session_server_construct (GType object_type);
gint lxsession_gnome_session_server_get_something (LxsessionGnomeSessionServer* self);
void lxsession_gnome_session_server_set_something (LxsessionGnomeSessionServer* self, gint value);
static void lxsession_gnome_session_server_finalize (GObject* obj);
static void _vala_lxsession_gnome_session_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_lxsession_gnome_session_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _dbus_lxsession_gnome_session_server_Setenv (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_lxsession_gnome_session_server_InitializationError (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_lxsession_gnome_session_server_RegisterClient (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_lxsession_gnome_session_server_RegisterClient_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_lxsession_gnome_session_server_UnregisterClient (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_lxsession_gnome_session_server_UnregisterClient_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_lxsession_gnome_session_server_Inhibit (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_lxsession_gnome_session_server_Inhibit_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_lxsession_gnome_session_server_Uninhibit (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_lxsession_gnome_session_server_Uninhibit_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_lxsession_gnome_session_server_Shutdown (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_lxsession_gnome_session_server_CanShutdown (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_lxsession_gnome_session_server_CanShutdown_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_lxsession_gnome_session_server_Logout (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_lxsession_gnome_session_server_IsSessionRunning (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void lxsession_gnome_session_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* lxsession_gnome_session_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_lxsession_gnome_session_server_get_something (LxsessionGnomeSessionServer* self);
static gboolean lxsession_gnome_session_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_lxsession_gnome_session_server_set_something (LxsessionGnomeSessionServer* self, GVariant* _value);
static void _dbus_lxsession_gnome_session_server_client_added (GObject* _sender, gchar** path, gpointer* _data);
static void _dbus_lxsession_gnome_session_server_client_removed (GObject* _sender, gchar** path, gpointer* _data);
static void _dbus_lxsession_gnome_session_server_inhibitor_added (GObject* _sender, gchar** path, gpointer* _data);
static void _dbus_lxsession_gnome_session_server_inhibitor_removed (GObject* _sender, gchar** path, gpointer* _data);
static void _dbus_lxsession_gnome_session_server_session_running (GObject* _sender, gpointer* _data);
static void _dbus_lxsession_gnome_session_server_session_over (GObject* _sender, gpointer* _data);
static void _lxsession_gnome_session_server_unregister_object (gpointer user_data);

static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_Setenv_value = {-1, "value", "s"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Setenv_in[] = {&_lxsession_gnome_session_server_dbus_arg_info_Setenv_value, NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Setenv_out[] = {NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_Setenv = {-1, "Setenv", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Setenv_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Setenv_out)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_InitializationError_mess = {-1, "mess", "s"};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_InitializationError_fatal = {-1, "fatal", "b"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_InitializationError_in[] = {&_lxsession_gnome_session_server_dbus_arg_info_InitializationError_mess, &_lxsession_gnome_session_server_dbus_arg_info_InitializationError_fatal, NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_InitializationError_out[] = {NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_InitializationError = {-1, "InitializationError", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_InitializationError_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_InitializationError_out)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_RegisterClient_app_id = {-1, "app_id", "s"};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_RegisterClient_client_startup_id = {-1, "client_startup_id", "s"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_RegisterClient_in[] = {&_lxsession_gnome_session_server_dbus_arg_info_RegisterClient_app_id, &_lxsession_gnome_session_server_dbus_arg_info_RegisterClient_client_startup_id, NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_RegisterClient_out[] = {NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_RegisterClient = {-1, "RegisterClient", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_RegisterClient_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_RegisterClient_out)};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_UnregisterClient_in[] = {NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_UnregisterClient_out[] = {NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_UnregisterClient = {-1, "UnregisterClient", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_UnregisterClient_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_UnregisterClient_out)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_Inhibit_app_id = {-1, "app_id", "s"};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_Inhibit_toplevel_xid = {-1, "toplevel_xid", "u"};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_Inhibit_reason = {-1, "reason", "s"};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_Inhibit_flags = {-1, "flags", "u"};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_Inhibit_inhibit_cookie = {-1, "inhibit_cookie", "u"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Inhibit_in[] = {&_lxsession_gnome_session_server_dbus_arg_info_Inhibit_app_id, &_lxsession_gnome_session_server_dbus_arg_info_Inhibit_toplevel_xid, &_lxsession_gnome_session_server_dbus_arg_info_Inhibit_reason, &_lxsession_gnome_session_server_dbus_arg_info_Inhibit_flags, NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Inhibit_out[] = {&_lxsession_gnome_session_server_dbus_arg_info_Inhibit_inhibit_cookie, NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_Inhibit = {-1, "Inhibit", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Inhibit_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Inhibit_out)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_Uninhibit_inhibit_cookie = {-1, "inhibit_cookie", "u"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Uninhibit_in[] = {&_lxsession_gnome_session_server_dbus_arg_info_Uninhibit_inhibit_cookie, NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Uninhibit_out[] = {NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_Uninhibit = {-1, "Uninhibit", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Uninhibit_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Uninhibit_out)};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Shutdown_in[] = {NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Shutdown_out[] = {NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_Shutdown = {-1, "Shutdown", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Shutdown_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Shutdown_out)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_CanShutdown_is_available = {-1, "is_available", "b"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_CanShutdown_in[] = {NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_CanShutdown_out[] = {&_lxsession_gnome_session_server_dbus_arg_info_CanShutdown_is_available, NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_CanShutdown = {-1, "CanShutdown", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_CanShutdown_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_CanShutdown_out)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_Logout_mode = {-1, "mode", "u"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Logout_in[] = {&_lxsession_gnome_session_server_dbus_arg_info_Logout_mode, NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_Logout_out[] = {NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_Logout = {-1, "Logout", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Logout_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_Logout_out)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_IsSessionRunning_running = {-1, "running", "b"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_IsSessionRunning_in[] = {NULL};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_IsSessionRunning_out[] = {&_lxsession_gnome_session_server_dbus_arg_info_IsSessionRunning_running, NULL};
static const GDBusMethodInfo _lxsession_gnome_session_server_dbus_method_info_IsSessionRunning = {-1, "IsSessionRunning", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_IsSessionRunning_in), (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_IsSessionRunning_out)};
static const GDBusMethodInfo * const _lxsession_gnome_session_server_dbus_method_info[] = {&_lxsession_gnome_session_server_dbus_method_info_Setenv, &_lxsession_gnome_session_server_dbus_method_info_InitializationError, &_lxsession_gnome_session_server_dbus_method_info_RegisterClient, &_lxsession_gnome_session_server_dbus_method_info_UnregisterClient, &_lxsession_gnome_session_server_dbus_method_info_Inhibit, &_lxsession_gnome_session_server_dbus_method_info_Uninhibit, &_lxsession_gnome_session_server_dbus_method_info_Shutdown, &_lxsession_gnome_session_server_dbus_method_info_CanShutdown, &_lxsession_gnome_session_server_dbus_method_info_Logout, &_lxsession_gnome_session_server_dbus_method_info_IsSessionRunning, NULL};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_client_added_path = {-1, "path", "s"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_client_added[] = {&_lxsession_gnome_session_server_dbus_arg_info_client_added_path, NULL};
static const GDBusSignalInfo _lxsession_gnome_session_server_dbus_signal_info_client_added = {-1, "ClientAdded", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_client_added)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_client_removed_path = {-1, "path", "s"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_client_removed[] = {&_lxsession_gnome_session_server_dbus_arg_info_client_removed_path, NULL};
static const GDBusSignalInfo _lxsession_gnome_session_server_dbus_signal_info_client_removed = {-1, "ClientRemoved", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_client_removed)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_inhibitor_added_path = {-1, "path", "s"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_inhibitor_added[] = {&_lxsession_gnome_session_server_dbus_arg_info_inhibitor_added_path, NULL};
static const GDBusSignalInfo _lxsession_gnome_session_server_dbus_signal_info_inhibitor_added = {-1, "InhibitorAdded", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_inhibitor_added)};
static const GDBusArgInfo _lxsession_gnome_session_server_dbus_arg_info_inhibitor_removed_path = {-1, "path", "s"};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_inhibitor_removed[] = {&_lxsession_gnome_session_server_dbus_arg_info_inhibitor_removed_path, NULL};
static const GDBusSignalInfo _lxsession_gnome_session_server_dbus_signal_info_inhibitor_removed = {-1, "InhibitorRemoved", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_inhibitor_removed)};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_session_running[] = {NULL};
static const GDBusSignalInfo _lxsession_gnome_session_server_dbus_signal_info_session_running = {-1, "SessionRunning", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_session_running)};
static const GDBusArgInfo * const _lxsession_gnome_session_server_dbus_arg_info_session_over[] = {NULL};
static const GDBusSignalInfo _lxsession_gnome_session_server_dbus_signal_info_session_over = {-1, "SessionOver", (GDBusArgInfo **) (&_lxsession_gnome_session_server_dbus_arg_info_session_over)};
static const GDBusSignalInfo * const _lxsession_gnome_session_server_dbus_signal_info[] = {&_lxsession_gnome_session_server_dbus_signal_info_client_added, &_lxsession_gnome_session_server_dbus_signal_info_client_removed, &_lxsession_gnome_session_server_dbus_signal_info_inhibitor_added, &_lxsession_gnome_session_server_dbus_signal_info_inhibitor_removed, &_lxsession_gnome_session_server_dbus_signal_info_session_running, &_lxsession_gnome_session_server_dbus_signal_info_session_over, NULL};
static const GDBusPropertyInfo _lxsession_gnome_session_server_dbus_property_info_something = {-1, "Something", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _lxsession_gnome_session_server_dbus_property_info[] = {&_lxsession_gnome_session_server_dbus_property_info_something, NULL};
static const GDBusInterfaceInfo _lxsession_gnome_session_server_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_lxsession_gnome_session_server_dbus_method_info), (GDBusSignalInfo **) (&_lxsession_gnome_session_server_dbus_signal_info), (GDBusPropertyInfo **) (&_lxsession_gnome_session_server_dbus_property_info)};
static const GDBusInterfaceVTable _lxsession_gnome_session_server_dbus_interface_vtable = {lxsession_gnome_session_server_dbus_interface_method_call, lxsession_gnome_session_server_dbus_interface_get_property, lxsession_gnome_session_server_dbus_interface_set_property};

void lxsession_gnome_session_server_Setenv (LxsessionGnomeSessionServer* self, const gchar* value) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->not_implemented;
	g_message ("dbus-gnome-session.vala:49: %s", _tmp0_);
}


void lxsession_gnome_session_server_InitializationError (LxsessionGnomeSessionServer* self, const gchar* mess, gboolean fatal) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mess != NULL);
	_tmp0_ = self->priv->not_implemented;
	g_message ("dbus-gnome-session.vala:60: %s", _tmp0_);
}


static void lxsession_gnome_session_server_RegisterClient_data_free (gpointer _data) {
	lxsession_gnome_session_server_RegisterClientData* _data_;
	_data_ = _data;
	_g_free0 (_data_->app_id);
	_g_free0 (_data_->client_startup_id);
	_g_object_unref0 (_data_->self);
	g_slice_free (lxsession_gnome_session_server_RegisterClientData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void lxsession_gnome_session_server_RegisterClient (LxsessionGnomeSessionServer* self, const gchar* app_id, const gchar* client_startup_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	lxsession_gnome_session_server_RegisterClientData* _data_;
	LxsessionGnomeSessionServer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_data_ = g_slice_new0 (lxsession_gnome_session_server_RegisterClientData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, lxsession_gnome_session_server_RegisterClient);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, lxsession_gnome_session_server_RegisterClient_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = app_id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->app_id = _tmp2_;
	_tmp3_ = client_startup_id;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->client_startup_id = _tmp4_;
	lxsession_gnome_session_server_RegisterClient_co (_data_);
}


void lxsession_gnome_session_server_RegisterClient_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_) {
	lxsession_gnome_session_server_RegisterClientData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean lxsession_gnome_session_server_RegisterClient_co (lxsession_gnome_session_server_RegisterClientData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->not_implemented;
	g_message ("dbus-gnome-session.vala:74: %s", _data_->_tmp0_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void lxsession_gnome_session_server_UnregisterClient_data_free (gpointer _data) {
	lxsession_gnome_session_server_UnregisterClientData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (lxsession_gnome_session_server_UnregisterClientData, _data_);
}


void lxsession_gnome_session_server_UnregisterClient (LxsessionGnomeSessionServer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	lxsession_gnome_session_server_UnregisterClientData* _data_;
	LxsessionGnomeSessionServer* _tmp0_;
	_data_ = g_slice_new0 (lxsession_gnome_session_server_UnregisterClientData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, lxsession_gnome_session_server_UnregisterClient);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, lxsession_gnome_session_server_UnregisterClient_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	lxsession_gnome_session_server_UnregisterClient_co (_data_);
}


void lxsession_gnome_session_server_UnregisterClient_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_) {
	lxsession_gnome_session_server_UnregisterClientData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean lxsession_gnome_session_server_UnregisterClient_co (lxsession_gnome_session_server_UnregisterClientData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->not_implemented;
	g_message ("dbus-gnome-session.vala:84: %s", _data_->_tmp0_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void lxsession_gnome_session_server_Inhibit_data_free (gpointer _data) {
	lxsession_gnome_session_server_InhibitData* _data_;
	_data_ = _data;
	_g_free0 (_data_->app_id);
	_g_free0 (_data_->reason);
	_g_object_unref0 (_data_->self);
	g_slice_free (lxsession_gnome_session_server_InhibitData, _data_);
}


void lxsession_gnome_session_server_Inhibit (LxsessionGnomeSessionServer* self, const gchar* app_id, guint toplevel_xid, const gchar* reason, guint flags, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	lxsession_gnome_session_server_InhibitData* _data_;
	LxsessionGnomeSessionServer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	guint _tmp6_;
	_data_ = g_slice_new0 (lxsession_gnome_session_server_InhibitData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, lxsession_gnome_session_server_Inhibit);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, lxsession_gnome_session_server_Inhibit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = app_id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->app_id = _tmp2_;
	_tmp3_ = toplevel_xid;
	_data_->toplevel_xid = _tmp3_;
	_tmp4_ = reason;
	_tmp5_ = g_strdup (_tmp4_);
	_data_->reason = _tmp5_;
	_tmp6_ = flags;
	_data_->flags = _tmp6_;
	lxsession_gnome_session_server_Inhibit_co (_data_);
}


void lxsession_gnome_session_server_Inhibit_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_, guint* inhibit_cookie) {
	lxsession_gnome_session_server_InhibitData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (inhibit_cookie) {
		*inhibit_cookie = _data_->inhibit_cookie;
	}
}


static gboolean lxsession_gnome_session_server_Inhibit_co (lxsession_gnome_session_server_InhibitData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_message ("dbus-gnome-session.vala:109: Call Inhibit function");
	_data_->_tmp0_ = _data_->flags;
	if (_data_->_tmp0_ == ((guint) 8)) {
		_data_->_tmp1_ = lxsession_control_object_new ();
		_data_->control = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->control;
		_data_->_tmp3_ = _data_->toplevel_xid;
		lxsession_control_object_set_status_busy (_data_->_tmp2_, _data_->_tmp3_);
		_data_->_tmp4_ = 0U;
		_data_->_tmp4_ = g_random_int ();
		_data_->cookie = (guint) _data_->_tmp4_;
		_data_->_tmp5_ = _data_->cookie;
		_data_->inhibit_cookie = _data_->_tmp5_;
		_g_object_unref0 (_data_->control);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void lxsession_gnome_session_server_Uninhibit_data_free (gpointer _data) {
	lxsession_gnome_session_server_UninhibitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (lxsession_gnome_session_server_UninhibitData, _data_);
}


void lxsession_gnome_session_server_Uninhibit (LxsessionGnomeSessionServer* self, guint inhibit_cookie, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	lxsession_gnome_session_server_UninhibitData* _data_;
	LxsessionGnomeSessionServer* _tmp0_;
	guint _tmp1_;
	_data_ = g_slice_new0 (lxsession_gnome_session_server_UninhibitData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, lxsession_gnome_session_server_Uninhibit);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, lxsession_gnome_session_server_Uninhibit_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = inhibit_cookie;
	_data_->inhibit_cookie = _tmp1_;
	lxsession_gnome_session_server_Uninhibit_co (_data_);
}


void lxsession_gnome_session_server_Uninhibit_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_) {
	lxsession_gnome_session_server_UninhibitData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean lxsession_gnome_session_server_Uninhibit_co (lxsession_gnome_session_server_UninhibitData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = lxsession_control_object_new ();
	_data_->control = _data_->_tmp0_;
	lxsession_control_object_exit_status_busy (_data_->control);
	_g_object_unref0 (_data_->control);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void lxsession_gnome_session_server_Shutdown (LxsessionGnomeSessionServer* self) {
	LxsessionSessionObject* _tmp0_;
	LxsessionSessionObject* session;
	g_return_if_fail (self != NULL);
	_tmp0_ = lxsession_session_object_new ();
	session = _tmp0_;
	lxsession_session_object_lxsession_shutdown (session);
	_g_object_unref0 (session);
}


static void lxsession_gnome_session_server_CanShutdown_data_free (gpointer _data) {
	lxsession_gnome_session_server_CanShutdownData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (lxsession_gnome_session_server_CanShutdownData, _data_);
}


void lxsession_gnome_session_server_CanShutdown (LxsessionGnomeSessionServer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	lxsession_gnome_session_server_CanShutdownData* _data_;
	LxsessionGnomeSessionServer* _tmp0_;
	_data_ = g_slice_new0 (lxsession_gnome_session_server_CanShutdownData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, lxsession_gnome_session_server_CanShutdown);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, lxsession_gnome_session_server_CanShutdown_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	lxsession_gnome_session_server_CanShutdown_co (_data_);
}


void lxsession_gnome_session_server_CanShutdown_finish (LxsessionGnomeSessionServer* self, GAsyncResult* _res_, gboolean* is_available) {
	lxsession_gnome_session_server_CanShutdownData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (is_available) {
		*is_available = _data_->is_available;
	}
}


static void lxsession_gnome_session_server_CanShutdown_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	lxsession_gnome_session_server_CanShutdownData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	lxsession_gnome_session_server_CanShutdown_co (_data_);
}


static gboolean lxsession_gnome_session_server_CanShutdown_co (lxsession_gnome_session_server_CanShutdownData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = lxsession_session_object_new ();
	_data_->session = _data_->_tmp0_;
	_data_->_state_ = 1;
	lxsession_session_object_lxsession_can_shutdown (_data_->session, lxsession_gnome_session_server_CanShutdown_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = lxsession_session_object_lxsession_can_shutdown_finish (_data_->session, _data_->_res_);
	_data_->is_available = _data_->_tmp1_;
	_g_object_unref0 (_data_->session);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void lxsession_gnome_session_server_Logout (LxsessionGnomeSessionServer* self, guint mode) {
	LxsessionSessionObject* _tmp0_;
	LxsessionSessionObject* session;
	FILE* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = lxsession_session_object_new ();
	session = _tmp0_;
	_tmp1_ = stdout;
	_tmp2_ = self->priv->not_implemented;
	fprintf (_tmp1_, "%s", _tmp2_);
	_g_object_unref0 (session);
}


void lxsession_gnome_session_server_IsSessionRunning (LxsessionGnomeSessionServer* self, gboolean* running) {
	gboolean _vala_running = FALSE;
	g_return_if_fail (self != NULL);
	if (running) {
		*running = _vala_running;
	}
}


LxsessionGnomeSessionServer* lxsession_gnome_session_server_construct (GType object_type) {
	LxsessionGnomeSessionServer * self = NULL;
	self = (LxsessionGnomeSessionServer*) g_object_new (object_type, NULL);
	return self;
}


LxsessionGnomeSessionServer* lxsession_gnome_session_server_new (void) {
	return lxsession_gnome_session_server_construct (LXSESSION_TYPE_GNOME_SESSION_SERVER);
}


gint lxsession_gnome_session_server_get_something (LxsessionGnomeSessionServer* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_something;
	result = _tmp0_;
	return result;
}


void lxsession_gnome_session_server_set_something (LxsessionGnomeSessionServer* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_something = _tmp0_;
	g_object_notify ((GObject *) self, "something");
}


static void lxsession_gnome_session_server_class_init (LxsessionGnomeSessionServerClass * klass) {
	lxsession_gnome_session_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LxsessionGnomeSessionServerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_lxsession_gnome_session_server_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_lxsession_gnome_session_server_set_property;
	G_OBJECT_CLASS (klass)->finalize = lxsession_gnome_session_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LXSESSION_GNOME_SESSION_SERVER_SOMETHING, g_param_spec_int ("something", "something", "something", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("client_added", LXSESSION_TYPE_GNOME_SESSION_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("client_removed", LXSESSION_TYPE_GNOME_SESSION_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("inhibitor_added", LXSESSION_TYPE_GNOME_SESSION_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("inhibitor_removed", LXSESSION_TYPE_GNOME_SESSION_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
	g_signal_new ("session_running", LXSESSION_TYPE_GNOME_SESSION_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("session_over", LXSESSION_TYPE_GNOME_SESSION_SERVER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void lxsession_gnome_session_server_instance_init (LxsessionGnomeSessionServer * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = LXSESSION_GNOME_SESSION_SERVER_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("Error, lxsession doesn't implement this API");
	self->priv->not_implemented = _tmp0_;
	_tmp1_ = g_strdup ("3.2.1");
	self->priv->gnome_session_version = _tmp1_;
}


static void lxsession_gnome_session_server_finalize (GObject* obj) {
	LxsessionGnomeSessionServer * self;
	self = LXSESSION_GNOME_SESSION_SERVER (obj);
	_g_free0 (self->priv->not_implemented);
	_g_free0 (self->priv->gnome_session_version);
	G_OBJECT_CLASS (lxsession_gnome_session_server_parent_class)->finalize (obj);
}


GType lxsession_gnome_session_server_get_type (void) {
	static volatile gsize lxsession_gnome_session_server_type_id__volatile = 0;
	if (g_once_init_enter (&lxsession_gnome_session_server_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LxsessionGnomeSessionServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lxsession_gnome_session_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LxsessionGnomeSessionServer), 0, (GInstanceInitFunc) lxsession_gnome_session_server_instance_init, NULL };
		GType lxsession_gnome_session_server_type_id;
		lxsession_gnome_session_server_type_id = g_type_register_static (G_TYPE_OBJECT, "LxsessionGnomeSessionServer", &g_define_type_info, 0);
		g_type_set_qdata (lxsession_gnome_session_server_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) lxsession_gnome_session_server_register_object);
		g_once_init_leave (&lxsession_gnome_session_server_type_id__volatile, lxsession_gnome_session_server_type_id);
	}
	return lxsession_gnome_session_server_type_id__volatile;
}


static void _vala_lxsession_gnome_session_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	LxsessionGnomeSessionServer * self;
	self = LXSESSION_GNOME_SESSION_SERVER (object);
	switch (property_id) {
		case LXSESSION_GNOME_SESSION_SERVER_SOMETHING:
		g_value_set_int (value, lxsession_gnome_session_server_get_something (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_lxsession_gnome_session_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	LxsessionGnomeSessionServer * self;
	self = LXSESSION_GNOME_SESSION_SERVER (object);
	switch (property_id) {
		case LXSESSION_GNOME_SESSION_SERVER_SOMETHING:
		lxsession_gnome_session_server_set_something (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _dbus_lxsession_gnome_session_server_Setenv (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* value = NULL;
	GVariant* _tmp2_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	value = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	lxsession_gnome_session_server_Setenv (self, value);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (value);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_lxsession_gnome_session_server_InitializationError (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* mess = NULL;
	GVariant* _tmp3_;
	gboolean fatal = FALSE;
	GVariant* _tmp4_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	mess = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	fatal = g_variant_get_boolean (_tmp4_);
	g_variant_unref (_tmp4_);
	lxsession_gnome_session_server_InitializationError (self, mess, fatal);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (mess);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_lxsession_gnome_session_server_RegisterClient (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* app_id = NULL;
	GVariant* _tmp5_;
	gchar* client_startup_id = NULL;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	app_id = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	client_startup_id = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	lxsession_gnome_session_server_RegisterClient (self, app_id, client_startup_id, (GAsyncReadyCallback) _dbus_lxsession_gnome_session_server_RegisterClient_ready, invocation);
	_g_free0 (app_id);
	_g_free0 (client_startup_id);
}


static void _dbus_lxsession_gnome_session_server_RegisterClient_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	lxsession_gnome_session_server_RegisterClient_finish ((LxsessionGnomeSessionServer*) source_object, _res_);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_lxsession_gnome_session_server_UnregisterClient (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	lxsession_gnome_session_server_UnregisterClient (self, (GAsyncReadyCallback) _dbus_lxsession_gnome_session_server_UnregisterClient_ready, invocation);
}


static void _dbus_lxsession_gnome_session_server_UnregisterClient_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	lxsession_gnome_session_server_UnregisterClient_finish ((LxsessionGnomeSessionServer*) source_object, _res_);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_lxsession_gnome_session_server_Inhibit (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* app_id = NULL;
	GVariant* _tmp7_;
	guint toplevel_xid = 0U;
	GVariant* _tmp8_;
	gchar* reason = NULL;
	GVariant* _tmp9_;
	guint flags = 0U;
	GVariant* _tmp10_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	app_id = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	toplevel_xid = g_variant_get_uint32 (_tmp8_);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	reason = g_variant_dup_string (_tmp9_, NULL);
	g_variant_unref (_tmp9_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp10_);
	g_variant_unref (_tmp10_);
	lxsession_gnome_session_server_Inhibit (self, app_id, toplevel_xid, reason, flags, (GAsyncReadyCallback) _dbus_lxsession_gnome_session_server_Inhibit_ready, invocation);
	_g_free0 (app_id);
	_g_free0 (reason);
}


static void _dbus_lxsession_gnome_session_server_Inhibit_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint inhibit_cookie = 0U;
	invocation = _user_data_;
	lxsession_gnome_session_server_Inhibit_finish ((LxsessionGnomeSessionServer*) source_object, _res_, &inhibit_cookie);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (inhibit_cookie));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_lxsession_gnome_session_server_Uninhibit (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	guint inhibit_cookie = 0U;
	GVariant* _tmp11_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	inhibit_cookie = g_variant_get_uint32 (_tmp11_);
	g_variant_unref (_tmp11_);
	lxsession_gnome_session_server_Uninhibit (self, inhibit_cookie, (GAsyncReadyCallback) _dbus_lxsession_gnome_session_server_Uninhibit_ready, invocation);
}


static void _dbus_lxsession_gnome_session_server_Uninhibit_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	lxsession_gnome_session_server_Uninhibit_finish ((LxsessionGnomeSessionServer*) source_object, _res_);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_lxsession_gnome_session_server_Shutdown (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	lxsession_gnome_session_server_Shutdown (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_lxsession_gnome_session_server_CanShutdown (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	lxsession_gnome_session_server_CanShutdown (self, (GAsyncReadyCallback) _dbus_lxsession_gnome_session_server_CanShutdown_ready, invocation);
}


static void _dbus_lxsession_gnome_session_server_CanShutdown_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean is_available = FALSE;
	invocation = _user_data_;
	lxsession_gnome_session_server_CanShutdown_finish ((LxsessionGnomeSessionServer*) source_object, _res_, &is_available);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (is_available));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_lxsession_gnome_session_server_Logout (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint mode = 0U;
	GVariant* _tmp12_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	mode = g_variant_get_uint32 (_tmp12_);
	g_variant_unref (_tmp12_);
	lxsession_gnome_session_server_Logout (self, mode);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_lxsession_gnome_session_server_IsSessionRunning (LxsessionGnomeSessionServer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean running = FALSE;
	g_variant_iter_init (&_arguments_iter, parameters);
	lxsession_gnome_session_server_IsSessionRunning (self, &running);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (running));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void lxsession_gnome_session_server_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Setenv") == 0) {
		_dbus_lxsession_gnome_session_server_Setenv (object, parameters, invocation);
	} else if (strcmp (method_name, "InitializationError") == 0) {
		_dbus_lxsession_gnome_session_server_InitializationError (object, parameters, invocation);
	} else if (strcmp (method_name, "RegisterClient") == 0) {
		_dbus_lxsession_gnome_session_server_RegisterClient (object, parameters, invocation);
	} else if (strcmp (method_name, "UnregisterClient") == 0) {
		_dbus_lxsession_gnome_session_server_UnregisterClient (object, parameters, invocation);
	} else if (strcmp (method_name, "Inhibit") == 0) {
		_dbus_lxsession_gnome_session_server_Inhibit (object, parameters, invocation);
	} else if (strcmp (method_name, "Uninhibit") == 0) {
		_dbus_lxsession_gnome_session_server_Uninhibit (object, parameters, invocation);
	} else if (strcmp (method_name, "Shutdown") == 0) {
		_dbus_lxsession_gnome_session_server_Shutdown (object, parameters, invocation);
	} else if (strcmp (method_name, "CanShutdown") == 0) {
		_dbus_lxsession_gnome_session_server_CanShutdown (object, parameters, invocation);
	} else if (strcmp (method_name, "Logout") == 0) {
		_dbus_lxsession_gnome_session_server_Logout (object, parameters, invocation);
	} else if (strcmp (method_name, "IsSessionRunning") == 0) {
		_dbus_lxsession_gnome_session_server_IsSessionRunning (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_lxsession_gnome_session_server_get_something (LxsessionGnomeSessionServer* self) {
	gint result;
	GVariant* _reply;
	result = lxsession_gnome_session_server_get_something (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}


static GVariant* lxsession_gnome_session_server_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Something") == 0) {
		return _dbus_lxsession_gnome_session_server_get_something (object);
	}
	return NULL;
}


static void _dbus_lxsession_gnome_session_server_set_something (LxsessionGnomeSessionServer* self, GVariant* _value) {
	gint value = 0;
	value = g_variant_get_int32 (_value);
	lxsession_gnome_session_server_set_something (self, value);
}


static gboolean lxsession_gnome_session_server_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Something") == 0) {
		_dbus_lxsession_gnome_session_server_set_something (object, value);
		return TRUE;
	}
	return FALSE;
}


static void _dbus_lxsession_gnome_session_server_client_added (GObject* _sender, gchar** path, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager", "ClientAdded", _arguments, NULL);
}


static void _dbus_lxsession_gnome_session_server_client_removed (GObject* _sender, gchar** path, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager", "ClientRemoved", _arguments, NULL);
}


static void _dbus_lxsession_gnome_session_server_inhibitor_added (GObject* _sender, gchar** path, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager", "InhibitorAdded", _arguments, NULL);
}


static void _dbus_lxsession_gnome_session_server_inhibitor_removed (GObject* _sender, gchar** path, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager", "InhibitorRemoved", _arguments, NULL);
}


static void _dbus_lxsession_gnome_session_server_session_running (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager", "SessionRunning", _arguments, NULL);
}


static void _dbus_lxsession_gnome_session_server_session_over (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager", "SessionOver", _arguments, NULL);
}


guint lxsession_gnome_session_server_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_lxsession_gnome_session_server_dbus_interface_info), &_lxsession_gnome_session_server_dbus_interface_vtable, data, _lxsession_gnome_session_server_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "client-added", (GCallback) _dbus_lxsession_gnome_session_server_client_added, data);
	g_signal_connect (object, "client-removed", (GCallback) _dbus_lxsession_gnome_session_server_client_removed, data);
	g_signal_connect (object, "inhibitor-added", (GCallback) _dbus_lxsession_gnome_session_server_inhibitor_added, data);
	g_signal_connect (object, "inhibitor-removed", (GCallback) _dbus_lxsession_gnome_session_server_inhibitor_removed, data);
	g_signal_connect (object, "session-running", (GCallback) _dbus_lxsession_gnome_session_server_session_running, data);
	g_signal_connect (object, "session-over", (GCallback) _dbus_lxsession_gnome_session_server_session_over, data);
	return result;
}


static void _lxsession_gnome_session_server_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lxsession_gnome_session_server_client_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lxsession_gnome_session_server_client_removed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lxsession_gnome_session_server_inhibitor_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lxsession_gnome_session_server_inhibitor_removed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lxsession_gnome_session_server_session_running, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lxsession_gnome_session_server_session_over, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



