#!/bin/sh
if [ -e /android/system/boot/android-ramdisk.img ]; then
    mount -t tmpfs tmpfs $LXC_ROOTFS_PATH
    INITRD=/android/system/boot/android-ramdisk.img
elif [ -e /boot/android-ramdisk.img ]; then
    rm -Rf $LXC_ROOTFS_PATH
    mkdir -p $LXC_ROOTFS_PATH
    INITRD=/boot/android-ramdisk.img
else
    exit 1
fi

cd $LXC_ROOTFS_PATH
cat $INITRD | gzip -d | cpio -i

# Create /dev/pts if missing
mkdir -p $LXC_ROOTFS_PATH/dev/pts

# Disable adbd
rm $LXC_ROOTFS_PATH/sbin/adbd

# Make sure the ubuntu_chroot init service does not get started
sed -i '/ubuntu_chroot init$/,+2d' $LXC_ROOTFS_PATH/init.rc

cp -a /var/lib/lxc/android/overrides/* $LXC_ROOTFS_PATH

if [ "$INITRD" = "/android/system/boot/android-ramdisk.img" ]; then
    sed -i "/mount_all /d" $LXC_ROOTFS_PATH/init.*.rc
    sed -i "/on nonencrypted/d" $LXC_ROOTFS_PATH/init.rc

    rm -Rf $LXC_ROOTFS_PATH/vendor
    ln -s /system/vendor $LXC_ROOTFS_PATH/vendor

    for dir in /android/*; do
        mkdir -p $LXC_ROOTFS_PATH/$(basename $dir)
        mount -o bind,recurse $dir $LXC_ROOTFS_PATH/$(basename $dir)
    done
fi
