<?php
/*
    LWAT, LDAP Webbased Administration Tool
    Copyright (C) 2007 Finn-Arne Johansen <faj@bzz.no> BzzWare AS, Norway

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

    require_once ('functions.php') ; 
    require('/usr/share/php/smarty/libs/Smarty.class.php') ; 

    ob_start () ; 
    loadConfig () ; 
    loadLocale () ; 

    $ldap=ldap_connect ($ldaphost); 
    session_start() ;
    $authenticated = ($_COOKIE['Authenticated'] == "True") ;
    $key = $_SESSION['key'] ;
    if ($key == "") {
	if ($authenticated) {
	    setcookie ("Authenticated", "False", time () + 1800) ;
	}
	$authenticated = false ; 
    } 
    ldap_set_option($ldap, LDAP_OPT_PROTOCOL_VERSION, 3);
    @ldap_start_tls($ldap) ; 
    if ($authenticated) {
	$admindn = $_COOKIE['admindn'] ; 
	$xorstring = $_COOKIE['xorstring'] ; 
	if ($xorstring <> "") {
	    $adminpw = xorstring ($key, $xorstring) ; 
	    $authenticated = ($adminpw <> "") ;
	} else {
	    $authenticated = false ; 
	}
    }
    if ($authenticated) {
	$bind = ldap_bind ($ldap, $admindn, $adminpw); 
	setcookie ("Authenticated", "True", time () + 1800) ;
	setcookie ("admindn", $admindn, time () + 1800) ;
	setcookie ("xorstring", $xorstring, time () + 1800) ;
    } else {
	unset ($_SESSION['key']) ; 
	$bind = @ldap_bind ($ldap) ;
    }
    $smarty = new Smarty();
    $smarty->template_dir = $smarty_templ ; 
    $smarty->compile_dir = $smarty_compile ; 

    $maxcount = 0 ;
    if ($file = file($_FILES["userfile"]["tmp_name"])) {
	for ($i = 0 ; $i < count($file); $i++) {
	    $line=split (";", $file[$i]) ;
	    foreach ($line as $value) 
		$cells[$i][] = trim ($value) ; 
	    if (count($line) > $maxcount) 
		$maxcount = count ($line) ; 
	}
	$smarty->assign ('cells', $cells) ; 
	for ($i = 0 ; $i < $maxcount; $i++) 
	    $columns[] = "" ; 
        $smarty->assign ('columns', $columns) ; 
	$smarty->assign ('cmd', upload) ; 
    } else {
        foreach ($_POST as $key => $value) {
	    $key = split ("_", $key) ; 
	    switch ($key[0]) {
	        case "group": 
	            $adduser[$key[1]]["group"][] = $value ; 
	            break ;
	        case "password": 
	        case "fullName": 
	        case "template": 
	            $adduser[$key[1]][$key[0]] = $value ; 
	            break ; 
		case "column": 
		    $columns[] = $value ; 
		    break ; 
		case "cmd": 
		    $cmd = $key[1] ; 
		    break ; 
		case "row": 
		    if ($value == "on") {
			$row = $key[1] ; 
			if (isset($new))
			    $new++ ; 
			else
			    $new = 0 ; 

		    }
		    break ; 
		case "cell": 
		    if ($key[1] == $row) {
		        switch ($columns[$key[2]]) {
		            case "Group": 
				$cell[$new]["group"][] = $value ; 
				break ;
		            default: 
				$cell[$new][$columns[$key[2]]] = $value ; 
				break ;
			}
	            }
		    break ; 
		default: 
		    debug (array('key' => $key,
				 'value' => $value)) ; 
		    break ;
	    }
	}
	$smarty->assign ('cmd', $cmd) ; 
	switch ($cmd) {
	    case "add":
	        foreach ($adduser as $username => $info) {
	            ldapAddUser ($ldap, $info["fullName"], $info["template"], 
	                         $username,  $info["password"], &$info["group"]) ; 
		    foreach ($info["group"] as $key => $group)
		        $adduser[$username]["AddGroup"][] = $group ; 
	        }
	        $smarty->assign ('addUsers', $adduser) ; 
	        break ;
	    case "check":
		$templ_ini_file = parse_ini_file ('/etc/lwat/admin.ini', true) ; 
		foreach ($templ_ini_file as $key => $value)
		    $templates[] = $key ; 
		$smarty->assign ('Templates', $templates) ; 
		if (! in_array ("Template", $columns)) 
		    array_push ($columns, "Template") ; 
	       for ($i = 0 ; $i < count($cell) ; $i++) {
		   if (!in_array ($cell[$i]["Template"], $templates))
		       $cell[$i]["Template"] = "" ; 
		}

		if (! in_array ("fullName", $columns)) 
		    array_push ($columns, "FullName") ; 
		for ($i = 0 ; $i < count($cell) ; $i++) {
		    if ($cell[$i]["fullName"] == "")
			$cell[$i]["fullName"] = $cell[$i]["firstName"] . " " . $cell[$i]["lastName"] ; 
		}

		if (!in_array ("userName", $columns)) 
		    array_push ($columns, "userName") ; 
		$excludes = array() ; 
		for ($i = 0 ; $i < count($cell) ; $i++) {
		    $cell[$i]["userName"] = chk_username ($ldap, $cell[$i]["userName"], $excludes); 
		    if ($cell[$i]["userName"] == "")
			$cell[$i]["userName"] = get_username ($ldap, $cell[$i]["fullName"], $excludes) ; 
	            $excludes[] = $cell[$i]["userName"];
		}

		if (!in_array ("password", $columns)) 
		    array_push ($columns, "password") ; 
		for ($i = 0 ; $i < count($cell) ; $i++) {
		    if ($cell[$i]["password"] == "")
			$cell[$i]["password"] = pwgen () ; 
		}

		$smarty->assign ('columns', $columns) ; 
		$smarty->assign ('cells', $cell) ; 
		break ;
            default: 
                debug ($_POST) ; 
                break ;
	    }
    }
    ldap_close ($ldap);

    $smarty->display('import.tpl');

?>
