## API Report File for "@lumino/dragdrop"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { IDisposable } from '@lumino/disposable';
import { MimeData } from '@lumino/coreutils';

// @public
export class Drag implements IDisposable {
    constructor(options: Drag.IOptions);
    dispose(): void;
    readonly document: Document | ShadowRoot;
    readonly dragImage: HTMLElement | null;
    handleEvent(event: Event): void;
    get isDisposed(): boolean;
    readonly mimeData: MimeData;
    protected moveDragImage(clientX: number, clientY: number): void;
    readonly proposedAction: Drag.DropAction;
    readonly source: any;
    start(clientX: number, clientY: number): Promise<Drag.DropAction>;
    readonly supportedActions: Drag.SupportedActions;
}

// @public
export namespace Drag {
    export type DropAction = 'none' | 'copy' | 'link' | 'move';
    export class Event extends DragEvent {
        constructor(event: PointerEvent, options: Event.IOptions);
        dropAction: DropAction;
        readonly mimeData: MimeData;
        readonly proposedAction: DropAction;
        readonly source: any;
        readonly supportedActions: SupportedActions;
    }
    export namespace Event {
        export interface IOptions {
            drag: Drag;
            related: Element | null;
            type: 'lm-dragenter' | 'lm-dragexit' | 'lm-dragleave' | 'lm-dragover' | 'lm-drop';
        }
    }
    export interface IOptions {
        document?: Document | ShadowRoot;
        dragImage?: HTMLElement;
        mimeData: MimeData;
        proposedAction?: DropAction;
        source?: any;
        supportedActions?: SupportedActions;
    }
    export function overrideCursor(cursor: string, doc?: Document | ShadowRoot): IDisposable;
    export type SupportedActions = DropAction | 'copy-link' | 'copy-move' | 'link-move' | 'all';
}

// @public @deprecated (undocumented)
export interface IDragEvent extends Drag.Event {
}

// (No @packageDocumentation comment for this package)

```
