## API Report File for "@lumino/algorithm"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

// @public
export namespace ArrayExt {
    export function fill<T>(array: MutableArrayLike<T>, value: T, start?: number, stop?: number): void;
    export function findFirstIndex<T>(array: ArrayLike<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): number;
    export function findFirstValue<T>(array: ArrayLike<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): T | undefined;
    export function findLastIndex<T>(array: ArrayLike<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): number;
    export function findLastValue<T>(array: ArrayLike<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): T | undefined;
    export function firstIndexOf<T>(array: ArrayLike<T>, value: T, start?: number, stop?: number): number;
    export function insert<T>(array: Array<T>, index: number, value: T): void;
    export function lastIndexOf<T>(array: ArrayLike<T>, value: T, start?: number, stop?: number): number;
    export function lowerBound<T, U>(array: ArrayLike<T>, value: U, fn: (element: T, value: U) => number, start?: number, stop?: number): number;
    export function move<T>(array: MutableArrayLike<T>, fromIndex: number, toIndex: number): void;
    export type MutableArrayLike<T> = {
        readonly length: number;
        [index: number]: T;
    };
    export function removeAllOf<T>(array: Array<T>, value: T, start?: number, stop?: number): number;
    export function removeAllWhere<T>(array: Array<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): number;
    export function removeAt<T>(array: Array<T>, index: number): T | undefined;
    export function removeFirstOf<T>(array: Array<T>, value: T, start?: number, stop?: number): number;
    export function removeFirstWhere<T>(array: Array<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): {
        index: number;
        value: T | undefined;
    };
    export function removeLastOf<T>(array: Array<T>, value: T, start?: number, stop?: number): number;
    export function removeLastWhere<T>(array: Array<T>, fn: (value: T, index: number) => boolean, start?: number, stop?: number): {
        index: number;
        value: T | undefined;
    };
    export function reverse<T>(array: MutableArrayLike<T>, start?: number, stop?: number): void;
    export function rotate<T>(array: MutableArrayLike<T>, delta: number, start?: number, stop?: number): void;
    export function shallowEqual<T>(a: ArrayLike<T>, b: ArrayLike<T>, fn?: (a: T, b: T) => boolean): boolean;
    export function slice<T>(array: ArrayLike<T>, options?: slice.IOptions): T[];
    export namespace slice {
        export interface IOptions {
            start?: number;
            step?: number;
            stop?: number;
        }
    }
    export function upperBound<T, U>(array: ArrayLike<T>, value: U, fn: (element: T, value: U) => number, start?: number, stop?: number): number;
}

// @public @deprecated
export function chain<T>(...objects: Iterable<T>[]): IterableIterator<T>;

// @public @deprecated
export function each<T>(object: Iterable<T>, fn: (value: T, index: number) => boolean | void): void;

// @public
export function empty<T>(): IterableIterator<T>;

// @public
export function enumerate<T>(object: Iterable<T>, start?: number): IterableIterator<[number, T]>;

// @public
export function every<T>(object: Iterable<T>, fn: (value: T, index: number) => boolean): boolean;

// @public
export function filter<T>(object: Iterable<T>, fn: (value: T, index: number) => boolean): IterableIterator<T>;

// @public
export function find<T>(object: Iterable<T>, fn: (value: T, index: number) => boolean): T | undefined;

// @public
export function findIndex<T>(object: Iterable<T>, fn: (value: T, index: number) => boolean): number;

// @public
export interface IRetroable<T> {
    retro(): IterableIterator<T>;
}

// @public
export function map<T, U>(object: Iterable<T>, fn: (value: T, index: number) => U): IterableIterator<U>;

// @public
export function max<T>(object: Iterable<T>, fn: (first: T, second: T) => number): T | undefined;

// @public
export function min<T>(object: Iterable<T>, fn: (first: T, second: T) => number): T | undefined;

// @public
export function minmax<T>(object: Iterable<T>, fn: (first: T, second: T) => number): [T, T] | undefined;

// @public @deprecated
export function once<T>(value: T): IterableIterator<T>;

// @public
export function range(start: number, stop?: number, step?: number): IterableIterator<number>;

// @public
export function reduce<T>(object: Iterable<T>, fn: (accumulator: T, value: T, index: number) => T): T;

// @public (undocumented)
export function reduce<T, U>(object: Iterable<T>, fn: (accumulator: U, value: T, index: number) => U, initial: U): U;

// @public @deprecated
export function repeat<T>(value: T, count: number): IterableIterator<T>;

// @public
export function retro<T>(object: IRetroable<T> | ArrayLike<T>): IterableIterator<T>;

// @public
export function some<T>(object: Iterable<T>, fn: (value: T, index: number) => boolean): boolean;

// @public
export function stride<T>(object: Iterable<T>, step: number): IterableIterator<T>;

// @public
export namespace StringExt {
    export function cmp(a: string, b: string): number;
    export function findIndices(source: string, query: string, start?: number): number[] | null;
    export function highlight<T>(source: string, indices: ReadonlyArray<number>, fn: (chunk: string) => T): Array<string | T>;
    export interface IMatchResult {
        indices: number[];
        score: number;
    }
    export function matchSumOfDeltas(source: string, query: string, start?: number): IMatchResult | null;
    export function matchSumOfSquares(source: string, query: string, start?: number): IMatchResult | null;
}

// @public
export function take<T>(object: Iterable<T>, count: number): IterableIterator<T>;

// @public @deprecated
export function toArray<T>(object: Iterable<T>): T[];

// @public
export function toObject<T>(object: Iterable<[string, T]>): {
    [key: string]: T;
};

// @public
export function topologicSort<T>(edges: Iterable<[T, T]>): T[];

// @public
export function zip<T>(...objects: Iterable<T>[]): IterableIterator<T[]>;

// (No @packageDocumentation comment for this package)

```
