// ---------------------------------- rsyncDialog.h ---------------------------------------------------------------------------
// Header file for rsyncdialog.cpp
/*
===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 04 May 2009
===============================================================================================================================
===============================================================================================================================
*/

#ifndef RSYNCDIALOG_H
#define RSYNCDIALOG_H

//include  header file that qmake produces from "*.ui" created with qt designer
#include "ui_rsyncDialog.h"

//==============================================================================================================
//Declaration of rsyncDialog class (this will execute rsync and show progress in a dialog)
class rsyncDialog : public QDialog
{
	Q_OBJECT
	
	public:
		rsyncDialog (QWidget *parent=0);

		void setNowDoing();	//Display sth in the Now Doing textBrowser
		void executeRsync();	//execute qprocess "rsync" with Arguments
		
		//Progress bar variables
		int progress_total;	//Maximum value of progress
		int progress_done;	//Current value of progress

		//variables used for rsync command
		QString command;		//command to be executed. Normally this is "rsync"
		QStringList rsyncArguments;	// This stringList holds all arguments for the rsync command
		QString outputString;		//all the output of rsync is going to fit in here
		QString outputError;		//all the error output of rsync is going to fit in here
		QString outputInsert;		//this is used to enter application output between outputString/Error
		QString nowDoingText;		//this is the text printed in the NowDoing textBrowser

		bool notYet;			//This is used for the dialog button. If true we'll set it to "start" else "done"(closes dialog)
		bool writeToLog;		//if the log file is ok to write this becomes TRUE
		bool sync;			//becomes true if syncing is to be executed
		bool syncAB;			//becomes true if syncing from dirA to dirB is to be executed
		QString dirA;			//holds the first dir to be synced
		QString dirB;			//holds the second dir to be synced
		
		bool calculating;		//these 3 bools are used to diplay progress of rsync at the info window
		bool transfering;
		bool deleting;

		int count;		//simple count variable !!
		
		bool ExecuteBefore;		//becomes true if a before command is to be executed, not rsync !!
		bool ExecuteAfter;		//becomes true if a after command is to be executed, not rsync !!
		int currentBefore;		//count variable for commands to be executed before task
		int currentAfter;		//count variable for commands to be executed before task
		void executeBeforeTask();	//function to start execution of pre-task commands
		void executeAfterTask();	//function to start execution of post-task commands

	private slots:
		void buttonPressed();		//SLOT when buutton pressed( see also notYet)
		void appendRsyncOutput();	//Display o/p to textbrowser & update logfile
		void procFinished();		//SLOT executed when syncProcess is finshed (will start a new syncProcess if any left)

	private:
		Ui::rsyncDialog uiR;

	protected:
		void closeEvent(QCloseEvent *event);	//when the close button of the dialog pressed
};

#endif

// end of rsyncDialog.h ---------------------------------------------------------------------------
