/* ---------------------------------- rsyncDialog.cpp ---------------------------------------------------------------------------
 Class to display the rsync progress dialog

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2009, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.


 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 20 May 2009
===============================================================================================================================
===============================================================================================================================
 ********************************** DO NOT FORGET TO CHANGE "commandline.cpp:rsyncIT()" ********************************************************
*/

QProcess *syncProcess;
QFile logfile (logfilename);	//we will write all rsync output in this logfile
QTime StartTime(0,0,0,0);	//find out elapsed time from these;

#include "rsyncDialog.h"

// class rsyncDialog Constructor=================================================================================================
// executes rsync and displays progress.
rsyncDialog::rsyncDialog (QWidget *parent) : QDialog (parent)
{
	uiR.setupUi(this);
	uiR.AbortButton -> setText (tr("start tasks NOW"));
	//uiR.rsyncOutput-> 

	notYet = TRUE;
	outputString = "";
	outputError = "";
	calculating = FALSE;		//these 3 bools are used to diplay progress of rsync at the info window
	transfering = FALSE;
	deleting = FALSE;
	ExecuteBefore=FALSE;
	ExecuteAfter=FALSE;
	errorsFound = 0;
	count = 0;
	currentAfter = 0;
	currentBefore = 0;

	connect ( uiR.AbortButton, SIGNAL( clicked() ), this, SLOT( buttonPressed() ) );	//connect abort pushButton SLOT ----------------

	syncProcess = new QProcess(this);	//create a new qprocess (for rsync) & connect signals
	connect(syncProcess, SIGNAL(readyReadStandardError()), this, SLOT(appendRsyncOutput()));
	connect(syncProcess, SIGNAL(readyReadStandardOutput()), this, SLOT(appendRsyncOutput()));
	connect(syncProcess, SIGNAL (finished(int, QProcess::ExitStatus)), this, SLOT(procFinished()));

	//rsync command & arguments initiation
	command = "rsync";
	rsyncArguments.clear();
	syncAB = TRUE;
	buttonPressed();
}

// start-abort-done button pressed=====================================================================================================
void rsyncDialog::buttonPressed()
{
	if (notYet == TRUE)	//if the button is "start operations NOW" set it to "abort", executeRsync - create & open logfile
	{
		notYet = FALSE;		//next time button is pressed it will abort the process
		uiR.AbortButton -> setText (tr("Abort NOW"));
		uiR.AbortButton -> setIcon(QIcon(":/luckyPrefix/abort.png"));
		if (logfile.exists())		//if a logfile exists delete it
			logfile.remove();
		if (logfile.open(QIODevice::WriteOnly | QIODevice::Text))	//create a new log file
			writeToLog = TRUE;				//& if it's ok set this to TRUE

		StartTime.start();	//start the timer to measure elapsed time

		currentOperation = 0;
 		//increase currentOperation until first operation to be executed
		while ( (currentOperation < TotalOperations) && (!Operation[currentOperation] -> GetPerform()) )
			currentOperation++;

		executeBeforeTask();				//execute pre-task commands if any
	}
	else
		close();	//emmit a QcloseEvent
}
//window closebutton pressed or QcloseEvent emitted=========================================================================================
void rsyncDialog::closeEvent(QCloseEvent *event)
 {
	if (syncProcess->state() == QProcess::NotRunning)	//if syncProcess is not Running
		event->accept();
	else
	{
		event->ignore();
		syncProcess -> kill();	//kill rsyncProcess
		syncProcess -> waitForFinished();
		currentOperation = TotalOperations + 2;		//this means the abort button is pressed to other functions
		ExecuteBefore = FALSE;
		ExecuteAfter = FALSE;
		setNowDoing ();		//update Nowdoing textBrowser
	}
 }
 //executes pre-task commands ===============================================================================================
void rsyncDialog::executeBeforeTask()
{
	// execute commands before task -----------------------------------------------------------------------------------------------------
	//if there are no (more) pre-task commands to be executed
	if (Operation[currentOperation] -> GetExecuteBeforeListSize() == currentBefore) 	
	{
		currentBefore = 0;
		ExecuteBefore=FALSE;
		executeRsync();
	}
	else
	{
		ExecuteBefore=TRUE;
		outputInsert = "<br><font color=magenta>" +
			tr("pre-task execution of command")+"	: <b>" + Operation[currentOperation] -> GetExecuteBeforeListItem(currentBefore) +
			"</b>, "+tr("starting")+"</font><br>";
		uiR.rsyncOutput->append(outputInsert);

		syncProcess -> start (Operation[currentOperation] -> GetExecuteBeforeListItem(currentBefore));
		syncProcess -> waitForStarted();
	}
}

 //executes post-task commands ===============================================================================================
void rsyncDialog::executeAfterTask()
{
	// execute commands after task -----------------------------------------------------------------------------------------------------
	//if there are no (more) post-task commands to be executed
	if (Operation[currentOperation] -> GetExecuteAfterListSize() == currentAfter) 	
	{
		currentAfter = 0;
		ExecuteAfter=FALSE;

		currentOperation++;
		//increase currentOperation until next operation to be executed or end of operations
		while ( (currentOperation < TotalOperations) && (!Operation[currentOperation] -> GetPerform()) )
			currentOperation++;
		if (currentOperation < TotalOperations)
			executeBeforeTask();
		else
			setNowDoing();
	}
	else
	{
		ExecuteAfter=TRUE;
		outputInsert = "<br><font color=magenta>" +
			tr("post-task execution of command")+"	: <b>" + Operation[currentOperation] -> GetExecuteAfterListItem(currentAfter) +
			"</b>, "+tr("starting")+"</font><br>";
		uiR.rsyncOutput->append(outputInsert);

		syncProcess -> start (Operation[currentOperation] -> GetExecuteAfterListItem(currentAfter));
		syncProcess -> waitForStarted();
	}
}

//executes rsync  ===============================================================================================
void rsyncDialog::executeRsync()
{
	sync = Operation[currentOperation] -> GetTypeSync();		//set sync variable according to checkstate of radiobutton operation type
	rsyncArguments = AppendArguments(Operation[currentOperation]);	//set rsync arguments

	if (DryRun)
		rsyncArguments.insert(rsyncArguments.size()-2,"--dry-run");

	dirA = rsyncArguments[rsyncArguments.size()-2];
	dirB = rsyncArguments[rsyncArguments.size()-1];
	
	if (sync)	//execute rsync for syncing 2 dirs
	{
		if (syncAB)	//execute rsync A -> B
			syncAB = FALSE;

		else		//execute rsync B -> A
		{
			rsyncArguments.removeLast();
			rsyncArguments.removeLast();
			rsyncArguments.append(dirB);	// set SyncDirA & SyncDirB as Arguments
			rsyncArguments.append(dirA);
			syncAB = TRUE;
		}
	}
/*
	//temp info window==== to take out =========================================================================================
	QString tempArgs = command+" "; count=0;
	while (count < rsyncArguments.size() ) {tempArgs.append(rsyncArguments[count]+" ");	count++;}
	QMessageBox::warning(this, tr("luckybBackup"), tempArgs, QMessageBox::Ok | QMessageBox::Default); 
	//uiR.rsyncOutput->append(tempArgs+"<br>");
	//==========================================================================================================================
*/
	//display a couple of lines to inticate start of task
	if ((sync) && (!syncAB))
		outputInsert = "<br>=================================================================<br><font color=magenta>" +
				tr("execution of 1st part of task")+"	: <b>" + Operation[currentOperation] -> GetName() +
				"</b>, "+tr("starting")+"</font><br>"+
				tr("Syncing")+"	: <b><font color=blue>" + dirA +
				"</font></b><br>"+tr("to")+"	: <b><font color=blue>" + dirB + "</font></b><br>";
	if ((sync) && (syncAB))
		outputInsert = "<br>=================================================================<br><font color=magenta>" +
				tr("execution of 2nd part of task")+"	: <b>" + Operation[currentOperation] -> GetName() +
				"</b>, "+tr("starting")+"</font><br>"+
				tr("Syncing")+"	: <b><font color=blue>" + dirB +
				"</font></b><br>"+tr("to")+"	: <b><font color=blue>" + dirA + "</font></b><br>";
	if (!sync)
		outputInsert = "<br>=================================================================<br><font color=magenta>" +
				tr("execution of task")+"	: <b>" + Operation[currentOperation] -> GetName() +
				"</b>, "+tr("starting")+"</font><br>"+
				tr("Source")+"	: <b><font color=blue>" + dirA +
				"</font></b><br>"+tr("Destination")+"	: <b><font color=blue>" + dirB + "</font></b><br>";
	uiR.rsyncOutput->append(outputInsert);
	//set the progressbar to 0
	uiR.OperationProgress -> setRange(0,100);
	uiR.OperationProgress -> setValue (0);

	syncProcess -> start (command,rsyncArguments);	// execute rsync command with rsyncArguments
	syncProcess -> waitForStarted();
}

//when rsyncProcess emits finished signal execute another RsyncProcess if any left====================================================================
void rsyncDialog::procFinished()
{
	if (!(currentOperation < TotalOperations)) //this is to prevent segmentation fault when abort button pressed (currentOperation=totalOperaions+2)
		return;

	if (ExecuteBefore)		// if the pre-task execution command (process) finished
	{
		outputInsert = "<br><font color=magenta>" +
			tr("pre-task execution of command")+"	: <b>" + Operation[currentOperation] -> GetExecuteBeforeListItem(currentBefore) +
			"</b>, "+tr("finished")+"</font><br>";
		uiR.rsyncOutput->append(outputInsert);
		currentBefore++; 	//go to the next pre-task execution command 
		executeBeforeTask();	//and executeBeforeTask again
		return;
	}

	if (ExecuteAfter)		// if the post-task execution command (process) finished
	{
		outputInsert = "<br><font color=magenta>" +
			tr("post-task execution of command")+"	: <b>" + Operation[currentOperation] -> GetExecuteAfterListItem(currentAfter) +
			"</b>, "+tr("finished")+"</font><br>";
		uiR.rsyncOutput->append(outputInsert);
		currentAfter++; 		//go to the next post-task execution command 
		executeAfterTask();		//and executeAfterTask again
		return;
	}

	//display a couple of lines to inticate end of task
	if ((!sync) || ((sync) && (syncAB)) )
		outputInsert = "<br><font color=magenta>" +
				tr("execution of task")+"	: <b>" + Operation[currentOperation] -> GetName() +
				"</b>, "+tr("finished") +
				"</font><br>=================================================================<br>";
	else
		outputInsert = "<br><font color=magenta>" +
				tr("execution of 1st part of task")+"	: <b>" + Operation[currentOperation] -> GetName() +
				"</b>, "+tr("finished") +
				"</font><br>=================================================================<br>";
	uiR.rsyncOutput->append(outputInsert);

	//set the current date and time as the operation's last execution date-time
	if (!DryRun)
		Operation[currentOperation] -> SetLastExecutionTime (QDateTime::currentDateTime());

	if ( (sync) && (!syncAB) )	//sync A->B is finished. Do the opposite now before proceeding to next included operation or post-task commands
		executeRsync();
	else
		executeAfterTask();	//execute post-task commands (if any)
}

//update dialog with new data (text - progressbar) - also update logfile =======================================================================
void rsyncDialog::appendRsyncOutput()
{
	setNowDoing ();		//update Nowdoing textBrowser
	
	//update textBrowser ------------------------------------------------------------------------------------------------------
	QTextCodec *codec = QTextCodec::codecForName("UTF-8");
	outputString = codec->toUnicode(syncProcess -> readAllStandardOutput());
	outputError = codec->toUnicode(syncProcess -> readAllStandardError());

	uiR.rsyncOutput->append(outputString);
	if (outputError !="")
		errorsFound++;
	uiR.rsyncOutput->append("<font color=red>" + outputError +"</font>");
	
	//update progressbar--------------------------------------------------------------------------------------------------------
	bool ok;
	if (outputString.contains("to-check"))	//we will calculate how many files have been proccessed so far
	{
		//DoneToTotal_Ref & DoneToTotal_String hold a e.g. "17/84"
		QStringRef DoneToTotal_Ref = outputString.midRef(outputString.indexOf("check=")+6,outputString.indexOf(")")-outputString.indexOf("check=")-6);
		QString DoneToTotal_String = DoneToTotal_Ref.toString();

		//Total no files
		QStringRef ref_temp = DoneToTotal_String.rightRef(DoneToTotal_String.size() - DoneToTotal_String.indexOf("/") -1);
		QString string_temp = ref_temp.toString();
		progress_total = string_temp.toInt(&ok,10);
		uiR.OperationProgress -> setRange(0,progress_total);	//set the range of the progressbar to the no of files to consider

		//No of files processed so far
		ref_temp = DoneToTotal_String.leftRef(DoneToTotal_String.indexOf("/"));
		string_temp = ref_temp.toString();
		progress_done = string_temp.toInt(&ok,10);
		progress_done = progress_total - progress_done;
		uiR.OperationProgress -> setValue (progress_done);	//set the current progressbar value 
	}
	if (outputString.contains("speedup is"))	//the process has finished, so if we're back fill it to 100%
	{
		uiR.OperationProgress -> setRange(0,100);
		uiR.OperationProgress -> setValue (100);
	}
	if (outputString.contains("building file list"))
	{
		calculating = TRUE;
		transfering = FALSE;
		deleting = FALSE;
	}
	if (outputString.contains("files to consider"))
	{
		calculating = FALSE;
		transfering = TRUE;
		deleting = FALSE;
	}
	if (outputString.contains("deleting"))
	{
		calculating = FALSE;
		transfering = FALSE;
		deleting = TRUE;
	}
/*	if ( (outputString.contains("password:")) || (outputError.contains("password:")) )
	{
		textDialog textdialog ("password", "", this);
		textdialog.exec();
		syncProcess -> write((textdialog.getUserInput()+"\n").toAscii());
	}

	if (outputString.contains("Enter passphrase for key"))
	{
		textDialog textdialog ("passphrase", "", this);
		textdialog.exec();
		syncProcess -> write((textdialog.getUserInput()+"\n").toAscii());
	}
*/
	if (writeToLog == TRUE)
	{
		QTextStream out(&logfile);
		//out.setVersion(QTextStream::Qt_4_3);
		out << outputString;//.toAscii();
		out << outputError;
	}
}

//updates Now Doing textBrowser ===============================================================================================================
void rsyncDialog::setNowDoing()
 {
	//calculate elapsed time since all operations start
	QTime DifTime(0,0,0,0);
	int elapsedMsec = StartTime.elapsed();
	DifTime = DifTime.addMSecs(elapsedMsec);
	
	if ( (ExecuteBefore) && (currentOperation < TotalOperations) )
	{
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>"+tr("pre-task execution of command")+"	: <b>" +
				Operation[currentOperation] -> GetExecuteBeforeListItem(currentBefore) + "</b>";
	}
	if ( (ExecuteAfter) && (currentOperation < TotalOperations) )
	{
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>"+tr("post-task execution of command")+"	: <b>" +
				Operation[currentOperation] -> GetExecuteAfterListItem(currentAfter) + "</b>";
	}

	if ( (sync) && (currentOperation < TotalOperations) && (!ExecuteAfter) && (!ExecuteBefore) )	//if a sync operation is executed
	{
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>"+tr("Now performing task")+"	: <b>" + Operation[currentOperation] -> GetName() +
				"</b>";
		if (DryRun)
			nowDoingText.append(" <b><font color=magenta>(" + tr("simulation mode") + ")</font>");
		nowDoingText.append("</p>");
		nowDoingText.append(tr("Directory")+" A	: <b><font color=blue>" + dirA +
				"</font></b><br>"+tr("Directory")+" B	: <b><font color=blue>" + dirB + "</font></b><br>");
		if (calculating)
			nowDoingText.append(tr("calculating")+": " + outputString);
		if (transfering)
			nowDoingText.append(tr("transfering files")+": " + outputString);
		if (deleting)
			nowDoingText.append(tr("deleting files")+": " + outputString);
	}

	if ( (!sync) && (currentOperation < TotalOperations) && (!ExecuteAfter) && (!ExecuteBefore) ) //if a backup operation is executed
	{
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>"+tr("Now performing task")+"	: <b>" + Operation[currentOperation] -> GetName() +
				"</b>";
		if (DryRun)
			nowDoingText.append(" <b><font color=magenta>(" + tr("simulation mode") + ")</font>");
		nowDoingText.append("</p>");
		nowDoingText.append(tr("Source")+"	: <b><font color=blue>" + dirA +
				"</font></b><br>"+tr("Destination")+"	: <b><font color=blue>" + dirB + "</font></b><br>");
		if (calculating)
			nowDoingText.append(tr("calculating")+": " + outputString);
		if (transfering)
			nowDoingText.append(tr("transfering files")+": " + outputString);
		if (deleting)
			nowDoingText.append(tr("deleting files")+": " + outputString);
	}

	if (currentOperation == TotalOperations)	//if all operations finished
	{
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>================================================================="
				"<b><br><font color=blue>"+tr("All tasks completed")+" </font></b>";
		if (DryRun)
			nowDoingText.append(" <b><font color=magenta>(" + tr("simulation mode") + ")</b></font>");
		if (errorsFound == 0)
			nowDoingText.append("<br><font color=green>" + tr("No errors found") + "</font><br>");
		else
			nowDoingText.append("<br><font color=green>" + tr("errors found") + ": " + countStr.setNum(errorsFound) +"</font><br>");
		nowDoingText.append(tr("logfile")+": <b>~/.luckyBackup/logs/logfile.txt</b> "+tr("has been created")+"<br>"
				"=================================================================</p>");
		uiR.AbortButton -> setText (tr("Done"));
		uiR.AbortButton -> setIcon(QIcon(":/luckyPrefix/okay.png"));
	}
	if (currentOperation == TotalOperations+2)	//if operations were terminated by user
	{
		nowDoingText = 	"<p align=\"center\">"+tr("Elapsed time")+" : <b><font color=red>" + DifTime.toString("hh:mm:ss") +
				"</font></b><br>=========================================================================="
				"<br><b><font color=blue>"+tr("Execution of tasks were terminated violently by user")+"</font></b><br>"+
				tr("logfile")+": <b>~/.luckyBackup/logs/logfile.txt</b> "+tr("has been created")+"<br>"
				"=========================================================================</p>";
		uiR.AbortButton -> setText (tr("Done"));
		uiR.AbortButton -> setIcon(QIcon(":/luckyPrefix/okay.png"));
	}
	uiR.nowDoing -> setText (nowDoingText);
 }

// end of rsyncDialog.cpp ---------------------------------------------------------------------------

