#!/usr/bin/env python
# -*- coding:UTF-8 -*-
#       Copyright (c) Stephen Smally <stephen.smally@gmail.com>
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.
#  

from gi.repository import Gtk

import gettext
_ = gettext.gettext

class BasketBox(Gtk.VBox):
    def __init__(self):
        super(BasketBox, self).__init__()
        self.basketview_cont = Gtk.ScrolledWindow()
        self.basketview_cont.set_shadow_type(Gtk.ShadowType.IN)
        self.basketview_cont.set_policy(Gtk.PolicyType.AUTOMATIC, Gtk.PolicyType.AUTOMATIC)
        self.basketview = PackagesView()
        self.basketview.set_model(self.basketview.model)
        self.basketview_cont.add(self.basketview)
        self.riepilogue_box = Gtk.HBox()
        self.riepilogue_label = Gtk.Label()
        self.riepilogue_bar = Riepilogue()
        self.riepilogue_box.pack_start(self.riepilogue_label, False, False, 0)
        self.riepilogue_box.pack_end(self.riepilogue_bar, False, False, 0)
        self.remove_button = self.riepilogue_bar.clear
        self.install_button = self.riepilogue_bar.button
        self.pack_start(self.basketview_cont, True, True, 0)
        self.pack_start(self.riepilogue_box, False, False, 0)

class Riepilogue(Gtk.Toolbar):
    def __init__(self):
        super(Riepilogue, self).__init__()
        self.set_show_arrow(False)
        self.button = Gtk.ToolButton(label=_("Install Packages"))
        self.button.set_is_important(True)
        self.clear = Gtk.ToolButton(label=_("Clear"))
        self.clear.set_is_important(True)
        self.insert(self.clear, -1)
        self.insert(self.button, -1)

class PackagesView(Gtk.TreeView):
    def __init__(self):
        super(PackagesView, self).__init__()
        self.model = Gtk.ListStore(str, str, str)
        self.namecell = Gtk.CellRendererText()
        self.sizecell = Gtk.CellRendererText()
        self.vercell = Gtk.CellRendererText()
        self.namecolumn = Gtk.TreeViewColumn(_("Package"))
        self.sizecolumn = Gtk.TreeViewColumn(_("To Download"))
        self.vercolumn = Gtk.TreeViewColumn(_("Version"))
        self.namecolumn.pack_start(self.namecell, True)
        self.sizecolumn.pack_start(self.sizecell, False)
        self.vercolumn.pack_start(self.vercell, False)
        self.namecolumn.add_attribute(self.namecell, "text", 0)
        self.sizecolumn.add_attribute(self.sizecell, "text", 1)
        self.vercolumn.add_attribute(self.vercell, "text", 2)
        self.append_column(self.namecolumn)
        self.append_column(self.sizecolumn)
        self.append_column(self.vercolumn)
