#!/usr/bin/env python
# -*- coding:UTF-8 -*-
#       Copyright (c) Stephen Smally <stephen.smally@gmail.com>
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.
#  

from gi.repository import Gtk
from gi.repository import Gdk
from gi.repository import Pango

class InfoBox(Gtk.VBox):
    def __init__(self):
        super(InfoBox, self).__init__()
        self.cssstyle = """
        GtkTextView {
            background-color: @bg_color;
        }
        """;
        
        self.screen = Gdk.Screen.get_default();
        self.providestyle = Gtk.CssProvider();
        self.providestyle.load_from_data(self.cssstyle);
        Gtk.StyleContext.add_provider_for_screen(self.screen, self.providestyle, 600);
        self.frame = Gtk.ScrolledWindow()
        self.frame.set_shadow_type(Gtk.ShadowType.IN)
        self.view = Gtk.Viewport()
        self.view.set_shadow_type(Gtk.ShadowType.NONE)
        self.frame_box = Gtk.VBox()
        self.bar_box = Gtk.HBox()
        self.infos = Infos()
        self.screendesc = ScreenDesc()
        self.details = Details()
        self.bar = InfoBar()
        self.title = self.infos.title
        self.desc = self.infos.desc
        self.icon = self.infos.icon
        self.button = self.bar.button
        self.back = self.bar.back
        self.desctext = self.screendesc.text
        self.scrot = self.screendesc.screen
        self.scrot_button = self.screendesc.screenbutton
        self.frame_box.set_spacing(5)
        self.frame_box.pack_start(self.infos, False, False, 0)
        self.frame_box.pack_start(Gtk.HSeparator(), False, False, 0)
        self.frame_box.pack_start(self.screendesc, True, True, 0)
        self.frame_box.pack_start(Gtk.HSeparator(), False, False, 0)
        self.frame_box.pack_start(self.details, False, False, 0)
        self.view.add(self.frame_box)
        self.frame.add(self.view)
        self.pack_start(self.frame, True, True, 0)
        self.pack_start(self.bar_box, False, False, 0)
        self.bar_box.pack_end(self.bar, False, False, 0)

class Infos(Gtk.HBox):
    def __init__(self):
        super(Infos, self).__init__()
        self.icon = Gtk.Image()
        self.box2 = Gtk.VBox()
        self.title = Gtk.Label()
        self.title.props.xalign = 0
        self.desc = Gtk.Label()
        self.desc.props.xalign = 0
        self.box3 = Gtk.VBox()
        self.box4 = Gtk.VBox()
        self.box2.pack_start(self.title, False, False, 0)
        self.box2.pack_start(self.desc, False, False, 0)
        self.box4.pack_start(self.box2, True, False, 0)
        self.pack_start(self.icon, False, False, 0)
        self.pack_start(self.box4, False, False, 0)

class InfoBar(Gtk.Toolbar):
    def __init__(self):
        super(InfoBar, self).__init__()
        self.set_show_arrow(False)
        self.back = Gtk.ToolButton.new_from_stock(Gtk.STOCK_GO_BACK)
        self.back.set_tooltip_text(_("Back to the page"))
        self.button = Gtk.ToolButton()
        self.button.set_is_important(True)
        self.insert(self.back, -1)
        self.insert(self.button, -1)
        self.set_icon_size(Gtk.IconSize.SMALL_TOOLBAR)


class ScreenDesc(Gtk.HBox):
    def __init__(self):
        super(ScreenDesc, self).__init__()
        self.screenbutton = Gtk.Button()
        self.screenbutton.set_relief(Gtk.ReliefStyle.NONE)
        self.screenbutton_box = Gtk.VBox()
        self.screenbutton_box.pack_start(self.screenbutton, False, False, 0)
        self.screen = Gtk.Image()
        self.screenbutton.add(self.screen)
        self.textview = Gtk.TextView()
        self.textview.set_editable(False)
        self.textview.set_border_width(5)
        self.text = self.textview.get_buffer()
        self.textview_scroll = Gtk.ScrolledWindow()
        self.textview_scroll.set_policy(Gtk.PolicyType.NEVER, Gtk.PolicyType.AUTOMATIC)
        self.textview_scroll.add(self.textview)
        self.pack_start(self.screenbutton_box, False, False, 0)
        self.pack_start(self.textview_scroll, True, True, 0)

class Details(Gtk.VBox):
    def __init__(self):
        super(Details, self).__init__()
        self.version = Gtk.Label()
        self.to_download = Gtk.Label()
        self.installed = Gtk.Label()
        self.pack_start(self.version, False, False, 0)
        self.pack_start(self.to_download, False, False, 0)
        self.pack_start(self.installed, False, False, 0)
