#!/usr/bin/python
# -*- coding:UTF-8 -*-
#       Copyright (c) Stephen Smally <stephen.smally@gmail.com>
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.
#  

from gi.repository import Gtk
from gi.repository import Pango
from gi.repository import Gdk
from notify import notify
import control
import os
from xdg import DesktopEntry as DE
from aptdaemon import client, gtk3widgets
import gettext

_ = gettext.gettext

client = client.AptClient()
dialog = gtk3widgets.AptProgressDialog(debconf=True)

class refresh_system:
    def __init__(self, app):
        control.__init__()
        self.app = app
    
    def run(self):
        '''Generates the packages list'''
        x = 0
        print "start"
        if not control.controller.expert_mode:
            if not control.controller.use_database:
                self.aiddir = os.listdir(self.app.aid)
                for item in self.aiddir:
                    if item.partition(".desktop")[-2] == ".desktop":
                        self.single_pkg = DE.DesktopEntry(self.app.aid+item)
                        x += 1
                        self.app.define_packages(
                        self.single_pkg.getName(),
                        self.single_pkg.get("X-AppInstall-Package"),
                        self.single_pkg.getIcon(),
                        self.single_pkg.getCategories(),
                        (x, len(self.aiddir))
                        )
                    else:
                        x += 1
            else:
                pass
        else:
            for item in self.app.cache.packages:
                x += 1
                self.app.define_packages(item.name,
                item.name,
                None,
                item.section.replace("universe/", "").replace("multiverse/", ""),
                (x, len(self.app.cache.packages))
                )
        self.app.ui.pkgs_count.set_text("%s " % len(self.app.packages)+_("packages"))
        self.app.back_home(None)        
        print("Done")
        print("Generating packages list for fast search")


class append_packages:
    def __init__(self, app, category, status, model):
        control.__init__()
        self.app = app
        self.category = category
        self.status = status
        self.model = model
        self.sortkey = 0
    
    def run(self):
        '''Append the packages to the given Gtk.ListStore'''
        self.status_dict = {
        0: None,
        1: None,
        2: None,
        4: None,
        5: None,
        6: Gtk.STOCK_YES
        }
        x = 0
        print("sensitive!")
        if not control.controller.expert_mode:
            if control.controller.use_database:
                import sqlite3
                self.db = sqlite3.Connection(control.controller.db_path+"lsc_packages.db")
                self.cursor = self.db.cursor()
                for items in self.cursor.execute("select * from %s" % self.category):
                    x += 1
                    self.app.append_packages_appending(items, self.status, self.status_dict, self.model, (1, 1))
        else:
            if self.category == "allpkgs":
                for items in sorted(self.app.packages, key=lambda val: val[self.sortkey]):
                    try:
                        x += 1
                        self.app.append_packages_appending(items, self.status, self.status_dict, self.model, (x, len(self.app.packages)))
                    except KeyError: pass
            else:
                for items in sorted(self.app.packages, key=lambda val: val[self.sortkey]):
                    try:
                        if self.category in items[3]:
                            x += 1
                            self.app.append_packages_appending(items, self.status, self.status_dict, self.model, (x, len(self.app.packages)))
                    except KeyError: pass
        self.app.ui.pkgs_count.set_text("%s " % len(self.model) +_("packages listed"))
        if self.app.ui.search_pkg.search_entry.get_text() != self.app.ui.search_pkg.search_string:
            self.app.ui.search_pkg.search_function(self.app.ui.search_pkg.search_entry.get_text(), 20)


def install_package(pkgs, app):
    transaction = client.install_packages(pkgs)
    transaction.connect("finished", finish_trans, app, True)
    dialog.set_transaction(transaction)
    print("running dialog")
    dialog.run()

def remove_package(pkgs, app):
    transaction = client.remove_packages(pkgs)
    transaction.connect("finished", finish_trans, app, False)
    dialog.set_transaction(transaction)
    print("running dialog")
    dialog.run()

def get_if_apt_lies(pkg):
    '''test if the apt cache lies'''
    result = os.system("apt-get -s install %s" % pkg)
    if result == 0:
        # Apt Cache lies, we can install it!
        return True
    else:
        # It's true, damaged packages
        return False

def finish_trans(transaction, exit_status, root, inst):
    if exit_status == "exit-success":
        dialog.hide()
        print("success")
        if inst:
            notify("installed")
        else:
            notify("removed")
        root.choosed_page = 1
        root.refresh_system_call()
    else:
        dialog.hide()
        finishdialog = gtkwidgets.AptErrorDialog(error=transaction.error)
        finishdialog.run()
        print("failed")

'''
class append_packages_and_search:
    def __init__(self, app, category, status, model, show_few_results):
        control.__init__()
        self.app = app
        self.category = category
        self.status = status
        self.model = model
        self.sortkey = 0
        self.show_few_results = show_few_results
    
    def run(self):
        ''Append the packages to the given Gtk.ListStore''
        self.status_dict = {
        0: None,
        1: None,
        2: None,
        4: None,
        5: None,
        6: Gtk.STOCK_YES
        }
        x = 0
        print("sensitive!")
        if not control.controller.expert_mode:
            if control.controller.use_database:
                import sqlite3
                self.db = sqlite3.Connection(control.controller.db_path+"lsc_packages.db")
                self.cursor = self.db.cursor()
                for items in sorted(self.cursor.execute("select * from %s" % self.category), key=lambda val: val[self.sortkey]):
                    if self.show_few_results:
                        self.app.ui.statusbox.combo.set_visible(True)
                        self.app.ui.statusbox.combo.set_active(0)
                        if self.show_few_results == x:
                            if len(self.apps_model_search) < self.show_few_results:
                                x = 0
                            else:
                                break
                        else:
                            if self.smart_mode:
                                if string in items[0]+items[3]:
                                     self.apps_model_search.append([items[0], items[1], items[2], items[3], items[4], items[5], items[6]])
                            else:
                                if string.lower() in items[0].lower(): # lower() => no case-sensitive
                                    self.apps_model_search.append([items[0], items[1], items[2], items[3], items[4], items[5], items[6]])
                            x += 1
                    else:
                        self.ui.statusbox.combo.set_visible(True)
                        self.ui.statusbox.combo.set_active(1)
                        for items in self.ui.apps_all.model:
                            if self.smart_mode:
                                if string in items[0]+items[3]:
                                     self.apps_model_search.append([items[0], items[1], items[2], items[3], items[4], items[5], items[6]])
                            else:
                                if string.lower() in items[0].lower(): # lower() => no case-sensitive
                                    self.apps_model_search.append([items[0], items[1], items[2], items[3], items[4], items[5], items[6]])
        else:
            if self.category == "allpkgs":
                for items in sorted(self.app.packages, key=lambda val: val[self.sortkey]):
                    try:
                        x += 1
                        self.app.append_packages_appending(items, self.status, self.status_dict, self.model, (x, len(self.app.packages)))
                    except KeyError: pass
            else:
                for items in sorted(self.app.packages, key=lambda val: val[self.sortkey]):
                    try:
                        if self.category in items[3]:
                            x += 1
                            self.app.append_packages_appending(items, self.status, self.status_dict, self.model, (x, len(self.app.packages)))
                    except KeyError: pass
        self.app.ui.pkgs_count.set_text("%s " % len(self.model) +_("packages listed") % len(self.model))
        if self.app.ui.search_pkg.search_entry.get_text() != self.app.ui.search_pkg.search_string:
            self.app.ui.search_pkg.search_function(self.app.ui.search_pkg.search_entry.get_text(), 20)
'''
