#!/usr/bin/python
#       Copyright (c) Stephen Smally <stephen.smally@gmail.com>
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.
#  
import gettext
from gi.repository import Notify
Notify.init("Lubuntu Software Center")
_ = gettext.gettext

def notify(message):
    if(message == "installed"):
        notify_installed = Notify.Notification.new("Lubuntu Software Centre", _("Apps installed successfully"), "lubuntu-software-center")
        notify_installed.show()
    
    elif(message == "removed"):
        notify_uninstalled = Notify.Notification.new("Lubuntu Software Centre", _("Apps removed successfully"), "lubuntu-software-center")
        notify_uninstalled.show()
    
    elif (message == "no-connection"):
        notify_connection = Notify.Notification.new("Lubuntu Software Centre", _("No connection found, you can't install \n applications, however you can browse for them"), "lubuntu-software-center")
        notify_connection.show()
    
    else:
        print("ERROR: No rule for command:", message)



