# -*- coding:UTF-8 -*-
#       Copyright (c) Julien Lavergne <gilir@ubuntu.com>
#
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.
#
import os

import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk
from gi.repository import Gio

list_gtk_icon = [
"gtk-about"
, "gtk-add"
, "gtk-apply"
, "gtk-bold"
, "gtk-cancel"
, "gtk-caps-lock-warning"
, "gtk-cdrom"
, "gtk-clear"
, "gtk-close"
, "gtk-color-picker"
, "gtk-convert"
, "gtk-connect"
, "gtk-copy"
, "gtk-cut"
, "gtk-delete"
, "gtk-dialog-authentication"
, "gtk-dialog-error"
, "gtk-dialog-info"
, "gtk-dialog-question"
, "gtk-dialog-warning"
, "gtk-directory"
, "gtk-discard"
, "gtk-disconnect"
, "gtk-dnd"
, "gtk-dnd-multiple"
, "gtk-edit"
, "gtk-execute"
, "gtk-file"
, "gtk-find"
, "gtk-find-and-replace"
, "gtk-floppy"
, "gtk-fullscreen"
, "gtk-goto-bottom"
, "gtk-goto-first"
, "gtk-goto-last"
, "gtk-goto-top"
, "gtk-go-back"
, "gtk-go-down"
, "gtk-go-forward"
, "gtk-go-up"
, "gtk-harddisk"
, "gtk-help"
, "gtk-home"
, "gtk-indent"
, "gtk-index"
, "gtk-info"
, "gtk-italic"
, "gtk-jump-to"
, "gtk-justify-center"
, "gtk-justify-fill"
, "gtk-justify-left"
, "gtk-leave-fullscreen"
, "gtk-media-forward"
, "gtk-media-next"
, "gtk-media-pause"
, "gtk-media-play"
, "gtk-media-previous"
, "gtk-media-record"
, "gtk-media-rewind"
, "gtk-media-stop"
, "gtk-missing-image"
, "gtk-network"
, "gtk-new"
, "gtk-no"
, "gtk-ok"
, "gtk-open"
, "gtk-orientation-landscape"
, "gtk-orientation-portrait"
, "gtk-orientation-reverse-landscape"
, "gtk-orientation-reverse-portrait"
, "gtk-page-setup"
, "gtk-paste"
, "gtk-preferences"
, "gtk-print"
, "gtk-print-error"
, "gtk-print-paused"
, "gtk-print-preview"
, "gtk-print-report"
, "gtk-print-warning"
, "gtk-properties"
, "gtk-quit"
, "gtk-redo"
, "gtk-refresh"
, "gtk-remove"
, "gtk-revert-to-saved"
, "gtk-save"
, "gtk-save-as"
, "gtk-select-all"
, "gtk-select-color"
, "gtk-select-font"
, "gtk-sort-ascending"
, "gtk-sort-descending"
, "gtk-spell-check"
, "gtk-stop"
, "gtk-strikethrough"
, "gtk-undelete"
, "gtk-underline"
, "gtk-undo"
, "gtk-unindent"
, "gtk-yes"
, "gtk-zoom-100"
, "gtk-zoom-fit"
, "gtk-zoom-in"
, "gtk-zoom-out"
]
list_xdg_icon = [
"address-book-new"
, "application-exit"
, "appointment-new"
, "call-start"
, "call-stop"
, "contact-new"
, "document-new"
, "document-open"
, "document-open-recent"
, "document-page-setup"
, "document-print"
, "document-print-preview"
, "document-properties"
, "document-revert"
, "document-save"
, "document-save-as"
, "document-send"
, "edit-clear"
, "edit-copy"
, "edit-cut"
, "edit-delete"
, "edit-find"
, "edit-find-replace"
, "edit-paste"
, "edit-redo"
, "edit-select-all"
, "edit-undo"
, "folder-new"
, "format-indent-less"
, "format-indent-more"
, "format-justify-center"
, "format-justify-fill"
, "format-justify-left"
, "format-justify-right"
, "format-text-direction-ltr"
, "format-text-direction-rtl"
, "format-text-bold"
, "format-text-italic"
, "format-text-underline"
, "format-text-strikethrough"
, "go-bottom"
, "go-down"
, "go-first"
, "go-home"
, "go-jump"
, "go-last"
, "go-next"
, "go-previous"
, "go-top"
, "go-up"
, "help-about"
, "help-contents"
, "help-faq"
, "insert-image"
, "insert-link"
, "insert-object"
, "insert-text"
, "list-add"
, "list-remove"
, "mail-forward"
, "mail-mark-important"
, "mail-mark-junk"
, "mail-mark-notjunk"
, "mail-mark-read"
, "mail-mark-unread"
, "mail-message-new"
, "mail-reply-all"
, "mail-reply-sender"
, "mail-send"
, "mail-send-receive"
, "media-eject"
, "media-playback-pause"
, "media-playback-start"
, "media-playback-stop"
, "media-record"
, "media-seek-backward"
, "media-seek-forward"
, "media-skip-backward"
, "media-skip-forward"
, "object-flip-horizontal"
, "object-flip-vertical"
, "object-rotate-left"
, "object-rotate-right"
, "process-stop"
, "system-lock-screen"
, "system-log-out"
, "system-run"
, "system-search"
, "system-reboot"
, "system-shutdown"
, "tools-check-spelling"
, "view-fullscreen"
, "view-refresh"
, "view-restore"
, "view-sort-ascending"
, "view-sort-descending"
, "window-close"
, "window-new"
, "zoom-fit-best"
, "zoom-in"
, "zoom-original"
, "zoom-out"
, "process-working"
, "accessories-calculator"
, "accessories-character-map"
, "accessories-dictionary"
, "accessories-text-editor"
, "help-browser"
, "multimedia-volume-control"
, "preferences-desktop-accessibility"
, "preferences-desktop-font"
, "preferences-desktop-keyboard"
, "preferences-desktop-locale"
, "preferences-desktop-multimedia"
, "preferences-desktop-screensaver"
, "preferences-desktop-theme"
, "preferences-desktop-wallpaper"
, "system-file-manager"
, "system-software-install"
, "system-software-update"
, "utilities-system-monitor"
, "utilities-terminal"
, "applications-accessories"
, "applications-development"
, "applications-engineering"
, "applications-games"
, "applications-graphics"
, "applications-internet"
, "applications-multimedia"
, "applications-office"
, "applications-other"
, "applications-science"
, "applications-system"
, "applications-utilities"
, "preferences-desktop"
, "preferences-desktop-peripherals"
, "preferences-desktop-personal"
, "preferences-other"
, "preferences-system"
, "preferences-system-network"
, "system-help"
, "audio-card"
, "audio-input-microphone"
, "battery"
, "camera-photo"
, "camera-video"
, "camera-web"
, "computer"
, "drive-harddisk"
, "drive-optical"
, "drive-removable-media"
, "input-gaming"
, "input-keyboard"
, "input-mouse"
, "input-tablet"
, "media-flash"
, "media-floppy"
, "media-optical"
, "media-tape"
, "modem"
, "multimedia-player"
, "network-wired"
, "network-wireless"
, "pda"
, "phone"
, "printer"
, "scanner"
, "video-display"
, "emblem-default"
, "emblem-documents"
, "emblem-downloads"
, "emblem-favorite"
, "emblem-important"
, "emblem-mail"
, "emblem-photos"
, "emblem-readonly"
, "emblem-shared"
, "emblem-symbolic-link"
, "emblem-synchronized"
, "emblem-system"
, "emblem-unreadable"
, "face-angel"
, "face-angry"
, "face-cool"
, "face-crying"
, "face-devilish"
, "face-embarrassed"
, "face-kiss"
, "face-laugh"
, "face-monkey"
, "face-plain"
, "face-raspberry"
, "face-sad"
, "face-sick"
, "face-smile"
, "face-smile-big"
, "face-smirk"
, "face-surprise"
, "face-tired"
, "face-uncertain"
, "face-wink"
, "face-worried"
, "flag-aa"
#TODO more flags
, "application-x-executable"
, "audio-x-generic"
, "font-x-generic"
, "image-x-generic"
, "package-x-generic"
, "text-html"
, "text-x-generic"
, "text-x-generic-template"
, "text-x-script"
, "video-x-generic"
, "x-office-address-book"
, "x-office-calendar"
, "x-office-document"
, "x-office-presentation"
, "x-office-spreadsheet"
, "folder"
, "folder-remote"
, "network-server"
, "network-workgroup"
, "start-here"
, "user-bookmarks"
, "user-desktop"
, "user-home"
, "user-trash"
, "appointment-missed"
, "appointment-soon"
, "audio-volume-high"
, "audio-volume-low"
, "audio-volume-medium"
, "audio-volume-muted"
, "battery-caution"
, "battery-low"
, "dialog-error"
, "dialog-information"
, "dialog-password"
, "dialog-question"
, "dialog-warning"
, "folder-drag-accept"
, "folder-open"
, "folder-visiting"
, "image-loading"
, "image-missing"
, "mail-attachment"
, "mail-unread"
, "mail-read"
, "mail-replied"
, "mail-signed"
, "mail-signed-verified"
, "media-playlist-repeat"
, "media-playlist-shuffle"
, "network-error"
, "network-idle"
, "network-offline"
, "network-receive"
, "network-transmit"
, "network-transmit-receive"
, "printer-error"
, "printer-printing"
, "security-high"
, "security-medium"
, "security-low"
, "software-update-available"
, "software-update-urgent"
, "sync-error"
, "sync-synchronizing"
, "task-due"
, "task-past-due"
, "user-available"
, "user-away"
, "user-idle"
, "user-offline"
, "user-trash-full"
, "weather-clear"
, "weather-clear-night"
, "weather-few-clouds"
, "weather-few-clouds-night"
, "weather-fog"
, "weather-overcast"
, "weather-severe-alert"
, "weather-showers"
, "weather-showers-scattered"
, "weather-snow"
, "weather-storm"
]

theme = Gtk.IconTheme.get_default()

list_icons = theme.list_icons()

for icon in list_icons:
    supported_size = theme.get_icon_sizes(icon)
    for size in supported_size:
        lookup = theme.lookup_icon(icon, size, Gtk.IconLookupFlags.GENERIC_FALLBACK)
        path = lookup.get_filename()

        path_split = path.rsplit("/")
        theme_name = path_split[4]

        size_location = str(size)

        print(path)

        if theme_name == "gnome" or theme_name == "Adwaita":
            size_location_list = path_split[5].rsplit("x")
            size_location = size_location_list[0]
            location = path_split[6]
            file_name = path_split[7]
        else:
            size_location = path_split[6]
            location = path_split[5]
            if location == "symbolic":
                size_location = ""
                file_name = path_split[6]
            else:
                file_name = path_split[7]

        print("icon: " + icon + ", size: %i" % size + ", path: " + path + ", theme:" + theme_name + ", location:" + location)

        destination_prefix = "import"

        # 1 folder by theme
        destination_path = os.path.join(destination_prefix,"imported-" + theme_name,size_location)

        if theme_name != "Lubuntu":
            if theme_name != "hicolor":
                if theme_name != "share":
                    icon_to_copy = Gio.File.new_for_path(path)
                    destination = Gio.File.new_for_path(os.path.join(destination_path,file_name))

                    if os.path.exists(destination_path) == False:
                        os.makedirs(destination_path)

                    if os.path.exists(destination.get_path()) == False:
                        if os.path.islink(destination.get_path()) == False:
                            icon_to_copy.copy(destination, Gio.FileCopyFlags.NOFOLLOW_SYMLINKS)
