# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.7
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.


"""
LTTng 2.1.1

The  LTTng  project  aims at providing highly efficient tracing tools for Linux.
It's tracers help tracking down performance issues and debugging problems involving
multiple concurrent processes and threads. Tracing across multiple systems is also possible.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_lttng', [dirname(__file__)])
        except ImportError:
            import _lttng
            return _lttng
        if fp is not None:
            try:
                _mod = imp.load_module('_lttng', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _lttng = swig_import_helper()
    del swig_import_helper
else:
    import _lttng
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


import collections
DOMAIN_KERNEL = _lttng.DOMAIN_KERNEL
DOMAIN_UST = _lttng.DOMAIN_UST
EVENT_ALL = _lttng.EVENT_ALL
EVENT_TRACEPOINT = _lttng.EVENT_TRACEPOINT
EVENT_PROBE = _lttng.EVENT_PROBE
EVENT_FUNCTION = _lttng.EVENT_FUNCTION
EVENT_FUNCTION_ENTRY = _lttng.EVENT_FUNCTION_ENTRY
EVENT_NOOP = _lttng.EVENT_NOOP
EVENT_SYSCALL = _lttng.EVENT_SYSCALL
EVENT_LOGLEVEL_ALL = _lttng.EVENT_LOGLEVEL_ALL
EVENT_LOGLEVEL_RANGE = _lttng.EVENT_LOGLEVEL_RANGE
EVENT_LOGLEVEL_SINGLE = _lttng.EVENT_LOGLEVEL_SINGLE
LOGLEVEL_EMERG = _lttng.LOGLEVEL_EMERG
LOGLEVEL_ALERT = _lttng.LOGLEVEL_ALERT
LOGLEVEL_CRIT = _lttng.LOGLEVEL_CRIT
LOGLEVEL_ERR = _lttng.LOGLEVEL_ERR
LOGLEVEL_WARNING = _lttng.LOGLEVEL_WARNING
LOGLEVEL_NOTICE = _lttng.LOGLEVEL_NOTICE
LOGLEVEL_INFO = _lttng.LOGLEVEL_INFO
LOGLEVEL_DEBUG_SYSTEM = _lttng.LOGLEVEL_DEBUG_SYSTEM
LOGLEVEL_DEBUG_PROGRAM = _lttng.LOGLEVEL_DEBUG_PROGRAM
LOGLEVEL_DEBUG_PROCESS = _lttng.LOGLEVEL_DEBUG_PROCESS
LOGLEVEL_DEBUG_MODULE = _lttng.LOGLEVEL_DEBUG_MODULE
LOGLEVEL_DEBUG_UNIT = _lttng.LOGLEVEL_DEBUG_UNIT
LOGLEVEL_DEBUG_FUNCTION = _lttng.LOGLEVEL_DEBUG_FUNCTION
LOGLEVEL_DEBUG_LINE = _lttng.LOGLEVEL_DEBUG_LINE
LOGLEVEL_DEBUG = _lttng.LOGLEVEL_DEBUG
EVENT_SPLICE = _lttng.EVENT_SPLICE
EVENT_MMAP = _lttng.EVENT_MMAP
EVENT_CONTEXT_PID = _lttng.EVENT_CONTEXT_PID
EVENT_CONTEXT_PERF_COUNTER = _lttng.EVENT_CONTEXT_PERF_COUNTER
EVENT_CONTEXT_PROCNAME = _lttng.EVENT_CONTEXT_PROCNAME
EVENT_CONTEXT_PRIO = _lttng.EVENT_CONTEXT_PRIO
EVENT_CONTEXT_NICE = _lttng.EVENT_CONTEXT_NICE
EVENT_CONTEXT_VPID = _lttng.EVENT_CONTEXT_VPID
EVENT_CONTEXT_TID = _lttng.EVENT_CONTEXT_TID
EVENT_CONTEXT_VTID = _lttng.EVENT_CONTEXT_VTID
EVENT_CONTEXT_PPID = _lttng.EVENT_CONTEXT_PPID
EVENT_CONTEXT_VPPID = _lttng.EVENT_CONTEXT_VPPID
EVENT_CONTEXT_PTHREAD_ID = _lttng.EVENT_CONTEXT_PTHREAD_ID
CALIBRATE_FUNCTION = _lttng.CALIBRATE_FUNCTION

def _lttng_create_handle(*args):
  return _lttng._lttng_create_handle(*args)
_lttng_create_handle = _lttng._lttng_create_handle

def _lttng_destroy_handle(*args):
  return _lttng._lttng_destroy_handle(*args)
_lttng_destroy_handle = _lttng._lttng_destroy_handle

def _lttng_list_channels(*args):
  return _lttng._lttng_list_channels(*args)
_lttng_list_channels = _lttng._lttng_list_channels

def _lttng_list_events(*args):
  return _lttng._lttng_list_events(*args)
_lttng_list_events = _lttng._lttng_list_events

def _lttng_list_tracepoints(*args):
  return _lttng._lttng_list_tracepoints(*args)
_lttng_list_tracepoints = _lttng._lttng_list_tracepoints

def _lttng_add_context(*args):
  return _lttng._lttng_add_context(*args)
_lttng_add_context = _lttng._lttng_add_context

def _lttng_enable_event(*args):
  return _lttng._lttng_enable_event(*args)
_lttng_enable_event = _lttng._lttng_enable_event

def _lttng_enable_channel(*args):
  return _lttng._lttng_enable_channel(*args)
_lttng_enable_channel = _lttng._lttng_enable_channel

def _lttng_disable_event(*args):
  return _lttng._lttng_disable_event(*args)
_lttng_disable_event = _lttng._lttng_disable_event

def _lttng_disable_channel(*args):
  return _lttng._lttng_disable_channel(*args)
_lttng_disable_channel = _lttng._lttng_disable_channel

def _lttng_calibrate(*args):
  return _lttng._lttng_calibrate(*args)
_lttng_calibrate = _lttng._lttng_calibrate

def _lttng_register_consumer(*args):
  return _lttng._lttng_register_consumer(*args)
_lttng_register_consumer = _lttng._lttng_register_consumer

def _lttng_list_sessions():
  return _lttng._lttng_list_sessions()
_lttng_list_sessions = _lttng._lttng_list_sessions

def _lttng_list_domains(*args):
  return _lttng._lttng_list_domains(*args)
_lttng_list_domains = _lttng._lttng_list_domains

def create(*args):
  """
    create(str name, str path) -> int

    Create a new tracing session using name and path.
    Returns size of returned session payload data or a negative error code.
    """
  return _lttng.create(*args)

def destroy(*args):
  """
    destroy(str name) -> int

    Tear down tracing session using name.
    Returns size of returned session payload data or a negative error code.
    """
  return _lttng.destroy(*args)

def session_daemon_alive():
  """
    session_daemon_alive() -> int

    Check if session daemon is alive.
    Return 1 if alive or 0 if not.
    On error returns a negative value.
    """
  return _lttng.session_daemon_alive()

def set_tracing_group(*args):
  """
    set_tracing_group(str name) -> int

    Sets the tracing_group variable with name.
    This function allocates memory pointed to by tracing_group.
    On success, returns 0, on error, returns -1 (null name) or -ENOMEM.
    """
  return _lttng.set_tracing_group(*args)

def strerror(*args):
  """
    strerror(int code) -> char

    Returns a human readable string describing
    the error code (a negative value).
    """
  return _lttng.strerror(*args)

def start(*args):
  """
    start(str session_name) -> int

    Start tracing for all traces of the session.
    Returns size of returned session payload data or a negative error code.
    """
  return _lttng.start(*args)

def stop(*args):
  """
    stop(str session_name) -> int

    Stop tracing for all traces of the session.
    Returns size of returned session payload data or a negative error code.
    """
  return _lttng.stop(*args)

def channel_set_default_attr(*args):
  """
    channel_set_default_attr(Domain domain, ChannelAttr attr)

    Set default channel attributes.
    If either or both of the arguments are null, attr content is zeroe'd.
    """
  return _lttng.channel_set_default_attr(*args)
def list_sessions():
	"""
	list_sessions() -> dict

	Ask the session daemon for all available sessions.
	Returns a dict of Session instances, the key is the name;
	on error, returns a negative value.
	"""

	ses_list = _lttng_list_sessions()
	if type(ses_list) is int:
		return ses_list

	sessions = {}

	for ses_elements in ses_list:
		ses = Session()
		ses.name = ses_elements[0]
		ses.path = ses_elements[1]
		ses.enabled = ses_elements[2]
		ses.padding = ses_elements[3]

		sessions[ses.name] = ses

	return sessions


def list_domains(session_name):
	"""
	list_domains(str session_name) -> list

	Ask the session daemon for all available domains of a session.
	Returns a list of Domain instances;
	on error, returns a negative value.
	"""

	dom_list = _lttng_list_domains(session_name)
	if type(dom_list) is int:
		return dom_list

	domains = []

	for dom_elements in dom_list:
		dom = Domain()
		dom.type = dom_elements[0]
		dom.paddinf = dom_elements[1]
		dom.attr.pid = dom_elements[2]
		dom.attr.exec_name = dom_elements[3]
		dom.attr.padding = dom_elements[4]

		domains.append(dom)

	return domains


def list_channels(handle):
	"""
	list_channels(Handle handle) -> dict

	Ask the session daemon for all available channels of a session.
	Returns a dict of Channel instances, the key is the name;
	on error, returns a negative value.
	"""

	try:
		chan_list = _lttng_list_channels(handle._h)
	except AttributeError:
		raise TypeError("in method 'list_channels', argument 1 must be a Handle instance")

	if type(chan_list) is int:
		return chan_list

	channels = {}

	for channel_elements in chan_list:
		chan = Channel()
		chan.name = channel_elements[0]
		chan.enabled = channel_elements[1]
		chan.padding = channel_elements[2]
		chan.attr.overwrite = channel_elements[3][0]
		chan.attr.subbuf_size = channel_elements[3][1]
		chan.attr.num_subbuf = channel_elements[3][2]
		chan.attr.switch_timer_interval = channel_elements[3][3]
		chan.attr.read_timer_interval = channel_elements[3][4]
		chan.attr.output = channel_elements[3][5]
		chan.attr.padding = channel_elements[3][6]

		channels[chan.name] = chan

	return channels


def list_events(handle, channel_name):
	"""
	list_events(Handle handle, str channel_name) -> dict

	Ask the session daemon for all available events of a session channel.
	Returns a dict of Event instances, the key is the name;
	on error, returns a negative value.
	"""

	try:
		ev_list = _lttng_list_events(handle._h, channel_name)
	except AttributeError:
		raise TypeError("in method 'list_events', argument 1 must be a Handle instance")

	if type(ev_list) is int:
		return ev_list

	events = {}

	for ev_elements in ev_list:
		ev = Event()
		ev.name = ev_elements[0]
		ev.type = ev_elements[1]
		ev.loglevel_type = ev_elements[2]
		ev.loglevel = ev_elements[3]
		ev.enabled = ev_elements[4]
		ev.pid = ev_elements[5]
		ev.attr.padding = ev_elements[6]
		ev.attr.probe.addr = ev_elements[7][0]
		ev.attr.probe.offset = ev_elements[7][1]
		ev.attr.probe.symbol_name = ev_elements[7][2]
		ev.attr.probe.padding = ev_elements[7][3]
		ev.attr.ftrace.symbol_name = ev_elements[8][0]
		ev.attr.ftrace.padding = ev_elements[8][1]
		ev.attr.padding = ev_elements[9]

		events[ev.name] = ev

	return events


def list_tracepoints(handle):
	"""
	list_tracepoints(Handle handle) -> dict

	Returns a dict of Event instances, the key is the name;
	on error, returns a negative value.
	"""

	try:
		ev_list = _lttng_list_tracepoints(handle._h)
	except AttributeError:
		raise TypeError("in method 'list_tracepoints', argument 1 must be a Handle instance")

	if type(ev_list) is int:
		return ev_list

	events = {}

	for ev_elements in ev_list:
		ev = Event()
		ev.name = ev_elements[0]
		ev.type = ev_elements[1]
		ev.loglevel_type = ev_elements[2]
		ev.loglevel = ev_elements[3]
		ev.enabled = ev_elements[4]
		ev.pid = ev_elements[5]
		ev.attr.padding = ev_elements[6]
		ev.attr.probe.addr = ev_elements[7][0]
		ev.attr.probe.offset = ev_elements[7][1]
		ev.attr.probe.symbol_name = ev_elements[7][2]
		ev.attr.probe.padding = ev_elements[7][3]
		ev.attr.ftrace.symbol_name = ev_elements[8][0]
		ev.attr.ftrace.padding = ev_elements[8][1]
		ev.attr.padding = ev_elements[9]

		events[ev.name] = ev

	return events


def register_consumer(handle, socket_path):
	"""
	register_consumer(Handle handle, str socket_path) -> int

	Register an outside consumer.
	Returns size of returned session payload data or a negative error code.
	"""

	try:
		return _lttng_register_consumer(handle._h, socket_path)
	except AttributeError:
		raise TypeError("in method 'register_consumer', argument 1 must be a Handle instance")


def add_context(handle, event_context, event_name, channel_name):
	"""
	add_context(Handle handle, EventContext ctx,
		    str event_name, str channel_name) -> int

	Add context to event and/or channel.
	If event_name is None, the context is applied to all events of the channel.
	If channel_name is None, a lookup of the event's channel is done.
	If both are None, the context is applied to all events of all channels.
	Returns the size of the returned payload data or a negative error code.
	"""

	try:
		return _lttng_add_context(handle._h, event_context, event_name, channel_name)
	except AttributeError:
		raise TypeError("in method 'add_context', argument 1 must be a Handle instance")


def enable_event(handle, event, channel_name):
	"""
	enable_event(Handle handle, Event event,
		    str channel_name) -> int

	Enable event(s) for a channel.
	If no event name is specified, all events are enabled.
	If no channel name is specified, the default 'channel0' is used.
	Returns size of returned session payload data or a negative error code.
	"""

	try:
		return _lttng_enable_event(handle._h, event, channel_name)
	except AttributeError:
		raise TypeError("in method 'enable_event', argument 1 must be a Handle instance")


def enable_channel(handle, channel):
	"""
	enable_channel(Handle handle, Channel channel -> int

	Enable channel per domain
	Returns size of returned session payload data or a negative error code.
	"""

	try:
		return _lttng_enable_channel(handle._h, channel)
	except AttributeError:
		raise TypeError("in method 'enable_channel', argument 1 must be a Handle instance")


def disable_event(handle, name, channel_name):
	"""
	disable_event(Handle handle, str name, str channel_name) -> int

	Disable event(s) of a channel and domain.
	If no event name is specified, all events are disabled.
	If no channel name is specified, the default 'channel0' is used.
	Returns size of returned session payload data or a negative error code
	"""

	try:
		return _lttng_disable_event(handle._h, name, channel_name)
	except AttributeError:
		raise TypeError("in method 'disable_event', argument 1 must be a Handle instance")


def disable_channel(handle, name):
	"""
	disable_channel(Handle handle, str name) -> int

	All tracing will be stopped for registered events of the channel.
	Returns size of returned session payload data or a negative error code.
	"""

	try:
		return _lttng_disable_channel(handle._h, name)
	except AttributeError:
		raise TypeError("in method 'disable_channel', argument 1 must be a Handle instance")


def calibrate(handle, calibrate):
	"""
	calibrate(Handle handle, Calibrate calibrate) -> int

	Quantify LTTng overhead.
	Returns size of returned session payload data or a negative error code.
	"""

	try:
		return _lttng_calibrate(handle._h, calibrate)
	except AttributeError:
		raise TypeError("in method 'calibrate', argument 1 must be a Handle instance")

class Handle:
        """
	Manages a handle.
	Takes two arguments: (str session_name, Domain domain)
	"""

	__frozen = False

	def __init__(self, session_name, domain):
		if type(session_name) is not str:
			raise TypeError("in method '__init__', argument 2 of type 'str'")
		if type(domain) is not Domain and domain is not None:
			raise TypeError("in method '__init__', argument 3 of type 'lttng.Domain'")

		self._sname = session_name
		if domain is None:
			self._domtype = None
		else:
			self._domtype = domain.type
		self._h = _lttng_create_handle(session_name, domain)
		self.__frozen = True

	def __del__(self):
		_lttng_destroy_handle(self._h)

	def __repr__(self):
		if self._domtype == 1:
			domstr = "DOMAIN_KERNEL"
		elif self._domtype == 2:
			domstr = "DOMAIN_UST"
		else:
			domstr = self._domtype

		return "lttng.Handle; session('{}'), domain.type({})".format(
			self._sname, domstr)

	def __setattr__(self, attr, val):
		if self.__frozen:
			raise NotImplementedError("cannot modify attributes")
		else:
			self.__dict__[attr] = val

class Domain(_object):
    """Proxy of C lttng_domain struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Domain, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Domain, name)
    __swig_setmethods__["type"] = _lttng.Domain_type_set
    __swig_getmethods__["type"] = _lttng.Domain_type_get
    if _newclass:type = _swig_property(_lttng.Domain_type_get, _lttng.Domain_type_set)
    __swig_setmethods__["padding"] = _lttng.Domain_padding_set
    __swig_getmethods__["padding"] = _lttng.Domain_padding_get
    if _newclass:padding = _swig_property(_lttng.Domain_padding_get, _lttng.Domain_padding_set)
    def __repr__(self):
        """__repr__(Domain self) -> char *"""
        return _lttng.Domain___repr__(self)

    __swig_getmethods__["attr"] = _lttng.Domain_attr_get
    if _newclass:attr = _swig_property(_lttng.Domain_attr_get)
    def __init__(self): 
        """__init__(lttng_domain self) -> Domain"""
        this = _lttng.new_Domain()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_Domain
    __del__ = lambda self : None;
Domain_swigregister = _lttng.Domain_swigregister
Domain_swigregister(Domain)

class lttng_domain_attr(_object):
    """Proxy of C lttng_domain_attr struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, lttng_domain_attr, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, lttng_domain_attr, name)
    __repr__ = _swig_repr
    __swig_setmethods__["pid"] = _lttng.lttng_domain_attr_pid_set
    __swig_getmethods__["pid"] = _lttng.lttng_domain_attr_pid_get
    if _newclass:pid = _swig_property(_lttng.lttng_domain_attr_pid_get, _lttng.lttng_domain_attr_pid_set)
    __swig_setmethods__["exec_name"] = _lttng.lttng_domain_attr_exec_name_set
    __swig_getmethods__["exec_name"] = _lttng.lttng_domain_attr_exec_name_get
    if _newclass:exec_name = _swig_property(_lttng.lttng_domain_attr_exec_name_get, _lttng.lttng_domain_attr_exec_name_set)
    __swig_setmethods__["padding"] = _lttng.lttng_domain_attr_padding_set
    __swig_getmethods__["padding"] = _lttng.lttng_domain_attr_padding_get
    if _newclass:padding = _swig_property(_lttng.lttng_domain_attr_padding_get, _lttng.lttng_domain_attr_padding_set)
    def __init__(self): 
        """__init__(lttng_domain_attr self) -> lttng_domain_attr"""
        this = _lttng.new_lttng_domain_attr()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_lttng_domain_attr
    __del__ = lambda self : None;
lttng_domain_attr_swigregister = _lttng.lttng_domain_attr_swigregister
lttng_domain_attr_swigregister(lttng_domain_attr)

class EventContext(_object):
    """Proxy of C lttng_event_context struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, EventContext, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, EventContext, name)
    __swig_setmethods__["ctx"] = _lttng.EventContext_ctx_set
    __swig_getmethods__["ctx"] = _lttng.EventContext_ctx_get
    if _newclass:ctx = _swig_property(_lttng.EventContext_ctx_get, _lttng.EventContext_ctx_set)
    __swig_setmethods__["padding"] = _lttng.EventContext_padding_set
    __swig_getmethods__["padding"] = _lttng.EventContext_padding_get
    if _newclass:padding = _swig_property(_lttng.EventContext_padding_get, _lttng.EventContext_padding_set)
    def __repr__(self):
        """__repr__(EventContext self) -> char *"""
        return _lttng.EventContext___repr__(self)

    __swig_getmethods__["u"] = _lttng.EventContext_u_get
    if _newclass:u = _swig_property(_lttng.EventContext_u_get)
    def __init__(self): 
        """__init__(lttng_event_context self) -> EventContext"""
        this = _lttng.new_EventContext()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_EventContext
    __del__ = lambda self : None;
EventContext_swigregister = _lttng.EventContext_swigregister
EventContext_swigregister(EventContext)

class lttng_event_context_u(_object):
    """Proxy of C lttng_event_context_u struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, lttng_event_context_u, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, lttng_event_context_u, name)
    __repr__ = _swig_repr
    __swig_setmethods__["perf_counter"] = _lttng.lttng_event_context_u_perf_counter_set
    __swig_getmethods__["perf_counter"] = _lttng.lttng_event_context_u_perf_counter_get
    if _newclass:perf_counter = _swig_property(_lttng.lttng_event_context_u_perf_counter_get, _lttng.lttng_event_context_u_perf_counter_set)
    __swig_setmethods__["padding"] = _lttng.lttng_event_context_u_padding_set
    __swig_getmethods__["padding"] = _lttng.lttng_event_context_u_padding_get
    if _newclass:padding = _swig_property(_lttng.lttng_event_context_u_padding_get, _lttng.lttng_event_context_u_padding_set)
    def __init__(self): 
        """__init__(lttng_event_context_u self) -> lttng_event_context_u"""
        this = _lttng.new_lttng_event_context_u()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_lttng_event_context_u
    __del__ = lambda self : None;
lttng_event_context_u_swigregister = _lttng.lttng_event_context_u_swigregister
lttng_event_context_u_swigregister(lttng_event_context_u)

class lttng_event_probe_attr(_object):
    """Proxy of C lttng_event_probe_attr struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, lttng_event_probe_attr, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, lttng_event_probe_attr, name)
    __repr__ = _swig_repr
    __swig_setmethods__["addr"] = _lttng.lttng_event_probe_attr_addr_set
    __swig_getmethods__["addr"] = _lttng.lttng_event_probe_attr_addr_get
    if _newclass:addr = _swig_property(_lttng.lttng_event_probe_attr_addr_get, _lttng.lttng_event_probe_attr_addr_set)
    __swig_setmethods__["offset"] = _lttng.lttng_event_probe_attr_offset_set
    __swig_getmethods__["offset"] = _lttng.lttng_event_probe_attr_offset_get
    if _newclass:offset = _swig_property(_lttng.lttng_event_probe_attr_offset_get, _lttng.lttng_event_probe_attr_offset_set)
    __swig_setmethods__["symbol_name"] = _lttng.lttng_event_probe_attr_symbol_name_set
    __swig_getmethods__["symbol_name"] = _lttng.lttng_event_probe_attr_symbol_name_get
    if _newclass:symbol_name = _swig_property(_lttng.lttng_event_probe_attr_symbol_name_get, _lttng.lttng_event_probe_attr_symbol_name_set)
    __swig_setmethods__["padding"] = _lttng.lttng_event_probe_attr_padding_set
    __swig_getmethods__["padding"] = _lttng.lttng_event_probe_attr_padding_get
    if _newclass:padding = _swig_property(_lttng.lttng_event_probe_attr_padding_get, _lttng.lttng_event_probe_attr_padding_set)
    def __init__(self): 
        """__init__(lttng_event_probe_attr self) -> lttng_event_probe_attr"""
        this = _lttng.new_lttng_event_probe_attr()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_lttng_event_probe_attr
    __del__ = lambda self : None;
lttng_event_probe_attr_swigregister = _lttng.lttng_event_probe_attr_swigregister
lttng_event_probe_attr_swigregister(lttng_event_probe_attr)

class lttng_event_function_attr(_object):
    """Proxy of C lttng_event_function_attr struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, lttng_event_function_attr, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, lttng_event_function_attr, name)
    __repr__ = _swig_repr
    __swig_setmethods__["symbol_name"] = _lttng.lttng_event_function_attr_symbol_name_set
    __swig_getmethods__["symbol_name"] = _lttng.lttng_event_function_attr_symbol_name_get
    if _newclass:symbol_name = _swig_property(_lttng.lttng_event_function_attr_symbol_name_get, _lttng.lttng_event_function_attr_symbol_name_set)
    __swig_setmethods__["padding"] = _lttng.lttng_event_function_attr_padding_set
    __swig_getmethods__["padding"] = _lttng.lttng_event_function_attr_padding_get
    if _newclass:padding = _swig_property(_lttng.lttng_event_function_attr_padding_get, _lttng.lttng_event_function_attr_padding_set)
    def __init__(self): 
        """__init__(lttng_event_function_attr self) -> lttng_event_function_attr"""
        this = _lttng.new_lttng_event_function_attr()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_lttng_event_function_attr
    __del__ = lambda self : None;
lttng_event_function_attr_swigregister = _lttng.lttng_event_function_attr_swigregister
lttng_event_function_attr_swigregister(lttng_event_function_attr)

class Event(_object):
    """Proxy of C lttng_event struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Event, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Event, name)
    __swig_setmethods__["type"] = _lttng.Event_type_set
    __swig_getmethods__["type"] = _lttng.Event_type_get
    if _newclass:type = _swig_property(_lttng.Event_type_get, _lttng.Event_type_set)
    __swig_setmethods__["name"] = _lttng.Event_name_set
    __swig_getmethods__["name"] = _lttng.Event_name_get
    if _newclass:name = _swig_property(_lttng.Event_name_get, _lttng.Event_name_set)
    __swig_setmethods__["loglevel_type"] = _lttng.Event_loglevel_type_set
    __swig_getmethods__["loglevel_type"] = _lttng.Event_loglevel_type_get
    if _newclass:loglevel_type = _swig_property(_lttng.Event_loglevel_type_get, _lttng.Event_loglevel_type_set)
    __swig_setmethods__["loglevel"] = _lttng.Event_loglevel_set
    __swig_getmethods__["loglevel"] = _lttng.Event_loglevel_get
    if _newclass:loglevel = _swig_property(_lttng.Event_loglevel_get, _lttng.Event_loglevel_set)
    __swig_setmethods__["enabled"] = _lttng.Event_enabled_set
    __swig_getmethods__["enabled"] = _lttng.Event_enabled_get
    if _newclass:enabled = _swig_property(_lttng.Event_enabled_get, _lttng.Event_enabled_set)
    __swig_setmethods__["pid"] = _lttng.Event_pid_set
    __swig_getmethods__["pid"] = _lttng.Event_pid_get
    if _newclass:pid = _swig_property(_lttng.Event_pid_get, _lttng.Event_pid_set)
    __swig_setmethods__["padding"] = _lttng.Event_padding_set
    __swig_getmethods__["padding"] = _lttng.Event_padding_get
    if _newclass:padding = _swig_property(_lttng.Event_padding_get, _lttng.Event_padding_set)
    def __repr__(self):
        """__repr__(Event self) -> char *"""
        return _lttng.Event___repr__(self)

    __swig_getmethods__["attr"] = _lttng.Event_attr_get
    if _newclass:attr = _swig_property(_lttng.Event_attr_get)
    def __init__(self): 
        """__init__(lttng_event self) -> Event"""
        this = _lttng.new_Event()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_Event
    __del__ = lambda self : None;
Event_swigregister = _lttng.Event_swigregister
Event_swigregister(Event)

class lttng_event_attr(_object):
    """Proxy of C lttng_event_attr struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, lttng_event_attr, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, lttng_event_attr, name)
    __repr__ = _swig_repr
    __swig_setmethods__["probe"] = _lttng.lttng_event_attr_probe_set
    __swig_getmethods__["probe"] = _lttng.lttng_event_attr_probe_get
    if _newclass:probe = _swig_property(_lttng.lttng_event_attr_probe_get, _lttng.lttng_event_attr_probe_set)
    __swig_setmethods__["ftrace"] = _lttng.lttng_event_attr_ftrace_set
    __swig_getmethods__["ftrace"] = _lttng.lttng_event_attr_ftrace_get
    if _newclass:ftrace = _swig_property(_lttng.lttng_event_attr_ftrace_get, _lttng.lttng_event_attr_ftrace_set)
    __swig_setmethods__["padding"] = _lttng.lttng_event_attr_padding_set
    __swig_getmethods__["padding"] = _lttng.lttng_event_attr_padding_get
    if _newclass:padding = _swig_property(_lttng.lttng_event_attr_padding_get, _lttng.lttng_event_attr_padding_set)
    def __init__(self): 
        """__init__(lttng_event_attr self) -> lttng_event_attr"""
        this = _lttng.new_lttng_event_attr()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_lttng_event_attr
    __del__ = lambda self : None;
lttng_event_attr_swigregister = _lttng.lttng_event_attr_swigregister
lttng_event_attr_swigregister(lttng_event_attr)

class Calibrate(_object):
    """Proxy of C lttng_calibrate struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Calibrate, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Calibrate, name)
    __swig_setmethods__["type"] = _lttng.Calibrate_type_set
    __swig_getmethods__["type"] = _lttng.Calibrate_type_get
    if _newclass:type = _swig_property(_lttng.Calibrate_type_get, _lttng.Calibrate_type_set)
    __swig_setmethods__["padding"] = _lttng.Calibrate_padding_set
    __swig_getmethods__["padding"] = _lttng.Calibrate_padding_get
    if _newclass:padding = _swig_property(_lttng.Calibrate_padding_get, _lttng.Calibrate_padding_set)
    def __repr__(self):
        """__repr__(Calibrate self) -> char *"""
        return _lttng.Calibrate___repr__(self)

    def __init__(self): 
        """__init__(lttng_calibrate self) -> Calibrate"""
        this = _lttng.new_Calibrate()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_Calibrate
    __del__ = lambda self : None;
Calibrate_swigregister = _lttng.Calibrate_swigregister
Calibrate_swigregister(Calibrate)

class ChannelAttr(_object):
    """Proxy of C lttng_channel_attr struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ChannelAttr, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ChannelAttr, name)
    __swig_setmethods__["overwrite"] = _lttng.ChannelAttr_overwrite_set
    __swig_getmethods__["overwrite"] = _lttng.ChannelAttr_overwrite_get
    if _newclass:overwrite = _swig_property(_lttng.ChannelAttr_overwrite_get, _lttng.ChannelAttr_overwrite_set)
    __swig_setmethods__["subbuf_size"] = _lttng.ChannelAttr_subbuf_size_set
    __swig_getmethods__["subbuf_size"] = _lttng.ChannelAttr_subbuf_size_get
    if _newclass:subbuf_size = _swig_property(_lttng.ChannelAttr_subbuf_size_get, _lttng.ChannelAttr_subbuf_size_set)
    __swig_setmethods__["num_subbuf"] = _lttng.ChannelAttr_num_subbuf_set
    __swig_getmethods__["num_subbuf"] = _lttng.ChannelAttr_num_subbuf_get
    if _newclass:num_subbuf = _swig_property(_lttng.ChannelAttr_num_subbuf_get, _lttng.ChannelAttr_num_subbuf_set)
    __swig_setmethods__["switch_timer_interval"] = _lttng.ChannelAttr_switch_timer_interval_set
    __swig_getmethods__["switch_timer_interval"] = _lttng.ChannelAttr_switch_timer_interval_get
    if _newclass:switch_timer_interval = _swig_property(_lttng.ChannelAttr_switch_timer_interval_get, _lttng.ChannelAttr_switch_timer_interval_set)
    __swig_setmethods__["read_timer_interval"] = _lttng.ChannelAttr_read_timer_interval_set
    __swig_getmethods__["read_timer_interval"] = _lttng.ChannelAttr_read_timer_interval_get
    if _newclass:read_timer_interval = _swig_property(_lttng.ChannelAttr_read_timer_interval_get, _lttng.ChannelAttr_read_timer_interval_set)
    __swig_setmethods__["output"] = _lttng.ChannelAttr_output_set
    __swig_getmethods__["output"] = _lttng.ChannelAttr_output_get
    if _newclass:output = _swig_property(_lttng.ChannelAttr_output_get, _lttng.ChannelAttr_output_set)
    __swig_setmethods__["padding"] = _lttng.ChannelAttr_padding_set
    __swig_getmethods__["padding"] = _lttng.ChannelAttr_padding_get
    if _newclass:padding = _swig_property(_lttng.ChannelAttr_padding_get, _lttng.ChannelAttr_padding_set)
    def __repr__(self):
        """__repr__(ChannelAttr self) -> char *"""
        return _lttng.ChannelAttr___repr__(self)

    def __init__(self): 
        """__init__(lttng_channel_attr self) -> ChannelAttr"""
        this = _lttng.new_ChannelAttr()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_ChannelAttr
    __del__ = lambda self : None;
ChannelAttr_swigregister = _lttng.ChannelAttr_swigregister
ChannelAttr_swigregister(ChannelAttr)

class Channel(_object):
    """Proxy of C lttng_channel struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Channel, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Channel, name)
    __swig_setmethods__["name"] = _lttng.Channel_name_set
    __swig_getmethods__["name"] = _lttng.Channel_name_get
    if _newclass:name = _swig_property(_lttng.Channel_name_get, _lttng.Channel_name_set)
    __swig_setmethods__["enabled"] = _lttng.Channel_enabled_set
    __swig_getmethods__["enabled"] = _lttng.Channel_enabled_get
    if _newclass:enabled = _swig_property(_lttng.Channel_enabled_get, _lttng.Channel_enabled_set)
    __swig_setmethods__["attr"] = _lttng.Channel_attr_set
    __swig_getmethods__["attr"] = _lttng.Channel_attr_get
    if _newclass:attr = _swig_property(_lttng.Channel_attr_get, _lttng.Channel_attr_set)
    __swig_setmethods__["padding"] = _lttng.Channel_padding_set
    __swig_getmethods__["padding"] = _lttng.Channel_padding_get
    if _newclass:padding = _swig_property(_lttng.Channel_padding_get, _lttng.Channel_padding_set)
    def __repr__(self):
        """__repr__(Channel self) -> char *"""
        return _lttng.Channel___repr__(self)

    def __init__(self): 
        """__init__(lttng_channel self) -> Channel"""
        this = _lttng.new_Channel()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_Channel
    __del__ = lambda self : None;
Channel_swigregister = _lttng.Channel_swigregister
Channel_swigregister(Channel)

class Session(_object):
    """Proxy of C lttng_session struct"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Session, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Session, name)
    __swig_setmethods__["name"] = _lttng.Session_name_set
    __swig_getmethods__["name"] = _lttng.Session_name_get
    if _newclass:name = _swig_property(_lttng.Session_name_get, _lttng.Session_name_set)
    __swig_setmethods__["path"] = _lttng.Session_path_set
    __swig_getmethods__["path"] = _lttng.Session_path_get
    if _newclass:path = _swig_property(_lttng.Session_path_get, _lttng.Session_path_set)
    __swig_setmethods__["enabled"] = _lttng.Session_enabled_set
    __swig_getmethods__["enabled"] = _lttng.Session_enabled_get
    if _newclass:enabled = _swig_property(_lttng.Session_enabled_get, _lttng.Session_enabled_set)
    __swig_setmethods__["padding"] = _lttng.Session_padding_set
    __swig_getmethods__["padding"] = _lttng.Session_padding_get
    if _newclass:padding = _swig_property(_lttng.Session_padding_get, _lttng.Session_padding_set)
    def __repr__(self):
        """__repr__(Session self) -> char *"""
        return _lttng.Session___repr__(self)

    def __init__(self): 
        """__init__(lttng_session self) -> Session"""
        this = _lttng.new_Session()
        try: self.this.append(this)
        except: self.this = this
    __swig_destroy__ = _lttng.delete_Session
    __del__ = lambda self : None;
Session_swigregister = _lttng.Session_swigregister
Session_swigregister(Session)

# This file is compatible with both classic and new-style classes.


