# This file is part of LTSP, https://ltsp.github.io
# Copyright 2019 the LTSP team, see AUTHORS
# SPDX-License-Identifier: GPL-3.0-or-later

# Handle CRONTAB_x parameters and disable unecessary cron jobs
# @LTSP.CONF: CRONTAB_x

cron_main() {
    local var

    if [ -d /etc/cron.d ]; then
        {
            echo "# Generated by \`ltsp init\`, see man:ltsp(8)"
            re echo_values "CRONTAB_[[:alnum:]_]*"
        } >/etc/cron.d/ltsp
    fi

    # Disable several cronjobs that are usually present but that
    # cause unnecessary load.
    while read -r var; do
        rm -f "$var"
    done <<EOF
/etc/cron.d/popularity-contest
/etc/cron.daily/apt
/etc/cron.daily/apt-compat
/etc/cron.daily/aptitude
/etc/cron.daily/cracklib-runtime
/etc/cron.daily/dpkg
/etc/cron.daily/logrotate
/etc/cron.daily/man-db
/etc/cron.daily/mlocate
/etc/cron.daily/passwd
/etc/cron.daily/popularity-contest
/etc/cron.daily/standard
/etc/cron.daily/ubuntu-advantage-tools
/etc/cron.daily/update-notifier-common
/etc/cron.monthly/ieee-data
/etc/cron.weekly/apt-xapian-index
/etc/cron.weekly/man-db
/etc/cron.weekly/update-notifier-common
EOF
}
