<?php
/*
 * LTSP-Cluster Control Center
 * Copyright (2008-2009) Stéphane Graber <stgraber@ubuntu.com>, Revolution Linux Inc.

 * Author: Stéphane Graber <stgraber@ubuntu.com>

 * 2008, Stéphane Graber <stgraber@ubuntu.com>
 * 2009, Stéphane Graber <stgraber@ubuntu.com>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of·
 * the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, you can find it on the World Wide
 * Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

    include "includes/xmlrpc/xmlrpc.inc";
    include "includes/xmlrpc/xmlrpcs.inc";

    # This module access the Load Balancer server to retrieve its current status and allow to easily 

    class LoadBalancer {
        static private $_instance = null;
        private $_status = null; # The status array
        private $_xmlclient = null; # The xmlrpc_client object connected to the Load Balancer

        # Make sure we don't end up with two instances of the same class
        static public function getInstance($server, $port) {
            if (self::$_instance == null)
                self::$_instance = new LoadBalancer($server, $port);
            return self::$_instance;
        }

        # Open the connection with the Load Balancer
        public function __construct($server, $port) {
            $this->_xmlclient = new xmlrpc_client("", "$server", $port) or die ("Connection information for the Load Balancer is invalid.");
            $this->_xmlclient->return_type = 'phpvals';
        }

        # Get and store the status of the Load Balancer.
        public function updateStatus() {
            # Query the loadbalancer for its status
            $message = new xmlrpcmsg("get_status", array());
            $resp = $this->_xmlclient->send($message);

            # Parse the answer and generate a status array
            $lbstatus=array();
            foreach ($resp->value() as $group) {
                $lbstatus[$group['name']]=array();
                foreach ($group['nodes'] as $node) {
                    $lbstatus[$group['name']][$node['name']]=array();
                    $lbstatus[$group['name']][$node['name']]['active']=$node['active'];
                    foreach ($node['values'] as $value) {
                        $lbstatus[$group['name']][$node['name']][$value['name']]=$value['value'];
                    }
                }
            }
            $this->_status=$lbstatus;
        }

        # Return the status array
        #FIXME: Only public for debugging purposes
        public function getStatusRaw() {
            # If no status stored, retrieve the current one
            if ($this->_status == null) {
                $this->updateStatus();
            }
            return $this->_status;
        }

        # Return the list of groups
        public function getGroups() {
            return array_keys($this->getStatusRaw());
        }

        # Return status of a specific server
        public function getServerStatus($group, $server) {
            $status=$this->getStatusRaw();
            return $status[$group][$server];
        }
    }
?>
