<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/

function printAttributeInput(&$attribute) {
?>
	<tr>
	<td>
	  <input type="checkbox" name="selection[]" value="<?= $attribute->getAttributeDefID() ?>"/>
	</td>
<?php
	$message = getNameMessage($attribute->getName(),false);
	echo "<td>";
	if( isMessage("url_wiki")) {
		echo "<a href='".getMessage("url_wiki").$attribute->getName()."' target='_blank' title='".$attribute->getName()."'>".$message."</a> =";
	} else {
		echo $message." =";
	}
	echo "</td>";
	switch($attribute->getType()) {
		case 0:
			//if ($_POST[$attribute->getName()]) {
			//	$value = 'value="'.$_POST[$attribute->getName()].'"';
			//}
			if ($attribute->getValue()) {
				$value = "value=".qstr($attribute->getValue())."";
			}
			else {
				$value = "";
			}
?>
	<td>
	  <input type="text" name="<?= $attribute->getName() ?>" <?= $value ?> />
	  <input type="hidden" name="hidden<?= $attribute->getName() ?>" <?= $value ?> />
	<?php if($attribute->getEditable()){
		$selection = $attribute->getSelection();
	?><?= getMessage("or") ?>
	  <select name="list<?= $attribute->getName() ?>" id="list<?= $attribute->getName() ?>">
        <option value="-1" selected="selected"><?= getMessage("choosePredefineValue") ?></option>
       <?php foreach ($selection as $value => $selected) {?>
       	 <option value="<?=$value?>"><?=$value?></option>
       <?php } ?>
      </select>
	<?php } ?>
	</td>
<?php
			break;
		case 1:
		case 2:
			$selection = $attribute->getSelection();
			if (is_array($_POST[$attribute->getName()])) {
				foreach ($_POST[$attribute->getName()] as $value) {
					$previousSelection[$value] = true;
				}
				$selection = array_merge($selection,$previousSelection);
			}
?>
	<td><select name="<?= $attribute->getName() ?>[]" <?php if ($attribute->getType() == 2) print "multiple=\"multiple\" size=10"; ?>>
<?php
				if (is_array($selection)) {
					foreach ($selection as $value => $selected) {
?>
	<option value="<?= $value ?>" <?php if ($selected) print 'selected="selected"'; ?>><?= getValueMessage($attribute->getName(),$value) ?></option>
<?php
					}
				}
?>
	</select>
	</td>
<?php
				break;
	}
	if (strtolower(get_class($attribute))== "attributedef") {
?>
	<input type="hidden" name="newAttributes[]" value="<?= $attribute->getAttributeDefID() ?>">
<?php
	}
?>
	</tr>
<?php
}
?>
<h3><?= getMessage('configuration_manage_attribute') ?></h3>
<form  name="attributes" action="admin.php?<?= getGETParam() ?>" method="post">
<table border=0>
<?php
// If $this->attributes is not empty do;
// Sort the attributes with their names
//usort ($this->allAttributes, "sortAttributesByLangName");
if ( ! empty($this->attributes)){
    usort ($this->attributes, "sortObjectsByLangName");
    if (is_array($this->attributes)){
	    foreach ($this->attributes as $attribute) {
		    printAttributeInput($attribute);
	    }
    }
}

?>
</table>
<p>
<?php if(is_array($this->attributes)) { ?>
<input type="submit" name="modify_attr" value="<?= getMessage('modify') ?>" />
<input type="submit" name="delete_attr" value="<?= getMessage('delete') ?>" />
<?php } ?>
</p>
<p>
<?php
if(!empty($this->allAttributes)){
?>

<?php
	echo getMessage('select_attribute');
	echo "<!--";
	print_r( $this->allAttributes );
	echo "-->";
?>
<select name="newAttribute">
<?php
  foreach ($this->allAttributes as $id => $name) {
	echo "<option value='".$id."'>".getNameMessage($name)."</option>";
}
?>
</select>
<input type="submit" name="add_attr" value="<?= getMessage("add") ?>" />
</p>
<?php
}
?>
</form>
<?php
if($this->node->nodetype == COMPUTER_TYPE && !empty($this->hardware)){
?>
	<hr />
	<h3><?= getMessage("hardware_specification") ?></h3>
<blockquote>
	<?php foreach($this->hardware as $hardware){
	print $hardware['hwkey']."='".$hardware['hwvalue']."'<br />";
	 } ?>
</blockquote>
<?php
}
?>
<?php $this->printErrors(); ?>
<hr />
