/*
 * Crackerjack Project
 *
 * Copyright (C) 2007-2008, Hitachi, Ltd.
 * Author(s): Takahiro Yasui <takahiro.yasui.mp@hitachi.com>,
 *            Yumiko Sugita <yumiko.sugita.yf@hitachi.com>,
 *            Satoshi Fujiwara <sa-fuji@sdl.hitachi.co.jp>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * $Id: gettid01.c,v 1.1 2008/06/17 14:19:28 subrata_modak Exp $
 *
 */

/* Porting from Crackerjack to LTP is done
   by Masatake YAMATO <yamato@redhat.com> */


#include <sys/types.h>
#include <linux/unistd.h>
#include <errno.h>


#include "test.h"
#include "usctest.h"


void setup();
void cleanup();


char *TCID = "gettid01";	/* Test program identifier.    */
extern int Tst_count;		/* Test Case counter for tst_* routines */

int TST_TOTAL = 1;


pid_t
my_gettid (void)
{
    return (pid_t)syscall(__NR_gettid);
}

int main(int ac, char **av)
{
    int lc;			/* loop counter */
    char *msg;			/* parse_opts() return message */

    if ((msg = parse_opts(ac, av, (option_t *)NULL, NULL)) != (char *)NULL){
	tst_brkm(TBROK, tst_exit, "OPTION PARSING ERROR - %s", msg);
	/*NOTREACHED*/
    }

    setup();

    /*
     * The following loop checks looping state if -c option given
     */
    for (lc = 0; TEST_LOOPING(lc); lc++) {

	Tst_count = 0;


	TEST(my_gettid());


	if ( TEST_RETURN == -1 ) {
	    TEST_ERROR_LOG(TEST_ERRNO);
	    tst_resm(TFAIL, "gettid() Failed, errno=%d: %s",
		     TEST_ERRNO, strerror(TEST_ERRNO));
	} else {
	    /***************************************************************
	     * only perform functional verification if flag set (-f not given)
	     ***************************************************************/
	    if ( STD_FUNCTIONAL_TEST ) {
		/* No Verification test, yet... */
		tst_resm(TPASS, "gettid() returned %d", TEST_RETURN);
	    }
	}
    }

    cleanup();

    /*NOTREACHED*/
    return(0);
}



/*
 * setup() - performs all ONE TIME setup for this test.
 */
void 
setup()
{
    /* capture signals */
    tst_sig(NOFORK, DEF_HANDLER, cleanup);

    /* Pause if that option was specified */
    TEST_PAUSE;

}	/* End setup() */


/*
 * cleanup() - performs all ONE TIME cleanup for this test at
 *		completion or premature exit.
 */
void 
cleanup()
{
    /*
     * print timing stats if that option was specified.
     * print errno log if that option was specified.
     */
    TEST_CLEANUP;

    /* exit with return code appropriate for results */
    tst_exit();

}	/* End cleanup() */
