/*
   b_ptr_stat.cpp   Generated by the Ballista(tm) Project data object compiler
   Copyright (C) 1998-2001  Carnegie Mellon University

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   File generated Saturday, December 18 at 10:20 AM CST

TITLE
   b_ptr_stat.cpp
*/

//--------------------------------------------------------------------

#include <errno.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <stream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "b_ptr_stat.h"

//--------------------------------------------------------------------


static struct stat stat_temp;

#define TESTDIR "testdir"
#define TESTFILE "testdir/testfile_stat"
//--------------------------------------------------------------------

CLASSNAME::CLASSNAME()
{
  //DIAL DECLARATIONS HERE

  //generated

   strcpy(_b_ptr_statTYPENAME,CLASS_STRING);
strcpy(_b_ptr_statZEROS,"b_ptr_stat_ZEROS");
strcpy(_b_ptr_statNEG1S,"b_ptr_stat_NEG1S");
strcpy(_b_ptr_statMAX,"b_ptr_stat_MAX");
strcpy(_b_ptr_statFILE_SH,"b_ptr_stat_FILE_SH");
strcpy(_b_ptr_statFILE_PASSWD,"b_ptr_stat_FILE_PASSWD");
strcpy(_b_ptr_statFILE_TEST,"b_ptr_stat_FILE_TEST");
}

//--------------------------------------------------------------------
b_param *b_ptr_stat::b_ptr_statZEROS()
{
   return &_b_ptr_statZEROS;
}

b_param *b_ptr_stat::b_ptr_statNEG1S()
{
   return &_b_ptr_statNEG1S;
}

b_param *b_ptr_stat::b_ptr_statMAX()
{
   return &_b_ptr_statMAX;
}

b_param *b_ptr_stat::b_ptr_statFILE_SH()
{
   return &_b_ptr_statFILE_SH;
}

b_param *b_ptr_stat::b_ptr_statFILE_PASSWD()
{
   return &_b_ptr_statFILE_PASSWD;
}

b_param *b_ptr_stat::b_ptr_statFILE_TEST()
{
   return &_b_ptr_statFILE_TEST;
}

//--------------------------------------------------------------------
//---------------------------------------------------------------------------
//type name return method

b_param *CLASSNAME::typeName()
{
  return &_b_ptr_statTYPENAME;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
int CLASSNAME::distanceFromBase()
{
  return CLASSPARENT::distanceFromBase() +1;
}


//---------------------------------------------------------------------------
void CLASSNAME::typeList(b_param list[], int num)
{
  strcpy(list[num],(char *) typeName());
  CLASSPARENT::typeList(list,num+1);
}
//--------------------------------------------------------------------
  void *CLASSNAME::access(b_param data[])
{
  if (strcmp(data[0],(char *)typeName())!=0)
    return CLASSPARENT::access(data);

  //ACCESS CODE
b_ptr_stat_zeros = 0;
b_ptr_stat_neg1s = 0;
b_ptr_stat_max = 0;
b_ptr_stat_file_sh = 0;
b_ptr_stat_file_passwd = 0;
b_ptr_stat_file_test = 0;
   int dataPTR =0;


   dataPTR++;
if (strcmp(data[dataPTR],_b_ptr_statZEROS)==0)
      b_ptr_stat_zeros = 1;
   else if (strcmp(data[dataPTR],_b_ptr_statNEG1S)==0)
      b_ptr_stat_neg1s = 1;
   else if (strcmp(data[dataPTR],_b_ptr_statMAX)==0)
      b_ptr_stat_max = 1;
   else if (strcmp(data[dataPTR],_b_ptr_statFILE_SH)==0)
      b_ptr_stat_file_sh = 1;
   else if (strcmp(data[dataPTR],_b_ptr_statFILE_PASSWD)==0)
      b_ptr_stat_file_passwd = 1;
   else if (strcmp(data[dataPTR],_b_ptr_statFILE_TEST)==0)
      b_ptr_stat_file_test = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"STAT"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

if (b_ptr_stat_zeros==1)
{

 stat_temp.st_mode = 0;
 stat_temp.st_ino = 0;
 stat_temp.st_dev = 0;
 stat_temp.st_nlink = 0;
 stat_temp.st_uid = 0;
 stat_temp.st_gid = 0;
 stat_temp.st_size = 0;
 stat_temp.st_atime = 0;
 stat_temp.st_mtime = 0;
 stat_temp.st_ctime = 0;
 
}

if (b_ptr_stat_neg1s==1)
{

 stat_temp.st_mode = -1;
 stat_temp.st_ino = -1;
 stat_temp.st_dev = -1;
 stat_temp.st_nlink = -1;
 stat_temp.st_uid = -1;
 stat_temp.st_gid = -1;
 stat_temp.st_size = -1;
 stat_temp.st_atime = -1;
 stat_temp.st_mtime = -1;
 stat_temp.st_ctime = -1;
 
}

if (b_ptr_stat_max==1)
{
 
 stat_temp.st_mode = 2*MAXINT +1;
 stat_temp.st_ino = 2*MAXINT +1;
 stat_temp.st_dev = MAXINT; 
 stat_temp.st_nlink = 2*MAXSHORT +1;
 stat_temp.st_uid = MAXINT;
 stat_temp.st_gid = MAXINT; 
 stat_temp.st_size = MAXLONG; 
 stat_temp.st_atime = MAXINT;
 stat_temp.st_mtime = MAXINT;
 stat_temp.st_ctime = MAXINT;
 
}

if (b_ptr_stat_file_sh==1)
{

 if((stat("/bin/sh", &stat_temp))!=0)
 {
 perror("stat(\"/bin/sh\")failed ");
 }
 
}

if (b_ptr_stat_file_passwd==1)
{

 if((stat("/etc/passwd", &stat_temp))!=0)
 {
 perror("stat(\"/etc/passwd\") failed");
 }
 
}

if (b_ptr_stat_file_test==1)
{

 int fd;

 

 FILE* logFile = NULL;
 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 exit(99);
 }

 if (mkdir(TESTDIR,S_IRWXU|S_IRWXG|S_IRWXO)!=0) /* create test directory, u+rwx */
 {
 
 if (errno != EEXIST) 
 {
 fprintf(logFile,"b_ptr_stat - FILE_TEST mkdir(\"testdir\")failed. Function not tested\n");
 fclose(logFile);
 exit(99);
 }
 }

 
 chown(TESTFILE, getuid(), getgid()); 
 chmod(TESTFILE, S_IRUSR|S_IWUSR|S_IROTH|S_IWOTH);
 rmdir(TESTFILE);
 remove(TESTFILE);

 fd = open (TESTFILE, O_WRONLY | O_CREAT | O_TRUNC, 0644);
 if (fd == -1) 
 {
 fprintf (logFile, "b_ptr_stat - FILE_TEST open in stat_createfile\n");
 fclose(logFile);
 exit(99);
 }

 write (fd, "I am a test file.\n", 18);

 if (close (fd)!=0)
 {
 fprintf (logFile, "b_ptr_stat - FILE_TEST close in stat_createfile\n");
 fclose(logFile);
 exit(99);
 }

 if((stat(TESTFILE, &stat_temp))!=0)
 {
 fprintf(logFile, "b_ptr_stat - FILE_TEST stat(TESTFILE failed)\n");
 fclose(logFile);
 exit(99);
 }
 fclose(logFile);
 
}

 _theVariable = &stat_temp;
   return &_theVariable;
}

//--------------------------------------------------------------------
  int CLASSNAME::commit(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::commit(tname);
  //COMMIT CODE HERE
//generated
   return 0;
}

//--------------------------------------------------------------------
  int CLASSNAME::cleanup(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::cleanup(tname);
      
  //CLEANUP CODE
//generated

if (b_ptr_stat_file_test==1)
{

 remove(TESTFILE); 

 rmdir(TESTDIR);
 
}
   return 0;
}

//--------------------------------------------------------------------
int CLASSNAME::numDials(b_param tname)
{
  if (!strcmp(tname,(char *)typeName()))
    return NUMBER_OF_DIALS;
  else return CLASSPARENT::numDials(tname);
      
}


//---------------------------------------------------------------------------
int CLASSNAME::numItems(b_param tname,int dialNumber)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::numItems(tname,dialNumber);
  switch (dialNumber)
    {
      //NUMITEMS SWITCH CASES HERE
      //generated

   case 1:
      return 6;
      break;
//---------------------------------------------------------------------------
      //end generated

    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::numItems\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);
    }
  return 0;
}

//---------------------------------------------------------------------------
b_param *CLASSNAME::paramName(b_param tname,
                                   int dialNumber,
                                   int position)

{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::paramName(tname,dialNumber,position);
  
  switch (dialNumber)
    {
      //PARAMNAME SWITCH CASES HERE
      //generated

case 1:
 switch (position)
   {
      case 1:
         return b_ptr_statZEROS();
         break;
      case 2:
         return b_ptr_statNEG1S();
         break;
      case 3:
         return b_ptr_statMAX();
         break;
      case 4:
         return b_ptr_statFILE_SH();
         break;
      case 5:
         return b_ptr_statFILE_PASSWD();
         break;
      case 6:
         return b_ptr_statFILE_TEST();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;
    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::paramName\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);

    }
  return NULL;
}

//---------------------------------------------------------------------------
