/*
   b_ptr_buf.cpp   Generated by the Ballista(tm) Project data object compiler
   Copyright (C) 1998-2001  Carnegie Mellon University

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   File generated Friday, December 17 at 05:53 PM CST

TITLE
   b_ptr_buf.cpp
*/

//--------------------------------------------------------------------

#include <errno.h>
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <stream.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "b_ptr_buf.h"

//--------------------------------------------------------------------


#define bm_PAGESIZE 4096
#define fillbuf(buf,len) for (int i=0; i<len; i++) buf[i] = 'a'
static char *save_loc_buf = NULL; 



int fib(int i) 
{
 if (i <= 1) 
 {
 return (1);
 } 
 else 
 {
 return (fib(i-1) + fib(i-2));
 }
}

//--------------------------------------------------------------------

CLASSNAME::CLASSNAME()
{
  //DIAL DECLARATIONS HERE

  //generated

   strcpy(_b_ptr_bufTYPENAME,CLASS_STRING);
strcpy(_b_ptr_bufBUF_SMALL,"b_ptr_buf_BUF_SMALL");
strcpy(_b_ptr_bufBUF_MED,"b_ptr_buf_BUF_MED");
strcpy(_b_ptr_bufBUF_LARGE,"b_ptr_buf_BUF_LARGE");
strcpy(_b_ptr_bufBUF_XLARGE,"b_ptr_buf_BUF_XLARGE");
strcpy(_b_ptr_bufBUF_HUGE,"b_ptr_buf_BUF_HUGE");
strcpy(_b_ptr_bufBUFMAX,"b_ptr_buf_BUFMAX");
strcpy(_b_ptr_bufBUF_64K,"b_ptr_buf_BUF_64K");
strcpy(_b_ptr_bufBUF_END_MED,"b_ptr_buf_BUF_END_MED");
strcpy(_b_ptr_bufBUF_FAR_PAST,"b_ptr_buf_BUF_FAR_PAST");
strcpy(_b_ptr_bufBUF_ODD,"b_ptr_buf_BUF_ODD");
strcpy(_b_ptr_bufBUF_FREED,"b_ptr_buf_BUF_FREED");
strcpy(_b_ptr_bufBUF_CODE,"b_ptr_buf_BUF_CODE");
strcpy(_b_ptr_bufBUF_LOW,"b_ptr_buf_BUF_LOW");
}

//--------------------------------------------------------------------
b_param *b_ptr_buf::b_ptr_bufBUF_SMALL()
{
   return &_b_ptr_bufBUF_SMALL;
}

b_param *b_ptr_buf::b_ptr_bufBUF_MED()
{
   return &_b_ptr_bufBUF_MED;
}

b_param *b_ptr_buf::b_ptr_bufBUF_LARGE()
{
   return &_b_ptr_bufBUF_LARGE;
}

b_param *b_ptr_buf::b_ptr_bufBUF_XLARGE()
{
   return &_b_ptr_bufBUF_XLARGE;
}

b_param *b_ptr_buf::b_ptr_bufBUF_HUGE()
{
   return &_b_ptr_bufBUF_HUGE;
}

b_param *b_ptr_buf::b_ptr_bufBUFMAX()
{
   return &_b_ptr_bufBUFMAX;
}

b_param *b_ptr_buf::b_ptr_bufBUF_64K()
{
   return &_b_ptr_bufBUF_64K;
}

b_param *b_ptr_buf::b_ptr_bufBUF_END_MED()
{
   return &_b_ptr_bufBUF_END_MED;
}

b_param *b_ptr_buf::b_ptr_bufBUF_FAR_PAST()
{
   return &_b_ptr_bufBUF_FAR_PAST;
}

b_param *b_ptr_buf::b_ptr_bufBUF_ODD()
{
   return &_b_ptr_bufBUF_ODD;
}

b_param *b_ptr_buf::b_ptr_bufBUF_FREED()
{
   return &_b_ptr_bufBUF_FREED;
}

b_param *b_ptr_buf::b_ptr_bufBUF_CODE()
{
   return &_b_ptr_bufBUF_CODE;
}

b_param *b_ptr_buf::b_ptr_bufBUF_LOW()
{
   return &_b_ptr_bufBUF_LOW;
}

//--------------------------------------------------------------------
//---------------------------------------------------------------------------
//type name return method

b_param *CLASSNAME::typeName()
{
  return &_b_ptr_bufTYPENAME;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
int CLASSNAME::distanceFromBase()
{
  return CLASSPARENT::distanceFromBase() +1;
}


//---------------------------------------------------------------------------
void CLASSNAME::typeList(b_param list[], int num)
{
  strcpy(list[num],(char *) typeName());
  CLASSPARENT::typeList(list,num+1);
}
//--------------------------------------------------------------------
  void *CLASSNAME::access(b_param data[])
{
  if (strcmp(data[0],(char *)typeName())!=0)
    return CLASSPARENT::access(data);

  //ACCESS CODE
b_ptr_buf_buf_small = 0;
b_ptr_buf_buf_med = 0;
b_ptr_buf_buf_large = 0;
b_ptr_buf_buf_xlarge = 0;
b_ptr_buf_buf_huge = 0;
b_ptr_buf_bufmax = 0;
b_ptr_buf_buf_64k = 0;
b_ptr_buf_buf_end_med = 0;
b_ptr_buf_buf_far_past = 0;
b_ptr_buf_buf_odd = 0;
b_ptr_buf_buf_freed = 0;
b_ptr_buf_buf_code = 0;
b_ptr_buf_buf_low = 0;
   int dataPTR =0;


   dataPTR++;
if (strcmp(data[dataPTR],_b_ptr_bufBUF_SMALL)==0)
      b_ptr_buf_buf_small = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_MED)==0)
      b_ptr_buf_buf_med = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_LARGE)==0)
      b_ptr_buf_buf_large = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_XLARGE)==0)
      b_ptr_buf_buf_xlarge = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_HUGE)==0)
      b_ptr_buf_buf_huge = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUFMAX)==0)
      b_ptr_buf_bufmax = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_64K)==0)
      b_ptr_buf_buf_64k = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_END_MED)==0)
      b_ptr_buf_buf_end_med = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_FAR_PAST)==0)
      b_ptr_buf_buf_far_past = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_ODD)==0)
      b_ptr_buf_buf_odd = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_FREED)==0)
      b_ptr_buf_buf_freed = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_CODE)==0)
      b_ptr_buf_buf_code = 1;
   else if (strcmp(data[dataPTR],_b_ptr_bufBUF_LOW)==0)
      b_ptr_buf_buf_low = 1;
  else
    {
      cerr<<"Error: Unknown setting for the "
          <<"BUF_SIZE"
          <<" dial of the data object "
          <<CLASS_STRING
          <<". "<<endl
          <<"The offending string is : "
          <<data[dataPTR]
          <<endl;
      exit(1);
    }

 char *buf_ptr;
 const int buf_SMALL = 1; /* size of small buf */
 const int buf_MED = bm_PAGESIZE; /* size of medium buf */

 

 FILE* logFile = NULL;

 if ((logFile = fopen ("/tmp/templateLog.txt","a+")) == NULL)
 {
 fclose(logFile);
 exit(99);
 }

if (b_ptr_buf_buf_small==1)
{

 save_loc_buf = buf_ptr = (char *) malloc (buf_SMALL);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_SMALL, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 fillbuf(buf_ptr, buf_SMALL);
 _theVariable = buf_ptr;
 
}

if (b_ptr_buf_buf_med==1)
{

 save_loc_buf = buf_ptr = (char *)malloc (buf_MED); /* try to put this on a page boundary */
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_MED, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 fillbuf(buf_ptr, buf_MED);
 _theVariable = buf_ptr;
 
}

if (b_ptr_buf_buf_large==1)
{

 save_loc_buf = buf_ptr = (char *)malloc ((1 << 29) + 1);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_LARGE, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 /* don't fill this one because it takes too long */
 _theVariable = buf_ptr;
 
}

if (b_ptr_buf_buf_xlarge==1)
{

 save_loc_buf = buf_ptr = (char *)malloc ((1 << 30) + 1);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_XLARGE, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 /* don't fill this one because it takes too long */
 _theVariable= buf_ptr;

 
}

if (b_ptr_buf_buf_huge==1)
{

 save_loc_buf = buf_ptr =(char *) malloc (( 1 << 31) + 1);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_HUGE, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 /* don't fill this one because it takes too long */
 _theVariable= buf_ptr;
 
}

if (b_ptr_buf_bufmax==1)
{

 save_loc_buf = buf_ptr =(char *) malloc (ULONG_MAX);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUFMAX, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 /* don't fill this one because it takes too long */
 _theVariable= buf_ptr;
 
}

if (b_ptr_buf_buf_64k==1)
{

 save_loc_buf = buf_ptr = (char *)malloc ((1 << 16) + 1);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_64K, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 fillbuf(buf_ptr, (1 << 16) + 1);
 _theVariable = buf_ptr;
 
}

if (b_ptr_buf_buf_end_med==1)
{

 save_loc_buf = buf_ptr = (char *)malloc (buf_MED);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_END_MED, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 fillbuf(buf_ptr, buf_MED);
 _theVariable = (void *) (((unsigned long) buf_ptr) + buf_MED - 1);
 
}

if (b_ptr_buf_buf_far_past==1)
{
 
 save_loc_buf = buf_ptr = (char *)malloc (buf_MED);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_FAR_PAST, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 fillbuf(buf_ptr, buf_MED);
 _theVariable = (void *) (((unsigned long) buf_ptr) + (bm_PAGESIZE * 1000));
 
}

if (b_ptr_buf_buf_odd==1)
{

 save_loc_buf = buf_ptr = (char *)malloc (buf_MED);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_ODD, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 fillbuf(buf_ptr, buf_MED);
 _theVariable = (void *) (((unsigned long) buf_ptr) + 1);
 
}

if (b_ptr_buf_buf_freed==1)
{

 save_loc_buf = buf_ptr = (char *)malloc (buf_MED);
 if(buf_ptr == NULL)
 {
 fprintf(logFile, "malloc failed in b_ptr_buf - BUF_FREED, function not tested\n");
 fclose(logFile);
 exit(99);
 }
 fillbuf(buf_ptr, buf_MED);
 
}

if (b_ptr_buf_buf_code==1)
{

 _theVariable = (void *) &fib;
 
}

if (b_ptr_buf_buf_low==1)
{

 _theVariable = (void *) 16;
 
}

 fclose(logFile);
   return &_theVariable;
}

//--------------------------------------------------------------------
  int CLASSNAME::commit(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::commit(tname);
  //COMMIT CODE HERE
//generated

if (b_ptr_buf_buf_freed==1)
{

 free (save_loc_buf);
 _theVariable = save_loc_buf;
 
}
   return 0;
}

//--------------------------------------------------------------------
  int CLASSNAME::cleanup(b_param tname)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::cleanup(tname);
      
  //CLEANUP CODE
//generated

 if (save_loc_buf != NULL) 
 {
 free(save_loc_buf);
 }

   return 0;
}

//--------------------------------------------------------------------
int CLASSNAME::numDials(b_param tname)
{
  if (!strcmp(tname,(char *)typeName()))
    return NUMBER_OF_DIALS;
  else return CLASSPARENT::numDials(tname);
      
}


//---------------------------------------------------------------------------
int CLASSNAME::numItems(b_param tname,int dialNumber)
{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::numItems(tname,dialNumber);
  switch (dialNumber)
    {
      //NUMITEMS SWITCH CASES HERE
      //generated

   case 1:
      return 13;
      break;
//---------------------------------------------------------------------------
      //end generated

    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::numItems\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);
    }
  return 0;
}

//---------------------------------------------------------------------------
b_param *CLASSNAME::paramName(b_param tname,
                                   int dialNumber,
                                   int position)

{
  if (strcmp(tname,(char *)typeName())!=0)
    return CLASSPARENT::paramName(tname,dialNumber,position);
  
  switch (dialNumber)
    {
      //PARAMNAME SWITCH CASES HERE
      //generated

case 1:
 switch (position)
   {
      case 1:
         return b_ptr_bufBUF_SMALL();
         break;
      case 2:
         return b_ptr_bufBUF_MED();
         break;
      case 3:
         return b_ptr_bufBUF_LARGE();
         break;
      case 4:
         return b_ptr_bufBUF_XLARGE();
         break;
      case 5:
         return b_ptr_bufBUF_HUGE();
         break;
      case 6:
         return b_ptr_bufBUFMAX();
         break;
      case 7:
         return b_ptr_bufBUF_64K();
         break;
      case 8:
         return b_ptr_bufBUF_END_MED();
         break;
      case 9:
         return b_ptr_bufBUF_FAR_PAST();
         break;
      case 10:
         return b_ptr_bufBUF_ODD();
         break;
      case 11:
         return b_ptr_bufBUF_FREED();
         break;
      case 12:
         return b_ptr_bufBUF_CODE();
         break;
      case 13:
         return b_ptr_bufBUF_LOW();
         break;

      default:
          cerr<<"Error, invalid position number passed to "
              <<CLASS_STRING<<"::paramName\n"
              <<"Please check declaration files.  Dial number passed was"
              <<dialNumber<<" position "<<position<<".\n";
          exit(1);
   }
   break;
    default:
      cerr<<"Error, invalid dial number passed to "
          <<CLASS_STRING<<"::paramName\n"
          <<"Please check declaration files.  Dial number passed was "
          <<dialNumber<<endl;
      exit(1);

    }
  return NULL;
}

//---------------------------------------------------------------------------
