/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#ifndef SNIPES_HEADER

#define SNIPES_HEADER


typedef struct screen_coords
{
  /* Characteristics of the maze as a whole. */
  
  int square_count_x;
  int square_count_y;
  int square_width;
  int square_height;

  long max_x;		/* maze X coordinates range from 0 to max_x */
  long max_y;		/* maze Y coordinates range from 0 to max_y */
  
  /* Characteristics of the screen. */

  long screen_x1;
  long screen_x2;
  long screen_y1;
  long screen_y2;
  
  long screen_max_row;
  long screen_max_col;
  
  long player_pos_x;
  long player_pos_y;
  
  /* What part of the maze is currently on screen. */

  long maze_x1;
  long maze_x2;
  long maze_y1;
  long maze_y2;
} screen_coords;


enum DisplayType {
  DT_SVGALIB,
  DT_CURSES,
  DT_CURSES_DOUBLEWIDE,
  DT_XWIN
};


#endif // SNIPES_HEADER
