/*
 * lslk.h -- common lslk header file
 *
 * V. Abell
 * Purdue University Computing Center
 */


/* $Id: lslk.h,v 1.7 99/11/10 14:55:39 abe Exp $ */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell.
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */
 

#if	!defined(LSLK_H)
#define	LSLK_H	1

#include "machine.h"

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <netdb.h>

#include <sys/stat.h>

#include "dlslk.h"


/*
 * Common symbol definitions
 */

#define ACCESSERRFMT    "%s: WARNING: access %s: %s\n"
#define	LHAAU		10		/* local host address cache
					 * allocation unit */
#define	LFILEAU		10		/* Lfile table allocation unit */
#define	LOCKAU		128		/* Lock table allocation unit */
#define	NWADAU		10		/* Nwad table allocation unit */
#define	PIDAU		10		/* Pid table allocation unit */

#if	!defined(STATORLSTAT)
#define	STATORLSTAT	lstat		/* for dolstat() in safe.c */
#endif	/* !defined(STATORLSTAT) */

#define	TMLIMIT		15		/* readlink() and stat() timeout sec */
#define	TMLIMMIN	2		/* minimum timout */


/*
 * Selection flags
 */

#define	SELFILE	0x01			/* select by file name */
#define SELNWAD	0x02			/* select by network address */
#define	SELPID	0x04			/* select by PID number */
#define	SELALL	SELINUM|SELHOST|SELPATH|SELPID
					/* all select specifiers */


/*
 * Print titles
 */

#define	DEVTTL		"DEV"
#define	ENDTTL		"END"
#define	INODETTL	"INUM"
#define	LENTTL		"LEN"
#define	MANDTTL		"M"
#define	PIDTTL		"PID"
#define	SOURCETTL	"SRC"
#define	STARTTTL	"ST"
#define	SIZETTL		"SZ"
#define	TYPETTL		"TY"
#define	WHENCETTL	"WH"


/*
 * Structure definitions
 */

struct lfile {				/* local file table */
	char *path;			/* file path */
	dev_t dev;			/* device */
	ino_t inum;			/* inode number */
	short f;			/* found flag */
};

struct llock_info {			/* local lock information */
	int sf,				/* selection flags */
	    type;			/* lock type:	0 = unknown
					 *		1 = read
					 *		2 = write
					 *		3 = read + write */
	unsigned long end,		/* lock end */
	   	      len,		/* lock length (subect to ls) */
		      start,		/* lock start */
		      sz,		/* file size (subject to szs) */
		      whence;		/* lock whence (subject to ws) */
	short cs,			/* command free status (0 = don't) */
	      es,			/* end status (0 == none) */
	      ls,			/* length status (0 == none) */
	      mand,			/* mandatory locking status (0 = none)
					 */
	      src,			/* source status: 0 = local
					 *		  1 = remote
					 *		  2 = unknown-remote */
	      ss,			/* start status (0 == none) */
	      szs,			/* size status (0 == none) */
	      ws;			/* whence status (0 == none) */
	dev_t dev;			/* device */
	char *hn,			/* remote system host name */
	     *path;			/* specified file path */
	struct in_addr *iap;		/* Internet address */
	ino_t inum;			/* inode number */
	unsigned long pid;		/* PID of lock holder */
	char *cmd;			/* command name */
};

struct lhaddr {				/* local host address */
	char *hn;			/* host name */
	unsigned long na;		/* address */
};

struct mounts {				/* local mount information */
	dev_t dev;			/* device number */
	char *mntp;			/* mount point */
	char *sp;			/* what's been mounted */
	caddr_t priv;			/* private dialect data */
};

struct nwad {				/* network address selections */
	char *hn;			/* host name from -i option */
	char *chn;			/* canonical host name from
					 * gethostbyname() */
	unsigned long na;		/* hosts's network address */
};


/*
 * Local externals
 */

extern struct lfile *Lfile;
extern struct lhaddr *Lhaddr;
extern struct llock_info *Lock;
extern struct llock_info *Lp;
extern struct mounts *Mnt;
extern gid_t Mygid;
extern uid_t Myuid;
extern int NLfile;
extern int NLockA;
extern int NLockU;

# if	defined(HASKOPT)
extern char *Nmlst;
# endif	/* defined(HASKOPT) */

extern int NMnt;
extern int NNwad;
extern int NPid;
extern struct nwad *Nwad;
extern short Oand;
extern short Oblock;
extern short Oconv;
extern short Ohelp;
extern short Oovhd;
extern short Owarn;
extern short Overs;
extern unsigned long *Pid;
extern char *Pn;
extern int Selopt;
extern short Setgid;
extern short Setuidroot;
extern int TmLimit;


/*
 * System externals
 */

extern int errno;
extern char *optarg;
extern int optind;

#include "proto.h"
#include "dproto.h"

#endif	/* defined(LSLK_H) */
