/*
 * dstore.c - Solaris global storage for lsof
 *
 * V. Abell
 * Purdue University Computing Center
 */


/*
 * Copyright 1996 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1996 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.4 2001/07/11 11:22:23 abe Exp $";
#endif


#include "lslk.h"


/*
 * Local global variables
 */

union ihead *Ihdp;			/* inode hash table head */
int Ihsz;				/* inode hash table size */
kvm_t *Kd = NULL;			/* the kvm descriptor */

struct nlist Nl[] = {			/* kernel name list entries */
	{ "ihead"	},		/* inode hash table pointer */
#define	X_IHEAD		0
	{ "inohsz"	},		/* inode hash table size */
#define	X_INOHSZ	1

# if	solaris>=20500
	{ "lm_sysids"   },		/* lock manager's sysid info */
#define X_SYSIDS        2
	{ "_kernelbase"	},
#define	X_KERNELBASE	3
#  if	solaris>=20501
	{ "kas"		},
#define	X_KAS		4
#  endif	/* solaris>=20501 */
# endif	/* solaris>=20500 */

	{ "" 		}
};

# if	solaris>=20500
int Nsid = 0;				/* the size of Sids[] */
struct SysIDs *Sids = NULL;		/* the local sysid table */
# endif	/* solaris>=20500 */
