//
//  Little cms Profiler
//  Copyright (C) 1998-2001 Marti Maria 
// Copyright (C) 2005 Hal Engel
//
// THIS SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
// EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
// WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
//
// IN NO EVENT SHALL MARTI MARIA BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
// INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
// OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
// WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
// LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
// OF THIS SOFTWARE.
//
// This file is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, if you
// distribute this file as part of a program that contains a
// configuration script generated by Autoconf, you may include it under
// the same distribution terms that you use for the rest of that program.
//
// Version 1.11

// #include <qdir.h>
#include <qtextbrowser.h>
#include <profileid.h>
#include <profileparms.h>
#include <monitorvalues.h>
#include <profilechecker.h>
#include <qtlcmswidgets.h>
#include <lcmsprf.h>
#include "lprofmain.h"
#include <string.h>
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <stdlib.h>
#include <qlist.h>
#include "installreffile.h"
#include <qassistantclient.h>

#ifdef USE_KDE
#include <kfiledialog.h>
#endif

static QPointArray grid_corners;
static QPtrList<target_template> *targetList=0;
QDir dir;
BOOL corners_ready;
static monVal monitorValues;
static PROFILERDATA sys;

// Console and Gauger

static QMultiLineEdit*    Console;
static QProgressBar*      ProgBar;

char ConfigFile[256];
char measfile[256];
char templates[256];
char mon_profile[256];
char in_profile[256];
char ref_dir[256];
char WorkTempFileName[256];
char outprofile[256];

const int measure_view_H=1500;
const int measure_view_V=1000;

struct mark_pos
{ 
    int  ur_x, ur_y;
    int ul_x, ul_y;
    int lr_x, lr_y;
    int ll_x, ll_y;
  }  Marks; 

QString get_QTDIR()
{
    // qDebug("get_home_dir");
    const char* qtdir= "QTDIR";
    return (QString) getenv(qtdir);
}

#if !defined(__WIN32__) && (defined(_WIN32) || defined(WIN32))
#define __WIN32__
#endif

 # ifdef __WIN32__
         
 # else
    static int min (int a, int b) 
    {
        if (a < b) return a;
        return b;
    }
# endif /* __WIN32__ */

void add_target(target_template &in)
{
    BOOL found;
    target_template* item;
    
    found = FALSE;
    // look to see if this target is already installed.
    // if it is update the template file
    if (!targetList->isEmpty())  // taragetList has items so check it to see if this is a dupelicate 
    {
        for (int i = 0;  i < targetList->count();  i++)
          if (targetList->at(i)->targetFile == in.targetFile)
              { 
                   targetList->at(i)->templateFile = in.templateFile;
                   found=TRUE;
                   break;
              }
    }
    if (!found) // not a dupicate target file so create new entry
    {
        item = new target_template;
        item->targetFile = in.targetFile;
        item->templateFile = in.templateFile;    
        // place new target ref file in list of target ref files
        targetList->insert(targetList->count(), item);
    }
}


void init_env()
{    
    const char* ConfigFileconst="/.lprof/config/lprof.cfg";
    const char* measfileconst="/.lprof/temp/meaurement.cgt";
    const char* WorkTempFileNameconst = "/.lprof/temp/$$q60$$.$$$";
    const char* templateconst = "/.lprof/templates";
    QDir d;
    # ifdef __WIN32__
          
          QString win;
          BOOL win_found = FALSE;
          for (  char drive = 'c'; drive <= 'z'; drive++)
	  {
	      win =  drive + (QString)  ":\WINDOWS\system32\spool\drivers\color";
	      if ( d.exists( win)) break;
	  }
          const char* mon_profileconst=(const char*) win;
          const char* in_profileconst=(const char*) win;;
          const char* outprofileconst=(const char*) win;;
    # else
        const char* mon_profileconst="/usr/share/color/icc";
        const char* in_profileconst="/usr/share/color/icc";
        const char* outprofileconst="/.color/icc";
    # endif /* __WIN32__ */
    const char* ref_dirconst="/.lprof/target_refs";

    char home[128];
    char temp[128];
 
    // qDebug("init_env"); 

    strcpy(home, d.convertSeparators(d.homeDirPath().local8Bit()));
    // home=getenv("HOME");
    // qDebug(home);
    
    strcpy(temp, home);
    strcat(temp, ConfigFileconst);
    strcpy(ConfigFile, d.convertSeparators((QString) temp));
    // qDebug(ConfigFile);
    
    strcpy(temp,home);
    strcat(temp, measfileconst); 
    strcpy(measfile, d.convertSeparators((QString) temp));
    
    
    strcpy(temp, home);
    strcat(temp, templateconst);
    strcpy(templates, d.convertSeparators((QString) temp));
    
    strcpy(mon_profile, mon_profileconst);
    
    strcpy(in_profile, in_profileconst);
    
    strcpy(WorkTempFileName, home);
    strcat(WorkTempFileName, WorkTempFileNameconst);
    
    strcpy(temp,home);
    strcat(temp,ref_dirconst);
    strcpy(ref_dir, d.convertSeparators((QString) temp));

    strcpy(temp,home);
    strcat(temp, WorkTempFileNameconst);
    strcpy(sys.hdr.temp_file, d.convertSeparators((QString) temp));
    
    # ifdef __WIN32__
        strcpy(temp, outprofileconst);
    # else
        strcpy(temp, home);
        strcat(temp, outprofileconst);
        strcpy(outprofile, d.convertSeparators((QString) temp));
    # endif /* __WIN32__ */
    
}
    

static int ConsolePrintf(const char *frm, ...)
{
    char Buffer[1024];
    va_list args;
    
    // qDebug("ConsolePrintf");
    va_start(args, frm); 
    vsprintf(Buffer, frm, args);
    Console -> append(Buffer);      
    va_end(args);  
    return 1;
}

static int Gauger(const char *Label, int nMin, int nMax, int Pos)
{
    
    // qDebug("Gauger");
    if (nMin < 0 && nMax < 0)       
    {         
        return 1; 
    }
    
    ProgBar -> setTotalSteps(nMax);
    ProgBar -> setProgress(Pos);
    return 1;
}

void lprofMain::init_mon()
{
    // qDebug("init_mon");
    monitorValues.items.wppos=0;
    monitorValues.items.ppos=0;
    monitorValues.items.temp=6500;
    monitorValues.items.linked=1;
    monitorValues.items.rchecked=TRUE;
    monitorValues.items.gchecked=FALSE;
    monitorValues.items.bchecked=FALSE;
    monitorValues.items.rgamma="2.4";
    monitorValues.items.ggamma="2.4";
    monitorValues.items.bgamma="2.4";
    connect(MonMeasurementSheet, SIGNAL(valueChanged()), this, SLOT(slotChangeStrategy()));
    
}

static void init_marks()
{
    Marks.ur_x=measure_view_H; 
    Marks.ur_y=0;
    
    Marks.ul_x=0; 
    Marks.ul_y=0;
    
    Marks.lr_x=measure_view_H; 
    Marks.lr_y=measure_view_V;
    
    Marks.ll_x=0; 
    Marks.ll_y=measure_view_H;
    
    corners_ready=FALSE;
    
}

// Measurement tool stuff
// GridLayout, represents one patch

void lprofMain::Reload()
{
     qDebug("lprof::Reload");
    TheImage -> Reload(fn, MonitorProfileSelector ->getFilename(),
                                 InputProfileSelector->getFilename(),  
                                 Canvas);
}

int GridLayout::Scale(int n, int amax)   
{ 
    // qDebug("Gridlatout::Scale");
    return (int) (((double) (n*amax)/LAYOUT_MAX)+.5); 
}

void GridLayout::ScaleTo(int w, int h, QRect& Scaled)
{
    
    QPoint A, B, C, D;
    int length_w, length_h, offset_x, offset_y, offset_x2, offset_y2, dDA, dBA, dCD, dCB, adj_x, adj_y; 
    
    A=grid_corners.point(0);
    B=grid_corners.point(1);
    C=grid_corners.point(2);
    D=grid_corners.point(3);
    
    adj_x=min(A.x(),D.x());
    A.setX(A.x()-adj_x);
    B.setX(B.x()-adj_x);
    C.setX(C.x()-adj_x);
    D.setX(D.x()-adj_x);
    adj_y=min(A.y(),B.y());
    A.setY(A.y()-adj_y);
    B.setY(B.y()-adj_y);
    C.setY(C.y()-adj_y);
    D.setY(D.y()-adj_y);
    
    dDA=A.x()-D.x();
    dBA=A.y()-B.y();
    dCD=C.y()-D.y();
    dCB=B.x()-C.x();
    
    if (dDA>0) 
        offset_x= abs(dDA-((int) (dDA  * ((double) rect.y()/ LAYOUT_MAX)+.5)));
    else
        offset_x= -abs(dDA-((int) (dDA  * ((double) rect.y()/ LAYOUT_MAX)+.5)));
    
    if (dCB>0) 
        offset_x2= -abs(dCB-((int) (dCB * ((double) rect.y()/ LAYOUT_MAX)+.5)));
    else
        offset_x2= abs(dCB-((int) (dCB * ((double) rect.y()/ LAYOUT_MAX)+.5)));
    
    if (dBA>0)
        offset_y=abs(dBA-((int) (dBA * ((double) rect.x()/ LAYOUT_MAX)+.5)));
    else 
        offset_y=-abs(dBA-((int) (dBA * ((double) rect.x()/ LAYOUT_MAX)+.5)));
    
    if (dCD<0)
         offset_y2=-abs(dCD-((int) (dCD * ((double) rect.x()/ LAYOUT_MAX)+.5)));
    else
        offset_y2=abs(dCD-((int) (dCD * ((double) rect.x()/ LAYOUT_MAX)+.5)));
    
    length_w = w - (offset_x + offset_x2);
    length_h = h - (offset_y + offset_y2);
    
    // qDebug("Gridlayout::ScaleTo");
     Scaled.setRect(Scale(rect.x(), length_w ) + offset_x,
                   Scale(rect.y(), length_h) + offset_y,
                   Scale(rect.width(), length_w),
                   Scale(rect.height(), length_h));
}

// A ICC profile transform on whole image


void ImageItem::TransformImage(const QString OutputProfile, 
                               const QString InputProfile, 
                               QImage& p)
{
    
    // qDebug("ImageItem::TransformImage");
    cmsHTRANSFORM xform;
    cmsHPROFILE hIn, hOut;

    hIn  = cmsOpenProfileFromFile(InputProfile.local8Bit(), "r");
    hOut = cmsOpenProfileFromFile(OutputProfile.local8Bit(), "r");

    xform = cmsCreateTransform(hIn, TYPE_RGBA_8, hOut, TYPE_RGBA_8, 
                        INTENT_PERCEPTUAL, cmsFLAGS_WHITEBLACKCOMPENSATION);

    for (int i=0; i < p.height(); i++) {
        LPBYTE ptr = p.scanLine(i);
        cmsDoTransform(xform, ptr, ptr, p.width());
    }

    cmsDeleteTransform(xform);
    cmsCloseProfile(hIn);
    cmsCloseProfile(hOut);
}



ImageItem::ImageItem(QString ImageFile, const QString Monitor, const QString Scanner, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image()
{

    // qDebug("ImageItem::ImageItem");
    // lProof = FALSE;
    Reload(ImageFile, Monitor, Scanner, canvas);
}


void ImageItem::Reload(QString ImageFile, const QString Monitor, const QString Scanner, QCanvas *canvas )
{
    // qDebug("ImageItem::Reload");
    if (ImageFile == QString::null) return;

    if (!image.load(ImageFile)) {
        QMessageBox mb( "Load image failure",
                        "This image format is unsupported by Qt\n"
                        "in your system. Sorry. Supported ones \n"
                        "are PNG, BMP, XBM, XPM, TIF and PNM.",
                        QMessageBox::Critical,
                        QMessageBox::Ok | QMessageBox::Default,
                        QMessageBox::NoButton,  QMessageBox::NoButton);

    mb.exec();  
    return;
    }
    // try again   
    QImage scaled = image.smoothScale(canvas->width(), canvas->height());

    setSize( scaled.width(), scaled.height() );
    
    sx = (double) image.width() / scaled.width();
    sy = (double) image.height() / scaled.height();

    pixmap.convertFromImage(scaled); 

    if (lProof) {
        if (Monitor != QString::null && Scanner != QString::null)  
            TransformImage(Monitor, Scanner, scaled);
    }
	
    proof.convertFromImage(scaled);

    move(0, 0);
    setZ(5);
    show();
}


void ImageItem::drawShape( QPainter &p )
{
    // qDebug("ImageItem::drawShape");
    p.drawPixmap( int(x()), int(y()), lProof? proof : pixmap );
}



// ---------------------------------------------------------------- The grid item

GridItem::GridItem( QCanvas *canvas, QString Template, int SafeFrame )
    : QCanvasRectangle( 10, 10, canvas->width() - 10, canvas->height() - 10, canvas)
{
    // qDebug("GridItem::GridItem");
    UnShearFactor = 0.0;
    SafeFrameFactor = SafeFrame / 100.;
    setBrush( NoBrush) ; 

    Layout.setAutoDelete(TRUE);
    LCMSHANDLE hIT8 = cmsxIT8LoadFromFile(Template.local8Bit());
    
    if (hIT8) {

        int nRects = (int) cmsxIT8GetPropertyDbl(hIT8, "NUMBER_OF_SETS");
        char PatchName[256];

        for (int i=0; i < nRects; i++) {

            if (cmsxIT8GetDataSetByPos(hIT8, 0, i, PatchName, 256)) {

                GridLayout* Patch = new GridLayout;

                double x, y, xSize, ySize;
                
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "POS_X", &x);
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "POS_Y", &y);
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "SIZE_X", &xSize);
                cmsxIT8GetDataSetDbl(hIT8, PatchName, "SIZE_Y", &ySize);

                strcpy(Patch -> p.Name, (const char *) PatchName);
                Patch -> rect.setRect(int(x), int(y), int(xSize), int (ySize));

                Layout.append(Patch);

            }
        }

        cmsxIT8Free(hIT8);
    }

    setZ(10);
    show();
}



static
void DoDeflateRect(QRect& rect, int sx, int sy)
{
    // qDebug("DoDeflateRect");
    rect.setRect(rect.x() + sx, rect.y() + sy, 
                  rect.width()-sx*2, rect.height()-sx*2);
}


void GridItem::ComputePatchRects(QRect& OurViewport, GridLayout* Patch, 
                                 QRect& Frame, QRect& HotZone)
{
        QRect Scaled;

        // qDebug("GridItem::ComputePatchRects");
        Patch ->ScaleTo(OurViewport.width(), OurViewport.height(), Scaled);

        int translateX = OurViewport.x();
        int translateY = OurViewport.y();

       /* int UnShearX = (int) ((double) Scaled.x() * UnShearFactor / 16.);
        int UnShearY = (int) ((double) Scaled.y() * UnShearFactor / 16.);

        translateX += UnShearY;
        translateY += UnShearX; */
        
        Scaled.moveBy(translateX, translateY);

        Frame = Scaled;
        
        int SafeFrame = (int) ((double) Scaled.width() * SafeFrameFactor / 2.);
                
        DoDeflateRect(Scaled, SafeFrame, SafeFrame);

        HotZone = Scaled;
}


// Compute our viewport extension

void GridItem::ComputeViewport(QRect& OurViewport, double sx, double sy)
{

    int x;
    int y;
    int w;
    int h;
    
    x=(int) (min(Marks.ll_x, Marks.ur_x) * sx);
    y=(int) (min( Marks.ur_y, Marks.ul_y) * sy);
    w=(int) (max(Marks.ur_x, Marks.lr_x) * sx - x);
    h=(int) (max(Marks.lr_y, Marks.ll_y) * sy - y);
    OurViewport.setRect(x, y, w, h);
}


// Uh-oh.... viewPort() was buggy and slow when I wrote this,
// so, I do by hand... 
void GridItem::drawShape( QPainter &p )
{   
    GridLayout* Patch;
    QRect OurViewport;

    // qDebug("GridItem::drawShape");
    
    ComputeViewport(OurViewport, 1.0, 1.0);
    
    if (corners_ready) {
        for (Patch = Layout.first(); 
            Patch;
            Patch = Layout.next()) {
                
                QRect Frame, HotZone;

                // Scale to our viewport
                ComputePatchRects(OurViewport, Patch, Frame, HotZone);
            
                // Draw
                // p.setPen( Qt::white );    
                // p.drawRect(Frame);

                p.setPen( Qt::green );    
                p.drawRect(HotZone);
                
            }  // end for
        } // enf if
    
    // Do this allways to mark corners but only mark corners after the user 
    // clicks to add a mark
    
    p.setPen( Qt::red );   
    
    // upper right corner only draw the corner mark of the user has clicked 
    if (Marks.ur_x<measure_view_H && Marks.ur_y>0) {
        p.drawLine(Marks.ur_x, Marks.ur_y, Marks.ur_x - 50, Marks.ur_y);
        p.drawLine(Marks.ur_x, Marks.ur_y, Marks.ur_x, Marks.ur_y + 50);
    }
    
    // upper left corner
    if (Marks.ul_x>0 && Marks.ul_y>0) {
        p.drawLine(Marks.ul_x, Marks.ul_y, Marks.ul_x + 50, Marks.ul_y);
        p.drawLine(Marks.ul_x, Marks.ul_y, Marks.ul_x, Marks.ul_y + 50);
    }
    
    // lower right corner
    if (Marks.lr_x>0 && Marks.lr_y<measure_view_V) {
        p.drawLine(Marks.lr_x, Marks.lr_y, Marks.lr_x - 50, Marks.lr_y);
        p.drawLine(Marks.lr_x, Marks.lr_y, Marks.lr_x, Marks.lr_y - 50);
    }
            
    // lower left corner
    if (Marks.ll_x<measure_view_H && Marks.ll_y<measure_view_V) {        
        p.drawLine(Marks.ll_x, Marks.ll_y, Marks.ll_x + 50, Marks.ll_y);
        p.drawLine(Marks.ll_x, Marks.ll_y, Marks.ll_x, Marks.ll_y - 50);
    }
}


void GridItem::Pick(QString InputProfileName, QImage& Image, double sx, double sy)
{   
    GridLayout* Patch;
    QRect OurViewport;
     // qDebug("GridItem::Pick");
    cmsHTRANSFORM hInputXFORM;
    cmsHPROFILE hLab = NULL, hInputProfile = NULL;
    
    // Will not compile with QT_NO_ASCII_CAST turned on
    // when changed to 
    // const char* cInputProfile = InputProfileName.local8Bit();
    // Will get runtime errors for bad file name
    // Needs to be fixed
    const char* cInputProfile = InputProfileName;
    
    if (cInputProfile) {

        hLab          = cmsCreateLabProfile(NULL);
        hInputProfile = cmsOpenProfileFromFile(cInputProfile, "r");
        hInputXFORM   = cmsCreateTransform(hInputProfile, TYPE_RGB_16, 
                                        hLab, TYPE_Lab_16, INTENT_ABSOLUTE_COLORIMETRIC, 
                                        cmsFLAGS_NOTPRECALC);
    }
    else hInputXFORM = NULL;


    ComputeViewport(OurViewport, sx, sy);
    
    for (Patch = Layout.first(); 
            Patch;
            Patch = Layout.next()) {
                
                // Scale to our viewport

                QRect Frame, HotZone;
                
                ComputePatchRects(OurViewport, Patch, Frame, HotZone);

                // Ok, take

                Statistic r, g, b;
                
                int xstart = HotZone.x();
                int ystart = HotZone.y();
                int xsize  = HotZone.width();
                int ysize  = HotZone.height();

                Patch ->p.Colorant.RGB[0] = 0;
                Patch ->p.Colorant.RGB[1] = 0;
                Patch ->p.Colorant.RGB[2] = 0;
                Patch ->p.dwFlags         = 0;
                

                if ((xstart < 0) || (ystart < 0) || 
                    ((xstart + xsize) > Image.width()) ||
                    ((ystart + ysize > Image.height()))) 
                                continue;

                for (int i=0; i < ysize; i++)
                    for (int j=0; j < xsize; j++) {

                        QRgb rgb = Image.pixel(xstart+j, ystart+i);

                        int rv =  qRed(rgb);
                        int gv =  qGreen(rgb);
                        int bv =  qBlue(rgb);

                        r.Add(rv); g.Add(gv); b.Add(bv);
                        
                    }

                Patch ->p.dwFlags = PATCH_HAS_RGB|PATCH_HAS_CHISQ;

                Patch ->p.Colorant.RGB[0] = r.Mean();
                Patch ->p.Colorant.RGB[1] = g.Mean();
                Patch ->p.Colorant.RGB[2] = b.Mean();

                
                Patch->p.ChiSq = (r.Std() + g.Std() + b.Std()) / 3.0;


                if (hInputXFORM) {

                    WORD RGB[3];
                    WORD LabEncoded[3];
                
                    RGB[0] =(WORD) floor(Patch -> p.Colorant.RGB[0] * 257. + .5);
                    RGB[1] =(WORD) floor(Patch -> p.Colorant.RGB[1] * 257. + .5);
                    RGB[2] =(WORD) floor(Patch -> p.Colorant.RGB[2] * 257. + .5);

                    cmsDoTransform(hInputXFORM, RGB, LabEncoded, 1);
                    cmsLabEncoded2Float(&Patch ->p.Lab, LabEncoded);
                    cmsLab2XYZ(NULL, &Patch ->p.XYZ, &Patch ->p.Lab);
                }
    }
        
    if (hInputXFORM) {

        cmsDeleteTransform(hInputXFORM);
        cmsCloseProfile(hInputProfile);
        cmsCloseProfile(hLab);
    }

}


// ------------------------------------------------------------ The figure editor

void FigureEditor::resizeEvent( QResizeEvent* e )
{
     // qDebug("FigureEditor::resizeEvent");
  QCanvasView::resizeEvent( e );
  maindialog.FigEditor-> resize(width(), height());
  
}

void FigureEditor::contentsMousePressEvent(QMouseEvent* e)
{
    
     // qDebug("FigureEditor::contentsMousePressEvent");
    if (e->x()<measure_view_H/2 && e->y()<measure_view_V/2) {
         // upper left quadrant 
         Marks.ul_x=e->x();
         Marks.ul_y=e->y();
          }
    else
        if (e->x()>measure_view_H/2 && e->y()<measure_view_V/2) {
           // upper right quadrant 
            Marks.ur_x=e->x();
            Marks.ur_y=e->y();
        }
    else
        if (e->x()>measure_view_H/2 && e->y()>measure_view_V/2) {
            // lower right quadrant
            Marks.lr_x=e->x();
            Marks.lr_y=e->y();
        }
    else
        if (e->x()<measure_view_H/2 && e->y()>measure_view_V/2) {
            // lower left quadrant
            Marks.ll_x=e->x();
            Marks.ll_y=e->y();
        }
     
    
    // place corner markers to give user feed back that the corner has been marked
    
    grid_corners.putPoints(0, 4, Marks.ul_x,  Marks.ul_y, 
                                                                         Marks.ur_x, Marks.ur_y, 
                                                                         Marks.lr_x, Marks.lr_y, 
                                                                         Marks.ll_x, Marks.ll_y);
    maindialog.AddTemplate();
    
    // check to see if all corners are marked and it is time to place full template and pick
    
    if (Marks.ul_x>0 && Marks.ur_x<measure_view_H && Marks.ll_x>0 && Marks.lr_x<measure_view_H) {
        
        corners_ready=TRUE;
        maindialog.slotPick();
    }  

}

/* void FigureEditor::contentsMouseMoveEvent(QMouseEvent* e)
{
    // qDebug("FigureEditor::contentsMouseMoveEvent");
    if ( moving ) {

        moving->moveBy(e->pos().x() - moving_start.x(),
                       e->pos().y() - moving_start.y());

        moving_start = e->pos();
        canvas()->update();
    }
    else
    if ( sizing) {
            
            int p1x = (int) sizing -> x();
            int p1y = (int) sizing -> y();
            int p2x = e -> pos().x();
            int p2y = e -> pos().y();
            int sx = QABS(p2x - p1x);
            int sy = QABS(p2y - p1y);
            
            sizing -> setSize(sx, sy);
            canvas()->update();
        }
    else {

        if (unshearing) {

            double  shear = e -> pos().x() - moving_start.x();
            if (shear > 128.) shear = 128;
            if (shear < 0.) shear = 0.;          

            unshearing -> UnShearFactor = shear / 128.;         
            canvas()-> setAllChanged();
            canvas()->update();         
        }
    }
} */


void FigureEditor::clear()
{
    // qDebug("FigureEditor::clear");
    QCanvasItemList list = canvas()->allItems();
    QCanvasItemList::Iterator it = list.begin();
    for (; it != list.end(); ++it) {
        if ( *it )
            delete *it;
    }

    moving = NULL;
    sizing = NULL;
    unshearing = NULL;
}

void lprofMain::AddTemplate()
{    
    // qDebug("lprofMain::AddTemplate");
     QString Template     = SelectTemplate -> getFilename();
     double  SafeFrameVal = SafeFrame->value();
    if ((TheImage != NULL) && (Template != QString::null)) {
        
        if (TheGrid != NULL)
            delete TheGrid;

       TheGrid = new GridItem(Canvas, Template, (int) SafeFrameVal);
       CurrentTemplate  = Template;
       CurrentSafeFrame = SafeFrameVal;
    }
}              


void lprofMain::slotLoad()
{
    // qDebug("lprofMain::slotLoad");
#ifdef USE_KDE
  QString const caption("Select target image");
  QString const filter("*.gif *.png *.jpg *.bmp *.pnm *.tif |Image files\n*.*|All files");
  QString fn=KFileDialog::getOpenFileName( dir.homeDirPath(), 
                       filter,
                       this,
                       caption);

#else
    fn = QFileDialog::getOpenFileName( dir.homeDirPath(), 
                                                "Image files (*.gif *.png *.jpg *.bmp *.pnm *.tif)\nAll files (*.*)",
                                                this,
                                                "",
                                                "Select target image");
#endif
    if (fn == QString::null) return;

    FigEditor->clear();
    TheGrid = NULL;
    CurrentTemplate = "";
                // fix me ?? what does ProofTogle do ???
    // if (ProofToggle -> isOn()) ProofToggle -> toggle();

    TheImage = new ImageItem(fn, MonitorProfileSelector ->getFilename(),
                                InputProfileSelector->getFilename(),  
                                Canvas);
    init_marks();
    
}

void lprofMain::slotProof()
{
    if (TheImage) {
            TheImage -> lProof = ProofToggle -> isOn();

		TheImage -> Reload(fn, MonitorProfileSelector ->getFilename(),
                                 InputProfileSelector->getFilename(),  
                                 Canvas);

            Canvas->setChanged(rect());
            Canvas->update();
            ControlsToValues();
    }

}

/* void lprofMain::SaveIT8(const char *filename)
{    
    // fix me raw edit no longer supported
    
    QString text = IT8Edit->text();
    QFile f( filename );
    if ( !f.open( IO_WriteOnly ) ) {
    return;
    }

    QTextStream t( &f );
    t << text;
    f.close();

    IT8Edit->setEdited( FALSE );  
} */




void lprofMain::DumpResultsToIT8(QList<GridLayout>& Layout)
{
      // qDebug("lprofMain::DumpResultsToIT8");  
    LCMSHANDLE it8 = cmsxIT8Alloc();
    
    cmsxIT8SetSheetType(it8, "LCMS/MEASUREMENT");
    cmsxIT8SetProperty(it8, "ORIGINATOR",   (const char *) "LPROF");
    cmsxIT8SetProperty(it8, "DESCRIPTOR",   (const char *) "hidden measurement sheet");
    cmsxIT8SetProperty(it8, "MANUFACTURER", (const char *) "LPROF");
    cmsxIT8SetProperty(it8, "CREATED",      (const char *) "");
    cmsxIT8SetProperty(it8, "SERIAL",       (const char *) "");
    cmsxIT8SetProperty(it8, "MATERIAL",     (const char *) "");

    cmsxIT8SetProperty(it8, "CHISQ_DOF",    "3");

    GridLayout* Patch;
    int nSets = 0;
    int nFields = 5;

    for (Patch = Layout.first(); 
            Patch;
            Patch = Layout.next()) {
                    if (Patch -> p.dwFlags != 0) 
                        nSets++;
            }

    cmsxIT8SetPropertyDbl(it8, "NUMBER_OF_SETS", nSets);

    if (RadioButtonLabXYZ -> isChecked()) nFields += 3;

    cmsxIT8SetPropertyDbl(it8, "NUMBER_OF_FIELDS", nFields);

    nFields = 0;
    cmsxIT8SetDataFormat(it8, nFields++, "SAMPLE_ID");

   if (RadioButtonRGB -> isChecked()) {

    cmsxIT8SetDataFormat(it8, nFields++, "RGB_R");
    cmsxIT8SetDataFormat(it8, nFields++, "RGB_G");
    cmsxIT8SetDataFormat(it8, nFields++, "RGB_B");
     }

   if (RadioButtonLab -> isChecked() ||
        RadioButtonLabXYZ -> isChecked()) {

    cmsxIT8SetDataFormat(it8, nFields++, "LAB_L");
    cmsxIT8SetDataFormat(it8, nFields++, "LAB_A");
    cmsxIT8SetDataFormat(it8, nFields++, "LAB_B");
    }

    if (RadioButtonXYZ -> isChecked() ||
        RadioButtonLabXYZ -> isChecked()) {

    cmsxIT8SetDataFormat(it8, nFields++, "XYZ_X");
    cmsxIT8SetDataFormat(it8, nFields++, "XYZ_Y");
    cmsxIT8SetDataFormat(it8, nFields++, "XYZ_Z");
    }

    cmsxIT8SetDataFormat(it8, nFields++, "CHI_SQD_PAR");
   
    for (Patch = Layout.first(); 
            Patch;
            Patch = Layout.next()) {

                if (Patch -> p.dwFlags != 0) {

                cmsxIT8SetDataSet(it8, Patch->p.Name, "SAMPLE_ID", Patch->p.Name);
               
               if (RadioButtonRGB -> isChecked()) {

                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "RGB_R", Patch ->p.Colorant.RGB[0]);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "RGB_G", Patch ->p.Colorant.RGB[1]);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "RGB_B", Patch ->p.Colorant.RGB[2]);
               }
            
               if (RadioButtonLab -> isChecked() || RadioButtonLabXYZ -> isChecked()) {

                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "LAB_L", Patch ->p.Lab.L);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "LAB_A", Patch ->p.Lab.a);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "LAB_B", Patch ->p.Lab.b);
                }
            
               if (RadioButtonXYZ -> isChecked() || RadioButtonLabXYZ -> isChecked()) {

                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "XYZ_X", Patch ->p.XYZ.X * 100.);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "XYZ_Y", Patch ->p.XYZ.Y * 100.);
                    cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "XYZ_Z", Patch ->p.XYZ.Z * 100.);
                }


                cmsxIT8SetDataSetDbl(it8, Patch->p.Name, "CHI_SQD_PAR", Patch ->p.ChiSq);

                }
            }
            
    cmsxIT8SaveToFile(it8, measfile);
    cmsxIT8Free(it8);  
}



// ------------------------------------------------------------------------------ Slots

void lprofMain::slotPick()
{
    // qDebug("lprofMain::slotPick"); 
    if (TheImage && TheGrid) {
        TheGrid -> Pick(InputProfileSelector->getFilename(), 
                        TheImage -> image, 
                        TheImage -> sx, TheImage -> sy);
        DumpResultsToIT8(TheGrid -> Layout);
        slotIsAllReady();          
    }
}


// end measurement tool stuff


void lprofMain::SetGoButton(const char* Caption, BOOL lEnable)
{
    // qDebug("lprofMain::SetGoButton"); 
    QToolTip::remove( TheGoButton );
    QToolTip::add( TheGoButton, Caption );
	
    TheGoButton -> setEnabled(TRUE);	    
    TheGoButton -> setEnabled(lEnable);
    TheGoButton -> repaint();
}

void lprofMain::SetGoButton_2(const char* Caption, BOOL lEnable)
{
    // qDebug("lprofMain::SetGoButton"); 
    QToolTip::remove( TheGoButton_2 );
    QToolTip::add( TheGoButton_2, Caption );
	
    TheGoButton_2 -> setEnabled(TRUE);	    
    TheGoButton_2 -> setEnabled(lEnable);
    TheGoButton_2 -> repaint();
}
 
 void lprofMain::SetOutputFile( const QString OutputFile )
{
     // qDebug("lprofMain::SetOutputFile"); 
    OutputFileEdit -> setText(OutputFile);
    OutputFileEdit_2 -> setText(OutputFile);
}

 void ref_file::get( ref_file &out)
 {
     QDir d;
     QString temp;
     out.items.temp_dir=sys.hdr.template_dir;
     out.items.ref_dir=sys.hdr.ref_dir;
     out.items.home_dir=d.convertSeparators(d.homeDirPath());
 }
 
 void checkerP::get(checkerP &out)
 {
     // qDebug("checkP::get"); 
     // qDebug(sys.hdr.ReferenceSheet);

     out.items.ref_dir=(QString) sys.hdr.ref_dir;
     out.items.cur_ref=sys.hdr.cur_ref;
     out.items.profile=(QString) sys.hdr.OutputProfileFile;
     out.items.msheet=(QString) sys.hdr.MeasurementSheet;   
     out.items.mon_profile_dir=(QString) sys.hdr.mon_profile_dir;
     out.items.mon_profile_file_name=(QString) sys.hdr.mon_profile_file_name;
 }
 
 void lprofMain::init_measurement_tool()
{
    // qDebug("lprofMain::init_measurement_tool"); 
    TheImage        = NULL;
    TheGrid         = NULL;
    CurrentTemplate = "*";
    CurrentSafeFrame = -1;
    
    int w = CanvasFrame -> width();
    int h = CanvasFrame -> height();
    CanvasFrameLayout =new QVBoxLayout( CanvasFrame ); 
    CanvasFrameLayout->setSpacing( 1 );
    CanvasFrameLayout->setMargin( 1 );
    Canvas = new QCanvas(measure_view_H, measure_view_V);
    Canvas -> setAdvancePeriod(30);
    FigEditor = new FigureEditor(*this, *Canvas, CanvasFrame);
    FigEditor -> clear();
    FigEditor-> resize(w, h);
    FigEditor->setHScrollBarMode(QScrollView::Auto);
    FigEditor->setVScrollBarMode(QScrollView::Auto);

    CanvasFrameLayout->addWidget(FigEditor);  
    
}
 

// Main app contructor. 

lprofMain::lprofMain( QWidget* parent)
    : lprofMainBase( parent )
{
    // qDebug("lprofMain::lprofMain");
    targetList = new QPtrList<target_template>;
    
    Console    = ProgressConsole;
    // ProgBar    = ProgressBar;
    // ProgBar_2    = ProgressBar_2;
    
    // Init the lcmsx engine, this always does success
    // qDebug("init sys");
    cmsxScannerProfilerInit(&sys); 
    init_env();
    monitorValues.items.valid_mon=FALSE;
    
    sys.hdr.cmsprintf = ConsolePrintf;
    sys.hdr.Gauger = Gauger;
    
    init_mon();
    
    LoadConfig();
    init_targetlist();
    init_measurement_tool();
    
    // Hide Printer_Tab until printer profiling is available
    TabProfiler->removePage(Printer_Tab);
    // Hidden tab is used for items that are no longer visible to users
    TabProfiler->removePage(Hidden);
   
    setProfileIDText();
    setProfileParmsText();
    slotIsAllReady();
}

lprofMain::~lprofMain(void)
{
    // qDebug("lprofMain::~lprofMain");
    SaveConfig(); 
}


void lprofMain::ControlsToValues()
{
    // qDebug("lprofMain::ControlsToValues");
    QString cTarget = TargetSelector -> getFilename();

    if (cTarget != QString::null)
            strcpy(sys.hdr.ReferenceSheet, cTarget.local8Bit());
    
    strcpy(sys.hdr.MeasurementSheet,  measfile);

    strcpy(sys.hdr.OutputProfileFile, (const char*) OutputFileEdit -> text().local8Bit());
    strcpy(sys.hdr.ref_dir, (const char*)TargetSelector->Dir.local8Bit());
    sys.hdr.cur_ref=TargetSelector->getCurrItem(); 
    strcpy(sys.hdr.template_dir,SelectTemplate->Dir.local8Bit());
    strcpy(sys.hdr.mon_profile_dir, (const char*) MonitorProfileSelector->Dir.local8Bit());
    strcpy(sys.hdr.mon_profile_file_name, (const char*)MonitorProfileSelector->getFilename().local8Bit());
}

// ------------------------------------------------------------------- Results

void lprofMain::DoScannerProfile()
{
    // qDebug("lprofMain::DoScannerProfile");
    Console -> setText("");
    ProgBar = ProgressBar;
    Gauger("Init...", 0, 100, 0);

    SetGoButton("Profiling... please wait", FALSE);
    ConsolePrintf("Working hard...");
    sys.hdr.DeviceClass = icSigInputClass;
    sys.hdr.ColorSpace  = icSigRgbData;
    sys.hdr.PCSType     = PT_Lab;
    sys.hdr.Medium      = MEDIUM_REFLECTIVE_D50;

    QString cTarget = TargetSelector -> getFilename();

    if (cTarget != QString::null)
            strcpy(sys.hdr.ReferenceSheet, cTarget.local8Bit());
    strcpy(sys.hdr.MeasurementSheet, measfile);
     // qDebug("about to call cmsxScannerProfilerDo");
     if (!cmsxScannerProfilerDo(&sys)) {
         ConsolePrintf("** ERROR: Unable to profile.");
	 // qDebug("done failed");
        return;
   }
    else  // it worked finish up
     {
        Gauger("Init...", 0, 100, 100);
        ConsolePrintf("Profile '%s' DONE!", sys.hdr.OutputProfileFile);
    }
    
    SetGoButton("Ready to GO!", TRUE);
}

void lprofMain::DoMonitorProfile()
{

    BOOL extrap;
   
   // qDebug("lprofMain::DoMonitorProfile");          
    Console -> setText("");
    ProgBar = ProgressBar_2;

    Gauger("Init...", 0, 100, 0);

    SetGoButton("Profiling... please wait", FALSE);
    ConsolePrintf("Working hard...");
    sys.hdr.DeviceClass = icSigDisplayClass;
    sys.hdr.ColorSpace  = icSigRgbData;
    sys.hdr.PCSType     = PT_Lab;
    sys.hdr.Medium      = MEDIUM_TRANSMISSIVE;        
    extrap = sys.lLocalConvergenceExtrapolation;
    sys.lLocalConvergenceExtrapolation = FALSE;
    strcpy(sys.hdr.ReferenceSheet, "");
    if (RadioCoarse->isChecked()) 
        strcpy(sys.hdr.MeasurementSheet, "");
    else
        strcpy(sys.hdr.MeasurementSheet, MonMeasurementSheet->getFilename().local8Bit());
    if (!cmsxMonitorProfilerDo(&sys)) {
        ConsolePrintf("** ERROR: Unable to profile.");
        return;  // it failed
    }
    else {  // it worked finish up
        Gauger("Init...", 0, 100, 100);
        ConsolePrintf("Profile '%s' DONE!", sys.hdr.OutputProfileFile);
    }
		
    SetGoButton("Ready to GO!", TRUE);
    sys.lLocalConvergenceExtrapolation = extrap;
}

// --------------------------------------------------------------------- Slots


void lprofMain::slotSelectOutputFile()
{
    // qDebug("lprofMain::slotSelectOutputFile");
#ifdef USE_KDE
    QString fn = KFileDialog::getSaveFileName( outprofile, 
                                                "*.icc *.icm| icc profiles (*.icc *.icm)\n*.*|All files (*.*)",
                                                this,
                                                "Select output profile filename");
#else
    QString fn = QFileDialog::getSaveFileName( outprofile, 
                                                "icc profiles (*.icc *.icm)\nAll files (*.*)",
                                                this,
                                                "",
                                                "Select output profile filename");
#endif
    if (fn != QString::null)
        SetOutputFile(fn);
    ConsolePrintf("select file name");
    slotIsAllReady();
} 

void lprofMain::slotIsAllReady()
{
   // qDebug("lprofMain::slotIsAllReady");
    // check what type of profile is currently being worked on
    // and decide if the GoButton should be enabled
    switch (TabProfiler -> currentPageIndex()) {

        case 0: if (!OutputFileEdit -> text() == QString::null) OutputFileEdit_2 -> setText(OutputFileEdit -> text());
                     if (TargetSelector -> getFilename() == QString::null)
                          SetGoButton("You still have to select the target reference file", FALSE);
                     else
                         if (OutputFileEdit -> text() == "")
                            SetGoButton("You need to specify output profile!", FALSE);
                        else
                            if (!(Marks.ul_x>0 && Marks.ur_x>0 && Marks.ll_x>0 && Marks.lr_x>0))
                                SetGoButton("You need to load a target image and select it's corners!", FALSE);
                                else 
                                     SetGoButton("Ready to GO!", TRUE);
                      break;
        case 1: if (!OutputFileEdit_2 -> text() == QString::null) OutputFileEdit -> setText(OutputFileEdit_2 -> text());
                     if (RadioCoarse->isChecked()&&OutputFileEdit -> text() == "")
                          SetGoButton("You need to specify output profile!", FALSE);
                     else
                          if (RadioCoarse->isChecked())
                              if (monitorValues.items.valid_mon)
                                 SetGoButton_2("Ready to GO!", TRUE); 
                              else
                                  SetGoButton_2("You need to enter monitor values.", FALSE);
                          else
                              if (RadioAccurate->isChecked()&&MonMeasurementSheet->getFilename()=="")                                                         SetGoButton_2("You need to specify a measurement sheet!", FALSE);
                             else
                                 SetGoButton_2("Ready to GO!", TRUE); 
                       break;

    default:; // if not on a profileing tab then do nothing
        
    }	
}


void lprofMain::Go_button_clicked()
{
    // qDebug("lprofMain::Go_button_clicked");
   ControlsToValues();
   switch (TabProfiler -> currentPageIndex()) {

        case 0: DoScannerProfile(); break;
        case 1: DoMonitorProfile(); break;
        
    default:;  // if not on a profiling tab do nothing
    }	
}


void lprofMain::slotTargetChanged()
{
    // qDebug("lprofMain::slotTargetChanged");
    // DescriptorText -> setText("");

    QString TargetFile = TargetSelector -> getFilename();
    
    if (TargetFile == QString::null) return;

    LCMSHANDLE hIT8 = cmsxIT8LoadFromFile(TargetFile.local8Bit());
    if (hIT8 == NULL) return;

     cmsxIT8Free(hIT8);
     slotIsAllReady();

}


BOOL lprofMain::LoadConfig()
{
    char temp[128];
    target_template hold;
    
    // qDebug("lprofMain::LoadConfig");
    QFile Check(ConfigFile);

    if (Check.exists()) {

        LCMSHANDLE hCfg = cmsxIT8LoadFromFile(ConfigFile);
        if (hCfg == (LCMSHANDLE) NULL) return FALSE;
                
                // from Measurement tool
        SelectTemplate->Dir = (cmsxIT8GetProperty(hCfg, "TEMPLATE_DIR"));   
        SelectTemplate->FillValues();
        SelectTemplate->setCurrItem((int) cmsxIT8GetPropertyDbl(hCfg, "TEMPLATE_NUM"));
        
        MonitorProfileSelector ->Dir = (cmsxIT8GetProperty(hCfg,"MONITOR_PROFILES_DIR"));
        MonitorProfileSelector ->RestrictColorspace = icSigRgbData;
        MonitorProfileSelector ->RestrictClass = icSigDisplayClass;
        MonitorProfileSelector -> FillValues();
        MonitorProfileSelector ->setFilename(cmsxIT8GetProperty(hCfg,   "MONITOR_PROFILE"));

        InputProfileSelector->Dir = (cmsxIT8GetProperty(hCfg,   "INPUT_PROFILES_DIR"));
        InputProfileSelector-> RestrictColorspace = icSigRgbData;
        InputProfileSelector->FillValues();
        InputProfileSelector->setFilename(cmsxIT8GetProperty(hCfg,  "INPUT_PROFILE"));

        SafeFrame -> setValue((int) cmsxIT8GetPropertyDbl(hCfg, "SAFE_FRAME"));
        
        TargetSelector->Dir = (cmsxIT8GetProperty(hCfg, "TARGET_DIR"));	
        TargetSelector->FillValues();
        TargetSelector->setCurrItem((int) cmsxIT8GetPropertyDbl(hCfg, "TARGET_NUM"));
        
        targetList->clear();
        const int n=(int)cmsxIT8GetPropertyDbl(hCfg, "NUMBER_TARGETS");
        for (int i=0; i<=n-1; i++) 
        {
            // file target to template list with information
            sprintf(temp,"TARGET%i", i);
            hold.targetFile=cmsxIT8GetProperty(hCfg, temp);
            sprintf(temp,"TEMPLATE%i", i);
            hold.templateFile=cmsxIT8GetProperty(hCfg, temp);
            add_target(hold);
        }
        
        if (TargetSelector->count()>targetList->count())
        {
            // we know that at least one target has been added since the last time the 
            // the config file was saved.  So we must up date the targetList->
           // This should never happen since it is an indication that the program crashed
            // the last time it was run or the user manually copied a reference file to the 
            // hidden configuration directory
            qDebug("Target not in targetList");
        }
        init_targetlist();   
        slotTargetRefChanged();
        OutputFileEdit -> setText(cmsxIT8GetProperty(hCfg, "OUTPUT_PROFILE"));
        sys.hdr.CLUTPoints = (int) cmsxIT8GetPropertyDbl(hCfg, "CLUT_POINTS");
        sys.hdr.ProfileVerbosityLevel = (int) cmsxIT8GetPropertyDbl(hCfg, "PROFILE_VERBOSITY_LEVEL");
        sys.lLocalConvergenceExtrapolation= (int) cmsxIT8GetPropertyDbl(hCfg, "LOCAL_ANALYSIS");

        cmsxIT8Free(hCfg);
        return TRUE;
    } 
          //  means no config file found this is first time app has been run
          // config file will be created when program is closed
         // Set everything to default values
    
    SafeFrame -> setValue(60);
    SelectTemplate -> Dir = templates;
    SelectTemplate->FillValues();
    SelectTemplate->setCurrItem(0);
    TargetSelector->Dir = ref_dir;
    TargetSelector->FillValues();
    TargetSelector->setCurrItem(0);
    MonitorProfileSelector ->Dir = mon_profile;
    MonitorProfileSelector ->FillValues();
    InputProfileSelector ->Dir = in_profile;
    InputProfileSelector->FillValues();  
    return FALSE;
	
}

void lprofMain::setProfileParmsText()
{
    char buff[128];
    // qDebug("lprofMain::setProfileParmsText");
    sprintf(buff,"Resolution (CLUT points):  %i", sys.hdr.CLUTPoints );
    textEditProfileParms->setText(buff);
    
    switch (sys.hdr.ProfileVerbosityLevel)
    {
    case 0:
        textEditProfileParms->insertParagraph("Profile verbosity: Only required tags", 3);
        break;
    case 1: 
        textEditProfileParms->insertParagraph("Profile verbosity: Store additional tags", 3);
        break;
    case 2: 
        textEditProfileParms->insertParagraph("Profile verbosity: Store anything", 3);
        break;
    }
    
    if (sys.lLocalConvergenceExtrapolation) 
	textEditProfileParms->insertParagraph("Extrapolation method: Local convergence", 5);
    else 
	textEditProfileParms->insertParagraph("Extrapolation method: normal", 5); 
    
    if (sys.hdr.lUseCIECAM97s)
    {
	 textEditProfileParms->insertParagraph("CIECAM97s: ", 7);
	 sprintf(buff,"%i",sys.hdr.device.surround);

	 switch (sys.hdr.device.surround)
	 {
	 case 0:  
	     textEditProfileParms->insertParagraph("       Average surround (>4)",8);
	     break;
	 case 1:  
	     textEditProfileParms->insertParagraph("       Average surround", 8);
	     break;
	 case 2: 
	     textEditProfileParms->insertParagraph("       Dim surround", 8);
	     break;
	 case 3: 
	     textEditProfileParms->insertParagraph("       Dark surround", 8);
	     break;
	 case 4:	 
	     textEditProfileParms->insertParagraph("       Cutsheet surround", 8);
	     break;
	 default:
	      textEditProfileParms->insertParagraph("       Average surround (>4)", 8);
                }
	 sprintf(buff,"       La: %g",sys.hdr.device.La);
	 textEditProfileParms->insertParagraph(buff, 9);
	 sprintf(buff,"       Yb: %g",sys.hdr.device.Yb);
	 textEditProfileParms->insertParagraph(buff, 9);

     }   
    else textEditProfileParms->insertParagraph("Linear Bradford ", 7);
  
}

void lprofMain::setProfileIDText()
{  
    // qDebug("lprofMain::setProfileIDText");
    textEditProfileID->setText( "Model: ");
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert( sys.hdr.Model);
    textEditProfileID->insertParagraph("Manufacturer: ", 3);
    textEditProfileID->moveCursor(QTextEdit::MoveDown, 0);
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert(sys.hdr.Manufacturer);
    textEditProfileID->insertParagraph("Description: ", 5); 
    textEditProfileID->moveCursor(QTextEdit::MoveDown, 0);
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert(sys.hdr.Description);
    textEditProfileID->insertParagraph("Copyright: ", 7);
    textEditProfileID->moveCursor(QTextEdit::MoveDown, 0);
    textEditProfileID->moveCursor(QTextEdit::MoveLineEnd, 0);
    textEditProfileID->insert(sys.hdr.Copyright);
}


void lprofMain::SaveConfig()
{  
    char temp[128];
    // qDebug("lprofMain::SaveConfig");
    LCMSHANDLE hCfg = cmsxIT8Alloc();
    cmsxIT8SetProperty(hCfg,	"TARGET_DIR", TargetSelector->Dir.local8Bit());
    cmsxIT8SetPropertyDbl(hCfg, "TARGET_NUM", TargetSelector->getCurrItem());
    cmsxIT8SetPropertyDbl(hCfg, "NUMBER_TARGETS",  (double)targetList->count());
    if (!targetList->isEmpty()) 
        for (int i=0; i<=targetList->count()-1; i++) 
        {
            // add target to template information
            sprintf(temp,"TARGET%i", i);
            cmsxIT8SetProperty(hCfg, temp, targetList->at(i)->targetFile.local8Bit());
            sprintf(temp,"TEMPLATE%i", i);
            cmsxIT8SetProperty(hCfg, temp, targetList->at(i)->templateFile.local8Bit());
        }
    cmsxIT8SetProperty(hCfg,	"MEASUREMENT_SHEET", 	measfile);
    cmsxIT8SetProperty(hCfg,	"OUTPUT_PROFILE", 		OutputFileEdit -> text().local8Bit());
    cmsxIT8SetPropertyDbl(hCfg, "CLUT_POINTS", sys.hdr.CLUTPoints);
    cmsxIT8SetPropertyDbl(hCfg, "PROFILE_VERBOSITY_LEVEL", sys.hdr.ProfileVerbosityLevel);
    cmsxIT8SetPropertyDbl(hCfg, "LOCAL_ANALYSIS", sys.lLocalConvergenceExtrapolation);
    cmsxIT8SetProperty(hCfg,    "TEMPLATE_DIR", SelectTemplate->Dir.local8Bit());
    cmsxIT8SetPropertyDbl(hCfg, "TEMPLATE_NUM", SelectTemplate->getCurrItem());
    cmsxIT8SetProperty(hCfg,    "MONITOR_PROFILES_DIR", MonitorProfileSelector->Dir.local8Bit());
    cmsxIT8SetProperty(hCfg,    "MONITOR_PROFILE", MonitorProfileSelector->getFilename().local8Bit());
    cmsxIT8SetProperty(hCfg,    "INPUT_PROFILES_DIR", InputProfileSelector->Dir.local8Bit());
    cmsxIT8SetProperty(hCfg,    "INPUT_PROFILE", InputProfileSelector->getFilename().local8Bit());
    cmsxIT8SetPropertyDbl(hCfg, "SAFE_FRAME", SafeFrame->value());
    cmsxIT8SaveToFile(hCfg, ConfigFile);
    cmsxIT8Free(hCfg);
}

void lprofMain::slotChangeStrategy()
{
    // qDebug("lprofMain::setProfileIDText");
    NoHardwareLabel->setEnabled(RadioCoarse->isChecked());
    MeasureMonitorButton->setEnabled(RadioCoarse->isChecked());
    MonMeasurementSheet->setEnabled(RadioAccurate->isChecked());
    ControlsToValues(); 
    slotIsAllReady();
}

void lprofMain::slotTargetRefChanged()
{
   if (!targetList->isEmpty())  // taragetList has items and we are now at the begining
      for (int i=0; i<targetList->count(); i++)
         if (targetList->at(i)->targPos == TargetSelector->getCurrItem())
            {
                SelectTemplate->setCurrItem(targetList->at(i)->tempPos);
                break;
            }      
}

// interfaces to other dialogs

void lprofMain::ProfChecker_clicked()
{
    // qDebug("lprofMain::profChecker_clicked");
    ControlsToValues();
    ProfileChecker check(this);
    check.show();
    check.exec();
}

void lprofMain::ProfIDpushButton_clicked()
{
    // qDebug("lprofMain::ProfIDButton_clicked");
    ProfileID profID(this);
    profID.setModal(true);
    profID.show();
    profID.exec();
    
    setProfileIDText();
    slotIsAllReady();    
}


void lprofMain::ProfileParmsbutton()
{
    // qDebug("lprofMain::ProfileParmsbutton");
    ProfileParms profParms(this);
    profParms.show();
    profParms.exec();
    
    setProfileParmsText();
    slotIsAllReady();
}


void lprofMain::monitorvalues_clicked()
{
    // qDebug("lprofMain::monitorvalues_clicked");
    MonitorValues monVal(this);
    monVal.show();
    monVal.exec();
    slotIsAllReady();
}

void monVal::get(monVal* out)
{
    // qDebug("in get mon");
    out->items.wppos=monitorValues.items.wppos;
    out->items.ppos=monitorValues.items.ppos;
    out->items.temp=monitorValues.items.temp;
    out->items.linked=monitorValues.items.linked;
    out->items.rgamma=monitorValues.items.rgamma;
    out->items.ggamma=monitorValues.items.ggamma;
    out->items.bgamma=monitorValues.items.bgamma;
    out->items.rchecked=monitorValues.items.rchecked;
    out->items.gchecked=monitorValues.items.gchecked;
    out->items.bchecked=monitorValues.items.bchecked;
      
    }

void monVal::put(monVal &in)
{
     monitorValues.items=in.items;
}

void passSys::get( PROFILERDATA* out)
{
    // char buff[32];
    
    // qDebug("PassSys::get");
     // sprintf(buff, "xRed = %f",sys.hdr.Primaries.Red.x);
    // qDebug(buff);
    out->hdr=sys.hdr;
    out->Prelinearization[0]=sys.Prelinearization[0];
    out->Prelinearization[1]=sys.Prelinearization[1];
    out->Prelinearization[2]=sys.Prelinearization[2];
    out->HiTerms=sys.HiTerms;       
    out->LoTerms=sys.LoTerms;
    out->lLocalConvergenceExtrapolation=sys.lLocalConvergenceExtrapolation;
     
}

void passSys::put(PROFILERDATA &in)
{
     sys=in;
}

void lprofMain::init_targetlist()
{
      QString TargetFile = TargetSelector -> getFilename();
    QString TemplateFile = SelectTemplate -> getFilename();
    int i = TargetSelector->getCurrItem();
    int n = SelectTemplate->getCurrItem();
    // reinitialize TargetSelector so that it has the new target ref file/te,plate file pair if one was added
    // This could cause the possition of the currently selected target to change in the drop down
    // So we must get the filename from the curent item to make sure that this item is selected 
    // when this is finished and before TargetSelector is reintitalized with FillValues
    TargetSelector->FillValues();
    // find new possition of currently selected target
    int j;
    for (j=0; j<TargetSelector->count(); j++)
    {
        TargetSelector->setCurrItem(j);
        if (TargetSelector->getFilename()==TargetFile) 
        { 
            i=j;
           j=TargetSelector->count();
        }
    }
    
    for (j=0; j<SelectTemplate->count(); j++)
    {
        SelectTemplate->setCurrItem(j);
        if (SelectTemplate->getFilename()==TargetFile) 
        { 
            n=j;
           j=SelectTemplate->count();
        }
    }
    // Now add new target and it's template to the target list
    for (j=0; j<TargetSelector->count(); j++)
    {
        TargetSelector->setCurrItem(j);
        for (int k=0; k<SelectTemplate->count(); k++)
        {
            SelectTemplate->setCurrItem(k);
                      
            if (!targetList->isEmpty())  // taragetList has items and we are now at the begining
                for (int m=0; m<targetList->count(); m++)  
                     if (targetList->at(m)->targetFile==TargetSelector->getFilename() && 
                        targetList->at(m)->templateFile==SelectTemplate->getFilename())
                       { 
                           targetList->at(m)->targPos=j;
                           targetList->at(m)->tempPos=k;
                       }
         }
     }
   TargetSelector->setCurrItem(i);
   SelectTemplate->setCurrItem(n);
}


void targetTemplate::put(targetTemplate &in)
{ 
    if (in.items.targetFile!=""&&in.items.templateFile!="")
        add_target(in.items);     
}

void lprofMain::slotInstallReference()
{
    // qDebug("lprofMain::ProfIDButton_clicked");
    InstallRefFile reffile(this);
    reffile.setModal(true);
    reffile.show();
    reffile.exec();
    init_targetlist();
    // qDebug("back from inti_targetList");
    slotTargetRefChanged();
    slotIsAllReady();    
}

void lprofMain::slotHelpButton()
{
    QStringList cmdLst;
     QString execpath = (QString) get_QTDIR() + (QString) "/bin";
     help = new QAssistantClient(execpath, this);
     cmdLst << "-showSidebar";
     QString path = QDir::currentDirPath() + "/help";
     // qDebug("path used in the command list = " + path);
     cmdLst << "-profile" << path + QDir::separator() + QString("lprof-help.adp");
     help->setArguments( cmdLst );
     path = QDir::currentDirPath() + "/help/lprof-help.html";
     // qDebug(path);
     help->openAssistant ();
     help->showPage(path);
}
