#ifndef PROFILECHECKER_H
#define PROFILECHECKER_H

#include <qstringlist.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qslider.h>
#include <qfiledialog.h>
#include <qmultilineedit.h>
#include <qtabwidget.h>
#include <qtextview.h>
#include <qprogressbar.h>
#include <qdir.h>
#include <qapplication.h>
#include <qtable.h>
#include <qtooltip.h>
#include "profilecheckerbase.h"
#include "lcmsprf.h"

#include <qvariant.h>
#include <qpixmap.h>

class  ProfileChecker : public ProfileCheckerBase
{
  Q_OBJECT
    
public:
    
  ProfileChecker(QWidget *parent = 0 );
  virtual ~ProfileChecker();
  
public slots:

	virtual void slotSelectOutputFile();
	virtual void slotGO();
	virtual void slotChangeCurve();
	virtual void slotUpdateLabels();
	virtual void slotSelectScanoutIT8();  
    
protected:

	virtual void resizeEvent(QResizeEvent* );

	void ResetData(BOOL lFree = FALSE);
	
	void SetInputProfile(const QString OutputFile);
	void SetScanoutFile(const QString ScanoutFile);

	int  GetIntent(void);

	void InspectProfile();

	void ResetMeasurement(BOOL lFree);
	void RedrawTonge();
	void RedrawCurve();
              void slotHelpButton();

	// The Data

	char ReferenceSheet[MAX_PATH];
              char MeasurementSheet[MAX_PATH];
	char OutputProfileFile[MAX_PATH];

	

	MEASUREMENT m;

	icColorSpaceSignature ProfileColorSpace;
	icColorSpaceSignature PCSColorSpace;
	int nChennels;

	cmsCIExyYTRIPLE Primaries;
	cmsCIEXYZ		MediaWhite;

	LPGAMMATABLE TRC[3];
	LPGAMMATABLE A2B0Pre[3][MAXCHANNELS];
	LPGAMMATABLE A2B0Post[3][MAXCHANNELS];
	LPGAMMATABLE B2A0Pre[3][MAXCHANNELS];
	LPGAMMATABLE B2A0Post[3][MAXCHANNELS];

	char* CharTarget;
	size_t CharTargetSize;
	
};

#endif
