##~ from kdecore import *
##~ from kdeui import *
from kdeemul import *
from utils import *

from qt import *

class LSlideShow(QWidget):
	def __init__(self, parent=None, name=None):
#		KMainWindow.__init__(self, parent, name,Qt.WX11BypassWM|Qt.WStyle_NoBorder|Qt.WType_TopLevel|Qt.WDestructiveClose|Qt.WRepaintNoErase|Qt.WResizeNoErase)
		QWidget.__init__(self, parent,name, Qt.WStyle_NoBorder|Qt.WType_TopLevel|Qt.WDestructiveClose|Qt.WRepaintNoErase|Qt.WResizeNoErase)
		self.grabKeyboard()
		self.setBackgroundMode(Qt.NoBackground)
		self.interval = 3000
		self.pause = False
		self.msg = None
		self.repeat = False
		self.currImage = None
		
	def keyPressEvent(self, event):
		if not(event.isAutoRepeat()): # ignore repeating events
			if event.state() == Qt.NoButton:
				if event.key() == Qt.Key_Right:
					self.slotNextSlide()
				elif event.key() == Qt.Key_Left:
					self.slotPrevSlide()
				elif event.key() == Qt.Key_Return or event.key() == Qt.Key_Enter or event.key() == Qt.Key_Escape:
					self.slotStopShow()
				elif event.key() == Qt.Key_Space:
					self.slotTogglePause()
				elif event.key() == Qt.Key_R:
					self.slotToggleRepeat()
		
	def actionCollection(self):
		return self.ac

	def setImageList(self, imageKeys):
		self.i = 0
		self.imageKeys = imageKeys
		for key in imageKeys:
			print "ss",key
		print "SS Got imageKeys"

	def startSlideShow(self):
		s = LWaitCursor.getApp().desktop().size()
		self.setGeometry(0,0,s.width(),s.height())
		self.showFullScreen()
		self.repaint()
		self.timer = QTimer(self)
		QObject.connect(self.timer, SIGNAL("timeout()"), self.slotAdvanceTimer)
		print "SS start timer"
		self.i = 0

		self.currImage = self.getImage(self.i)
		self.repaint()
		self.nextImage = self.getImage(self.nextIndex(self.i))
		if self.pause:
			self.timer.stop()
		else:
			self.timer.start(self.interval, True)		
		self.msg = None

	def slotAdvanceTimer(self):
		self.msg = None
		self.currImage = self.nextImage
		self.i = self.nextIndex(self.i)
		if self.i == 0 and not self.repeat:
			print "SS Closing"
			self.close()
		else:
			self.repaint()
			self.nextImage = self.getImage(self.nextIndex(self.i))
			if not self.pause:
				self.timer.start(self.interval, True)

	def paintEvent(self, paintEvent):
		painter = QPainter(self)
		painter.setBackgroundColor(QColor(0,0,0))
		if self.currImage:
			r,b1,b2 = self.mapRect(self.rect(), self.currImage.rect())
			painter.drawImage(r.x(), r.y(), self.currImage)
			painter.eraseRect(b1)
			painter.eraseRect(b2)
		else:
			painter.eraseRect(self.rect())
			
		if self.msg:
			pt = self.rect().bottomLeft() + QPoint(10,-10)
			
			
			painter.setPen(QPen(QColor(0,255,0)))
			painter.drawText(pt, self.msg)

	def getImage(self, i):
		if hasattr(self, "imageKeys"):
			p = QImage(self.lib.getImage(self.imageKeys[i])['ImagePath'])
			r,b1,b2 = self.mapRect(self.rect(), p.rect())
			return p.smoothScale(r.width(), r.height())

	def nextIndex(self, i):
		i = i + 1
		if i >= len(self.imageKeys):
			return 0
		else:
			return i

	def prevIndex(self, i):
		i = i - 1
		if i < 0:
			return len(self.imageKeys) - 1
		else:
			return i

	def slotNextSlide(self):
		self.timer.stop()
		self.slotAdvanceTimer()

	def slotPrevSlide(self):
		self.msg = None
		self.timer.stop()
		self.nextImage = self.currImage
		self.i = self.prevIndex(self.i)
		self.currImage = self.getImage(self.i)
		self.repaint()
		if not self.pause:
			self.timer.start(self.interval,True)

	def slotStopShow(self):
		self.close()
		
	def slotTogglePause(self):
		if self.pause:
			self.pause = False
			self.timer.start(self.interval/2,True)
			self.msg = "Play"
		else:
			self.pause = True
			self.timer.stop()
			self.msg = "Pause"
		self.update()
		
	def slotToggleRepeat(self):
		if self.repeat:
			self.repeat = False
			self.msg = "Repeat Off"
		else:
			self.repeat = True
			self.msg = "Repeat On"
		self.update()

	def mapRect(self, ro, ri): #create a new rect that maps ri to the inside of ro
		ratio = min(ro.width()/float(ri.width()), ro.height()/float(ri.height()))
		w = ri.width()*ratio
		h = ri.height()*ratio
		x = ro.x() + (ro.width() - w) / 2
		y = ro.y() + (ro.height() - h) / 2
		if w == ro.width():
			b1 = QRect(ro.x(), ro.y(), ro.width(), y)
			b2 = QRect(ro.x(), ro.y()+y+h ,ro.width() , ro.height()-y-h)
		else:
			b1 = QRect(ro.x(), ro.y(), x, ro.height())
			b2 = QRect(ro.x()+x+w, ro.y(), ro.width()-x-w, ro.height())
		return QRect(x,y,w,h), b1, b2

