/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

GtkWidget *create_search_list_popup(file_t * file);

void ping_update(unsigned long ip, int ptime);

gint search_compare(GtkCList * clist,
		    gconstpointer ptr1, gconstpointer ptr2);

char* LifeTime(int id);
int destination2int(char *dest);
file_t *file_create_from_search_response(net_t* net, char *data);
void send_search_request();
void send_search_request_from_string(char* data);
void send_search_again(search_t* search);
void file_insert_search(file_t * file, int destination);

void napster_search(search_t * search, net_t* net);

search_pattern_t *search_pattern_new();
int search_pattern_fits_file(search_pattern_t * search, file_t * file,
			     int with_type);
void search_pattern_load();
void search_pattern_save();
search_pattern_t *search_pattern_copy(search_pattern_t * search);
void search_pattern_show(search_pattern_t * search, int mode);

search_t *search_new();
void search_clear(search_t * search);
void search_destroy(search_t * search);
void search_remove(search_t * search);
file_t *search_find_file(search_t * search, file_t * file);
void search_update_stats(search_t * search, int check);
void search_update_counter();
GtkWidget *search_fields_detach();
GtkWidget *search_fields_detach2();
void search_search(search_t * pattern);
void search_requeue(search_t* search, net_t* net);
void search_queue(search_t * search, net_t* net, int top);
void search_do(search_t * search, net_t* net, int dest);
int search_finish(search_t* search, net_t* net, int next);
void search_next(net_t* net);
search_t* search_finish_oldest(net_t* net);
search_t* search_finish_latest(net_t* net);
int search_insert_file(search_t* search, file_t * file);
void search_insert_file_real(GtkCTree* ctree, file_t * file);
void search_clear_old(search_t * search, net_t* net);
void search_remove_file(GtkCTree* ctree, file_t* file);

void setup_search_fields();
void search_pattern_rename(search_pattern_t* pattern);
void search_pattern_search(search_pattern_t* pattern, net_t* net);
GtkWidget *create_search_pattern_popup(search_pattern_t *pattern);

void search_info_remove(search_t* search, net_t* net);
void search_show_template(char* text);

void search_add_network(net_t* net);
void search_remove_network(net_t* net);
