/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/time.h>
#include <sys/types.h>
#include <dirent.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <string.h>

#include "lopster.h"
#include "connection.h"
#include "global.h"
#include "search.h"
#include "transfer.h"
#include "resume.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"
#include "hotlist.h"
#include "commands.h"
#include "chat.h"
#include "share2.h"
#include "dirselect.h"
#include "scheme.h"
#include "handler.h"
#include "resume.h"
#include "server.h"
#include "preferences.h"
#include "log.h"
#include "utils.h"
#include "bannet.h"

void check_uploads_again();

char* DownloadList(int id) {
  switch (id) {
  case 0:
    return "Active List";
  case 1:
    return "Queued List";
  case 2:
    return "Inactive List";
  case 3:
  default:
    return "Deactivated List";
  }
}

char* DownloadPage(int id) {
  switch (id) {
  case 0:
    return "Active Page";
  case 1:
    return "Queued Page";
  case 2:
    return "Inactive Page";
  case 3:
  default:
    return "Deactivated Page";
  }
}

void setup_preferences(unsigned long flags) {
  GtkWidget *win;
  GtkWidget *temp;
  GList *dlist;
  char *pos;

  if (!global.options_win)
    return;
  else
    win = global.options_win;

  if (flags & P_TREE) {
    GtkCTreeNode *node;
    GtkCTreeNode *node2;
    GtkCTree *ctree;

    ctree = GTK_CTREE(lookup_widget(win, "ctree2"));
    gtk_ctree_set_line_style(ctree, GTK_CTREE_LINES_NONE);
    gtk_ctree_set_expander_style(ctree, GTK_CTREE_EXPANDER_TRIANGLE);
    strcpy(tstr[0], "General");
    node = gtk_ctree_insert_node(ctree, NULL, NULL, list, 15,
				 NULL, NULL, NULL, NULL, FALSE, TRUE);
    gtk_ctree_node_set_row_data(ctree, node, (void *) 1);
    strcpy(tstr[0], "Search");
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void *) 2);
    strcpy(tstr[0], "Transfers");
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void *) 3);
    strcpy(tstr[0], "Mimetypes");
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void *) 4);
    strcpy(tstr[0], "Paths");
    node = gtk_ctree_insert_node(ctree, NULL, NULL, list, 15,
				 NULL, NULL, NULL, NULL, FALSE, TRUE);
    gtk_ctree_node_set_row_data(ctree, node, (void *) 5);
    strcpy(tstr[0], "Download");
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void *) 6);
    strcpy(tstr[0], "Shares");
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void *) 7);
    strcpy(tstr[0], "Appearance");
    node = gtk_ctree_insert_node(ctree, NULL, NULL, list, 15,
				 NULL, NULL, NULL, NULL, FALSE, TRUE);
    gtk_ctree_node_set_row_data(ctree, node, (void *) 8);
    strcpy(tstr[0], "Chat");
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void *) 9);
    strcpy(tstr[0], "Transfers");
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void *) 10);
    strcpy(tstr[0], "Schemes");
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void *) 11);
    strcpy(tstr[0], "Advanced");
    node = gtk_ctree_insert_node(ctree, NULL, NULL, list, 15,
				 NULL, NULL, NULL, NULL, FALSE, TRUE);
    gtk_ctree_node_set_row_data(ctree, node, (void *) 12);
    strcpy(tstr[0], "Netbans/Events");
    node2 = gtk_ctree_insert_node(ctree, node, NULL, list, 15,
				  NULL, NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(ctree, node2, (void *) 13);

    temp = lookup_widget(win, "frame267");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame268");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame69");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame37");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame39");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame398");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame11");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame155");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame93");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "label427");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "label428");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame176");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame184");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "label506");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "label1659");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame187");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame188");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "label513");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame240");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "label780");
    gtk_widget_set_style(temp, global.styles[STYLE_PREF]);
    temp = lookup_widget(win, "frame306");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame359");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame307");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame308");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame318");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame321");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame1416");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame384");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame385");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame396");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
    temp = lookup_widget(win, "frame397");
    gtk_widget_set_style(temp, global.styles[STYLE_LABEL]);
  }
  if (flags & P_GENERAL) {
    temp = lookup_widget(win, "entry4");
    gtk_entry_set_text(GTK_ENTRY(temp), global.username);
    temp = lookup_widget(win, "entry5");
    gtk_entry_set_text(GTK_ENTRY(temp), global.password);
    temp = lookup_widget(win, "entry7");
    gtk_entry_set_text(GTK_ENTRY(temp), global.email);
    temp = GTK_COMBO(lookup_widget(win, "combo3"))->entry;
    gtk_entry_set_text(GTK_ENTRY(temp), LineSpeed(global.linespeed));
    temp = lookup_widget(win, "spinbutton2");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) global.network.port);
    if (global.network.firewall) {
      temp = lookup_widget(win, "table11");
      gtk_widget_set_sensitive(GTK_WIDGET(temp), FALSE);
      temp = lookup_widget(win, "radiobutton6");
    } else {
      temp = lookup_widget(win, "radiobutton7");
    }
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);

    temp = lookup_widget(win, "entry83");
    pos = create_string_from_ports(global.allowed_ports);
    if (pos) gtk_entry_set_text(GTK_ENTRY(temp), pos);
    l_free(pos);

    // Weasel75
    pos = l_malloc(100);
    if (pos) {
      temp = lookup_widget(win, "entry_speedred");
      print_bytes(pos, global.options.down_speed[0]);
      gtk_entry_set_text(GTK_ENTRY(temp), pos);

      temp = lookup_widget(win, "entry_speedyellow");
      print_bytes(pos, global.options.down_speed[1]);
      gtk_entry_set_text(GTK_ENTRY(temp), pos);

      temp = lookup_widget(win, "entry_speedgreen");
      print_bytes(pos, global.options.down_speed[2]);
      gtk_entry_set_text(GTK_ENTRY(temp), pos);
      
      temp = lookup_widget(win, "entry_speedred2");
      print_bytes(pos, global.options.up_speed[0]);
      gtk_entry_set_text(GTK_ENTRY(temp), pos);

      temp = lookup_widget(win, "entry_speedyellow2");
      print_bytes(pos, global.options.up_speed[1]);
      gtk_entry_set_text(GTK_ENTRY(temp), pos);

      temp = lookup_widget(win, "entry_speedgreen2");
      print_bytes(pos, global.options.up_speed[2]);
      gtk_entry_set_text(GTK_ENTRY(temp), pos);
      
      l_free(pos);
    }
  }

  if (flags & P_RSEARCH) {
    temp = lookup_widget(win, "spinbutton51");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp), global.options.resume_timeout);
    temp = lookup_widget(win, "checkbutton48");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), global.options.auto_search);
  }
  if (flags & P_PINGS) {
    temp = lookup_widget(win, "checkbutton49");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.ping_search);
    temp = lookup_widget(win, "entry85");
    if (global.ping_command)
      gtk_entry_set_text(GTK_ENTRY(temp), global.ping_command);
    gtk_widget_set_sensitive(temp, global.options.ping_search);
  }

  if (flags & P_D_LIMIT) {
    temp = lookup_widget(win, "spinbutton38");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) global.limit.max_downloads);
  }
  if (flags & P_U_LIMIT) {
    temp = lookup_widget(win, "spinbutton39");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) global.limit.max_uploads);
  }
  if (flags & P_D_ULIMIT) {
    temp = lookup_widget(win, "spinbutton1");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) global.limit.default_downloads);
  }
  if (flags & P_U_ULIMIT) {
    temp = lookup_widget(win, "spinbutton3");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) global.limit.default_uploads);
  }
  if (flags & P_AUTORESUME) {
    temp = lookup_widget(win, "checkbutton34");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.auto_resume);
  }
  if (flags & P_REST1) {
    char str[100];
    temp = lookup_widget(win, "spinbutton40");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) (global.network.transfer_timeout_down));
    temp = lookup_widget(win, "spinbutton67");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) (global.network.transfer_timeout_up));
    temp = lookup_widget(win, "checkbutton62");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.confirm_delete);
    temp = lookup_widget(win, "checkbutton69");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.check_lib_for_download);
    temp = lookup_widget(win, "entry153");
    print_bytes(str, global.limit.download_abort_limit);
    gtk_entry_set_text(GTK_ENTRY(temp), str);
    temp = lookup_widget(win, "spinbutton76");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) (global.limit.download_abort_number));
    temp = lookup_widget(win, "spinbutton71");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) (global.limit.max_large));
    temp = lookup_widget(win, "spinbutton72");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) (global.limit.large_size));
  }

  if (flags & P_MIMETYPES) {
    int i1;
    suffix_t *suffix;

    temp = lookup_widget(win, "clist17");
    for (i1 = 1; i1 < MIME_SIZE; i1++) {
      for (dlist = global.mimetype[i1].suffixes; dlist;
	   dlist = dlist->next) {
	suffix = dlist->data;
	strcpy(tstr[0], suffix->suffix);
	strcpy(tstr[1], MimeNames(i1, 0));
	strcpy(tstr[2], suffix->application);
	if (suffix->as_mp3)
	  strcpy(tstr[3], "Yes");
	else
	  strcpy(tstr[3], "No");
	gtk_clist_append(GTK_CLIST(temp), list);
      }
    }
  }

  if (flags & P_PATHS) {
    temp = lookup_widget(win, "entry75");
    if (global.incomplete_path)
      gtk_entry_set_text(GTK_ENTRY(temp), global.incomplete_path);
    else
      gtk_entry_set_text(GTK_ENTRY(temp), "");
  }

  if (flags & P_DOWNLOAD) {
    int i1;
    temp = lookup_widget(win, "clist18");
    for (i1 = 0; i1 < MIME_SIZE; i1++) {
      strcpy(tstr[0], MimeNames(i1, 0));
      if (global.mimetype[i1].download)
	strcpy(tstr[1], global.mimetype[i1].download);
      else
	strcpy(tstr[1], "");
      gtk_clist_append(GTK_CLIST(temp), list);
    }
  }

  if (flags & P_SHARES) {
    shared_folder_t* folder;
    int row;

    temp = lookup_widget(win, "clist19");
    gtk_clist_clear(GTK_CLIST(temp));
    if (global.lib) {
      for (dlist = global.lib->shared_folder; dlist; dlist = dlist->next) {
	folder = dlist->data;
	strcpy(tstr[0], MimeNames(folder->type, 1));
	strcpy(tstr[1], folder->name);
	row = gtk_clist_append(GTK_CLIST(temp), list);
      }
    }
  }

  if (flags & P_PARSE_COLOR) {
    temp = lookup_widget(win, "checkbutton22");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.parse_colors);
    temp = lookup_widget(win, "checkbutton87");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.strip_colors);
  }
  if (flags & P_TAB_STYLE) {
    temp = lookup_widget(win, "checkbutton57");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.tab_style & TAB_ICON);

    temp = lookup_widget(win, "checkbutton58");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.tab_style & TAB_TEXT);

    if (global.options.server_motd)
      temp = lookup_widget(win, "radiobutton4");
    else
      temp = lookup_widget(win, "radiobutton5");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    
    temp = lookup_widget(win, "spinbutton68");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      global.server_paned);

    // download layout
    temp = lookup_widget(win, "combo_entry30");
    gtk_entry_set_text(GTK_ENTRY(temp),
		       DownloadList(global.dl_layout.transfer_position[0]));
    temp = lookup_widget(win, "entry150");
    gtk_entry_set_text(GTK_ENTRY(temp),
		       DownloadList(global.dl_layout.transfer_position[1]));
    temp = lookup_widget(win, "entry151");
    gtk_entry_set_text(GTK_ENTRY(temp),
		       DownloadList(global.dl_layout.transfer_position[2]));
    temp = lookup_widget(win, "entry152");
    gtk_entry_set_text(GTK_ENTRY(temp),
		       DownloadList(global.dl_layout.transfer_position[3]));
    temp = lookup_widget(win, "entry146");
    gtk_entry_set_text(GTK_ENTRY(temp),
		       DownloadPage(global.dl_layout.ctree_position[0]));
    temp = lookup_widget(win, "entry147");
    gtk_entry_set_text(GTK_ENTRY(temp),
		       DownloadPage(global.dl_layout.ctree_position[1]));
    temp = lookup_widget(win, "entry148");
    gtk_entry_set_text(GTK_ENTRY(temp),
		       DownloadPage(global.dl_layout.ctree_position[2]));
    temp = lookup_widget(win, "entry149");
    gtk_entry_set_text(GTK_ENTRY(temp),
		       DownloadPage(global.dl_layout.ctree_position[3]));
  }

  if (flags & P_SHOW_JOIN) {
    temp = lookup_widget(win, "combo_entry25");
    switch (global.options.show_parts) {
    case 0:
      gtk_entry_set_text(GTK_ENTRY(temp), "None");
      break;
    case 1:
      gtk_entry_set_text(GTK_ENTRY(temp), "Recent Users");
      break;
    case 2:
    default:
      gtk_entry_set_text(GTK_ENTRY(temp), "All");
      break;
    }

    temp = lookup_widget(win, "spinbutton56");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      global.options.recent_timeout);
    
    temp = lookup_widget(win, "combo_entry24");
    switch (global.options.show_joins) {
    case 0:
      gtk_entry_set_text(GTK_ENTRY(temp), "None");
      break;
    case 1:
    default:
      gtk_entry_set_text(GTK_ENTRY(temp), "All");
      break;
    }
  }

  if (flags & P_TIMESTAMPS) {
    temp = lookup_widget(win, "entry108");
    gtk_entry_set_text(GTK_ENTRY(temp), TimeStamp(global.options.timestamps));
  }

  if (flags & P_SCHEMES) {
    if (global.scheme)
      scheme_update_list(global.scheme->name);
    else
      scheme_update_list(NULL);
  }

  if (flags & P_ADVANCED) {
    temp = lookup_widget(win, "checkbutton65");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.check_version);
    temp = lookup_widget(win, "checkbutton38");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.allow_dcc);
    temp = lookup_widget(win, "checkbutton82");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.access_transferring);
    temp = lookup_widget(win, "checkbutton54");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.dummy_md5);

    temp = lookup_widget(win, "button360");
    gtk_object_set_data(GTK_OBJECT(temp), "value",
			(void *) global.options.piping);

    temp = lookup_widget(win, "button361");
    gtk_object_set_data(GTK_OBJECT(temp), "value",
			(void *) global.options.no_piping);

    temp = lookup_widget(win, "checkbutton75");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.logging&(1<<LOG_PROTOCOL));
    temp = lookup_widget(win, "checkbutton76");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.logging&(1<<LOG_MESSAGE));
    temp = lookup_widget(win, "checkbutton77");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.logging&(1<<LOG_CHANNEL));
    temp = lookup_widget(win, "checkbutton78");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.logging&(1<<LOG_PRIVATE));
    temp = lookup_widget(win, "checkbutton79");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.logging&(1<<LOG_OTHER));
    temp = lookup_widget(win, "checkbutton80");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.logging&(1<<LOG_OPERATOR));
    temp = lookup_widget(win, "checkbutton81");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.logging&(1<<LOG_GLOBAL));
    temp = lookup_widget(win, "spinbutton34");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      global.options.log_expire);

    temp = lookup_widget(win, "combo_entry27");
    gtk_entry_set_text(GTK_ENTRY(temp), WebBrowser(global.options.browser));

    temp = lookup_widget(win, "spinbutton73");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) global.network.transfer_delay);
    temp = lookup_widget(win, "spinbutton80");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) global.limit.max_seek_add);
  }

  if (flags & P_REJOIN) {
    temp = lookup_widget(win, "checkbutton60");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.channel_rejoin);
    temp = lookup_widget(win, "checkbutton71");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.rejoin_when_kicked);
    temp = lookup_widget(win, "checkbutton68");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.colored_nicks);
    temp = lookup_widget(win, "combo_entry32");
    switch (global.options.colored_nicks) {
    case 1:
      gtk_entry_set_text(GTK_ENTRY(temp), "Light colors");
      break;
    case 2:
      gtk_entry_set_text(GTK_ENTRY(temp), "Medium colors");
      break;
    case 3:
    default:
      gtk_entry_set_text(GTK_ENTRY(temp), "Dark colors");
      break;
    }
    temp = lookup_widget(win, "combo41");
    gtk_widget_set_sensitive(temp, global.options.colored_nicks);

    temp = lookup_widget(win, "checkbutton89");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp),
				 global.options.colored_nicks2);
    temp = lookup_widget(win, "entry156");
    switch (global.options.colored_nicks2) {
    case 1:
      gtk_entry_set_text(GTK_ENTRY(temp), "Light colors");
      break;
    case 2:
      gtk_entry_set_text(GTK_ENTRY(temp), "Medium colors");
      break;
    case 3:
    default:
      gtk_entry_set_text(GTK_ENTRY(temp), "Dark colors");
      break;
    }
    temp = lookup_widget(win, "combo44");
    gtk_widget_set_sensitive(temp, global.options.colored_nicks2);

    temp = lookup_widget(win, "spinbutton_queuelimit");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) global.options.autoconnect_sendqueue_limit);
    temp = lookup_widget(win, "spinbutton77");
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			      (gfloat) global.options.max_chat_buffer);
  }

  if (flags & P_NETWORKS) {
    bannetworks_t* bn;
    int row;

    temp = lookup_widget(win, "clist41");
    for (dlist = global.bannet; dlist; dlist = dlist->next) {
      bn = l_malloc(sizeof(*bn));
      memcpy(bn, dlist->data, sizeof(*bn));
      sprintf(tstr[0], "%d.%d.%d.%d", 
	      (int)((bn->ip_from>>24)&0xff),
	      (int)((bn->ip_from>>16)&0xff),
	      (int)((bn->ip_from>>8 )&0xff),
	      (int)((bn->ip_from    )&0xff));
      sprintf(tstr[1], "%d.%d.%d.%d", 
	      (int)((bn->ip_to>>24)&0xff),
	      (int)((bn->ip_to>>16)&0xff),
	      (int)((bn->ip_to>>8 )&0xff),
	      (int)((bn->ip_to    )&0xff));
      row = gtk_clist_append(GTK_CLIST(temp), list);
      gtk_clist_set_row_data_full(GTK_CLIST(temp), row, bn, 
				  l_free);
    }

    if (global.external_handler) {
      temp = lookup_widget(win, "entry142");
      gtk_entry_set_text(GTK_ENTRY(temp), global.external_handler);
    }

    for (row = 0; row < EVENT_NUMBER; row++) {
      char text[100];
      sprintf(text, "eventbutton%d", row);
      temp = lookup_widget(win, text);
      if (temp && (global.external_events&(1<<row)))
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
    }
  }
}

void clear_suffixes()
{
  int i1;
  GList *dlist;
  suffix_t *suffix;

  for (i1 = 0; i1 < MIME_SIZE; i1++) {
    if (!global.mimetype[i1].suffixes)
      continue;
    for (dlist = global.mimetype[i1].suffixes; dlist; dlist = dlist->next) {
      suffix = (suffix_t *) (dlist->data);
      l_free(suffix->suffix);
      l_free(suffix->application);
      l_free(suffix);
    }
    g_list_free(global.mimetype[i1].suffixes);
    global.mimetype[i1].suffixes = NULL;
  }
}

int page2int(char* class) {
  if (!strcmp(class, "Active Page"))
    return 0;
  if (!strcmp(class, "Queued Page"))
    return 1;
  if (!strcmp(class, "Inactive Page"))
    return 2;
  if (!strcmp(class, "Deactivated Page"))
    return 3;
  return 3;
}

int list2int(char* class) {
  if (!strcmp(class, "Active List"))
    return 0;
  if (!strcmp(class, "Queued List"))
    return 1;
  if (!strcmp(class, "Inactive List"))
    return 2;
  if (!strcmp(class, "Deactivated List"))
    return 3;
  return 3;
}

void apply_preferences() {
  GtkWidget *win;
  GtkWidget *temp;
  char str[4096];
  int i1;
  int i2;
  unsigned long bytes;
  char *pos;
  scheme_t *scheme;
  download_layout_t dllo;
  library_t* temp_lib;
 
  if (!global.options_win) return;
  else win = global.options_win;

  check_uploads_again();

  // general
  temp = lookup_widget(win, "entry4");
  if (global.username) l_free(global.username);
  global.username = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  temp = lookup_widget(win, "entry5");
  if (global.password) l_free(global.password);
  global.password = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  temp = lookup_widget(win, "entry7");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  if (strcmp(pos, global.email)) {
    global.email = l_strdup(pos);
    command_send(NULL, CMD_CHANGE_EMAIL, global.email);
  }
  temp = GTK_COMBO(lookup_widget(win, "combo3"))->entry;
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  i1 = speed2int(pos);
  if (i1 != global.linespeed) {
    global.linespeed = i1;
    sprintf(str, "%d", global.linespeed);
    command_send(NULL, CMD_CHANGE_SPEED, str);
  }

  temp = lookup_widget(win, "entry83");
  pos = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));
  destroy_string_list(global.allowed_ports);
  global.allowed_ports = create_allowed_ports(pos);
  l_free(pos);
  pos = create_string_from_ports(global.allowed_ports);
  if (pos) gtk_entry_set_text(GTK_ENTRY(temp), pos);
  l_free(pos);

  temp = lookup_widget(win, "radiobutton6");
  i2 = 0;
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    i2 = 1;
  temp = lookup_widget(win, "radiobutton7");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    i2 = 0;
  temp = lookup_widget(win, "spinbutton2");
  i1 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  if ((global.network.port != i1) || (global.network.firewall != i2)) {
    global.network.port = i1;
    global.network.firewall = i2;
    create_upload_port(i1, TRUE);
  }

  // Weasel75
  temp = lookup_widget(win, "entry_speedred");
  i1 = extract_bytes(gtk_entry_get_text(GTK_ENTRY(temp)));
  if (i1 > 0) global.options.down_speed[0] = i1;
  else global.options.down_speed[0] = SPEED_RED;

  temp = lookup_widget(win, "entry_speedyellow");
  i1 = extract_bytes(gtk_entry_get_text(GTK_ENTRY(temp)));
  if (i1>0) global.options.down_speed[1] = i1;
  else global.options.down_speed[1] = SPEED_YELLOW;

  temp = lookup_widget(win, "entry_speedgreen");
  i1 = extract_bytes(gtk_entry_get_text(GTK_ENTRY(temp)));
  if (i1>0) global.options.down_speed[2] = i1;
  else global.options.down_speed[2] = SPEED_GREEN;

  temp = lookup_widget(win, "entry_speedred2");
  i1 = extract_bytes(gtk_entry_get_text(GTK_ENTRY(temp)));
  if (i1 > 0) global.options.up_speed[0] = i1;
  else global.options.up_speed[0] = SPEED_RED;

  temp = lookup_widget(win, "entry_speedyellow2");
  i1 = extract_bytes(gtk_entry_get_text(GTK_ENTRY(temp)));
  if (i1>0) global.options.up_speed[1] = i1;
  else global.options.up_speed[1] = SPEED_YELLOW;

  temp = lookup_widget(win, "entry_speedgreen2");
  i1 = extract_bytes(gtk_entry_get_text(GTK_ENTRY(temp)));
  if (i1>0) global.options.up_speed[2] = i1;
  else global.options.up_speed[2] = SPEED_GREEN;

  // search
  temp = lookup_widget(win, "spinbutton51");
  global.options.resume_timeout =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(win, "checkbutton48");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    global.options.auto_search = 1;
  } else {
    global.options.auto_search = 0;
  }

  temp = lookup_widget(win, "entry85");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  l_free(global.ping_command);
  global.ping_command = l_strdup(pos);

  temp = lookup_widget(win, "checkbutton49");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(global.win, "checkbutton45");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), TRUE);
  } else {
    temp = lookup_widget(global.win, "checkbutton45");
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(temp), FALSE);
  }

  // Transfers
  temp = lookup_widget(win, "spinbutton38");
  global.limit.max_downloads =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton78");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_downloads);
  temp = lookup_widget(win, "spinbutton39");
  global.limit.max_uploads =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton74");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.max_uploads);
  
  temp = lookup_widget(win, "spinbutton1");
  global.limit.default_downloads =
      gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton79");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_downloads);

  temp = lookup_widget(win, "spinbutton3");

  global.limit.default_uploads =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(global.win, "spinbutton75");
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(temp),
			    global.limit.default_uploads);

  temp = lookup_widget(win, "spinbutton40");
  global.network.transfer_timeout_down =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "spinbutton67");
  global.network.transfer_timeout_up =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "spinbutton71");
  global.limit.max_large =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  
  temp = lookup_widget(win, "spinbutton72");
  global.limit.large_size =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  global.limit.cur_large = 0;

  temp = lookup_widget(global.win, "transfer_up");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    socket_t* socket = gtk_clist_get_row_data(GTK_CLIST(temp), i1);
    upload_t* upload = socket->data;
    if (!upload) continue;
    if (upload_in_progress(upload) && upload->file)
      if (upload->file->size >= global.limit.large_size *1024 * 1024)
	global.limit.cur_large++;
  }
  
  temp = lookup_widget(win, "checkbutton34");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.auto_resume = 1;
  else
    global.options.auto_resume = 0;

  temp = lookup_widget(win, "checkbutton62");
  global.options.confirm_delete =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(win, "checkbutton69");
  global.options.check_lib_for_download =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(win, "entry153");
  bytes = extract_bytes(gtk_entry_get_text(GTK_ENTRY(temp)));
  global.limit.download_abort_limit = bytes;

  temp = lookup_widget(win, "spinbutton76");
  global.limit.download_abort_number =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  // mimetypes
  clear_suffixes();
  temp = lookup_widget(win, "clist17");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    int mime;
    char *suf;
    char *app;
    char *as_mp3;
    suffix_t *suffix;

    gtk_clist_get_text(GTK_CLIST(temp), i1, 1, &pos);
    mime = mime2int(pos);
    gtk_clist_get_text(GTK_CLIST(temp), i1, 0, &suf);
    gtk_clist_get_text(GTK_CLIST(temp), i1, 2, &app);
    gtk_clist_get_text(GTK_CLIST(temp), i1, 3, &as_mp3);
    suffix = l_malloc(sizeof(suffix_t));
    suffix->suffix = l_strdup(suf);
    suffix->application = l_strdup(app);
    if (!l_strcasecmp(as_mp3, "Yes"))
      suffix->as_mp3 = 1;
    else
      suffix->as_mp3 = 0;
    if (mime == MIME_MP3)
      suffix->as_mp3 = 1;
    global.mimetype[mime].suffixes =
	g_list_append(global.mimetype[mime].suffixes, suffix);
  }


  // paths
  temp = lookup_widget(win, "entry75");
  if (global.incomplete_path)
    l_free(global.incomplete_path);
  global.incomplete_path = l_strdup(gtk_entry_get_text(GTK_ENTRY(temp)));

  // download
  temp = lookup_widget(win, "clist18");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    int mime;

    gtk_clist_get_text(GTK_CLIST(temp), i1, 0, &pos);
    mime = mime2int(pos);
    gtk_clist_get_text(GTK_CLIST(temp), i1, 1, &pos);
    if (global.mimetype[mime].download)
      l_free(global.mimetype[mime].download);
    global.mimetype[mime].download = l_strdup(pos);
  }

  // shares
  temp_lib = lib_new("__temp_lib__");
  temp = lookup_widget(win, "clist19");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    int mime;
    gtk_clist_get_text(GTK_CLIST(temp), i1, 0, &pos);
    mime = mime2int(pos);
    gtk_clist_get_text(GTK_CLIST(temp), i1, 1, &pos);
    lib_add_folder(temp_lib, pos, mime);
  }

  // Appearance
  temp = lookup_widget(global.options_win, "button360");
  global.options.piping =
    (int) gtk_object_get_data(GTK_OBJECT(temp), "value");
  temp = lookup_widget(global.options_win, "button361");
  global.options.no_piping =
    (int) gtk_object_get_data(GTK_OBJECT(temp), "value");
  
  temp = lookup_widget(win, "combo_entry30");
  pos = (gtk_entry_get_text(GTK_ENTRY(temp)));
  dllo.transfer_position[0] = list2int(pos);
  temp = lookup_widget(win, "entry150");
  pos = (gtk_entry_get_text(GTK_ENTRY(temp)));
  dllo.transfer_position[1] = list2int(pos);
  temp = lookup_widget(win, "entry151");
  pos = (gtk_entry_get_text(GTK_ENTRY(temp)));
  dllo.transfer_position[2] = list2int(pos);
  temp = lookup_widget(win, "entry152");
  pos = (gtk_entry_get_text(GTK_ENTRY(temp)));
  dllo.transfer_position[3] = list2int(pos);
  temp = lookup_widget(win, "entry146");
  pos = (gtk_entry_get_text(GTK_ENTRY(temp)));
  dllo.ctree_position[0] = page2int(pos);
  temp = lookup_widget(win, "entry147");
  pos = (gtk_entry_get_text(GTK_ENTRY(temp)));
  dllo.ctree_position[1] = page2int(pos);
  temp = lookup_widget(win, "entry148");
  pos = (gtk_entry_get_text(GTK_ENTRY(temp)));
  dllo.ctree_position[2] = page2int(pos);
  temp = lookup_widget(win, "entry149");
  pos = (gtk_entry_get_text(GTK_ENTRY(temp)));
  dllo.ctree_position[3] = page2int(pos);

  download_layout(&dllo);

  temp = lookup_widget(win, "combo_entry24");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  if (!l_strcasecmp(pos, "None"))
    global.options.show_joins = 0;
  else
    global.options.show_joins = 1;

  temp = lookup_widget(win, "combo_entry25");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  if (!l_strcasecmp(pos, "None"))
    global.options.show_parts = 0;
  else if (!l_strcasecmp(pos, "Recent Users"))
    global.options.show_parts = 1;
  else
    global.options.show_parts = 2;
  
  temp = lookup_widget(win, "spinbutton56");
  global.options.recent_timeout =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "checkbutton22");
  global.options.parse_colors =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(win, "checkbutton87");
  global.options.strip_colors =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(win, "checkbutton57");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.tab_style |= TAB_ICON;
  else
    global.options.tab_style &= (0x03 ^ TAB_ICON);
  temp = lookup_widget(win, "checkbutton58");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.tab_style |= TAB_TEXT;
  else
    global.options.tab_style &= (0x03 ^ TAB_TEXT);
  
  temp = lookup_widget(win, "checkbutton60");
  global.options.channel_rejoin =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(win, "checkbutton71");
  global.options.rejoin_when_kicked =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(win, "checkbutton68");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(win, "combo_entry32");
    pos = gtk_entry_get_text(GTK_ENTRY(temp));
    if (!l_strcasecmp(pos, "Dark Colors"))
      global.options.colored_nicks = 3;
    else if (!l_strcasecmp(pos, "Medium Colors"))
      global.options.colored_nicks = 2;
    else
      global.options.colored_nicks = 1;
  } else {
    global.options.colored_nicks = 0;
  }
  temp = lookup_widget(win, "checkbutton89");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    temp = lookup_widget(win, "entry156");
    pos = gtk_entry_get_text(GTK_ENTRY(temp));
    if (!l_strcasecmp(pos, "Dark Colors"))
      global.options.colored_nicks2 = 3;
    else if (!l_strcasecmp(pos, "Medium Colors"))
      global.options.colored_nicks2 = 2;
    else
      global.options.colored_nicks2 = 1;
  } else {
    global.options.colored_nicks2 = 0;
  }

  temp = lookup_widget(win, "entry108");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  global.options.timestamps = timestamp2int(pos);

  setup_main_tab();

  // saving color scheme
  on_button100_clicked(NULL, NULL);

  // setting up new color scheme
  temp = lookup_widget(win, "combo_entry15");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));

  scheme = scheme_load(pos);
  if (scheme) {
    scheme_destroy(global.scheme);
    global.scheme = scheme;
  } else {
    client_message("Message", "Loading scheme [%s] failed!", pos);
  }

  // Advanced
  temp = lookup_widget(win, "checkbutton65");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) {
    if (!global.options.check_version)
      global.options.check_version = 1;
  } else {
    global.options.check_version = 0;
  }

  temp = lookup_widget(win, "checkbutton38");
  global.options.allow_dcc =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));
  temp = lookup_widget(win, "checkbutton82");
  global.options.access_transferring =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  temp = lookup_widget(win, "checkbutton54");
  global.options.dummy_md5 =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp));

  global.options.logging = 0;
  temp = lookup_widget(win, "checkbutton75");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.logging |= (1<<LOG_PROTOCOL);
  temp = lookup_widget(win, "checkbutton76");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.logging |= (1<<LOG_MESSAGE);
  temp = lookup_widget(win, "checkbutton77");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.logging |= (1<<LOG_CHANNEL);
  temp = lookup_widget(win, "checkbutton78");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.logging |= (1<<LOG_PRIVATE);
  temp = lookup_widget(win, "checkbutton79");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.logging |= (1<<LOG_OTHER);
  temp = lookup_widget(win, "checkbutton80");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.logging |= (1<<LOG_OPERATOR);
  temp = lookup_widget(win, "checkbutton81");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.logging |= (1<<LOG_GLOBAL);
  temp = lookup_widget(win, "spinbutton34");
  global.options.log_expire =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "spinbutton73");
  global.network.transfer_delay =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  temp = lookup_widget(win, "spinbutton80");
  global.limit.max_seek_add =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "combo_entry27");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  global.options.browser = browser2int(pos);

  temp = lookup_widget(win, "radiobutton5");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.server_motd = 0;
  temp = lookup_widget(win, "radiobutton4");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp)))
    global.options.server_motd = 1;

  temp = lookup_widget(win, "spinbutton68");
  global.server_paned =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "spinbutton_queuelimit");
  global.options.autoconnect_sendqueue_limit =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));

  temp = lookup_widget(win, "spinbutton77");
  global.options.max_chat_buffer =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(temp));
  
  // warn again if there is a invalid incomplete/download folder
  global.path_warned = 0;
  
  ban_networks_clear();
  temp = lookup_widget(win, "clist41");
  for (i1 = 0; i1 < GTK_CLIST(temp)->rows; i1++) {
    bannetworks_t* bn;
    bn = gtk_clist_get_row_data(GTK_CLIST(temp), i1);
    if (bn) ban_networks_add(bn);
  }
  ban_networks_save();

  temp = lookup_widget(win, "entry142");
  pos = gtk_entry_get_text(GTK_ENTRY(temp));
  if (global.external_handler)
    l_free(global.external_handler);
  global.external_handler = 0;
  if (pos && *pos)
    global.external_handler = l_strdup(pos);

  for (i1 = 0; i1 < EVENT_NUMBER; i1++) {
    char text[100];
    sprintf(text, "eventbutton%d", i1);
    temp = lookup_widget(win, text);
    if (temp) {
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(temp))) 
	global.external_events |= (1<<i1);
      else
	global.external_events &= ~(1<<i1);
    }
  }

  if (lib_compare_folder(global.lib, temp_lib)) {
    if (!global.lib) global.lib = lib_create_new("shared.list");
    shared_folder_destroy(global.lib->shared_folder);
    global.lib->shared_folder = temp_lib->shared_folder;
    temp_lib->shared_folder = NULL;
    lib_refresh(global.lib);
  }
  lib_destroy(temp_lib);
      
  write_rc();
}

void preferences_goto(int section)
{
  GtkCList *clist;

  if (!global.options_win) {
    on_preferences_activate(NULL, NULL);
  }
  if (!global.options_win)
    return;

  clist = GTK_CLIST(lookup_widget(global.options_win, "ctree2"));
  gtk_clist_select_row(clist, section, 0);
}

void on_toggle_pipe(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  int value;
  GtkWidget *temp;
  int no = (int) user_data;

  temp = lookup_widget(global.options_win, "button360");
  value = (int) gtk_object_get_data(GTK_OBJECT(temp), "value");
  value = value ^ no;
  gtk_object_set_data(GTK_OBJECT(temp), "value", (gpointer) value);
}

GtkWidget *create_pipe_popup(int val) {
  GtkWidget *mode_popup;
  GtkAccelGroup *mode_popup_accels;
  GtkWidget *mode;

  mode_popup = gtk_menu_new();
  gtk_object_set_data(GTK_OBJECT(mode_popup), "mode_popup", mode_popup);
  mode_popup_accels =
      gtk_menu_ensure_uline_accel_group(GTK_MENU(mode_popup));

  mode = gtk_check_menu_item_new_with_label("Away Logging");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & PIPE_AWAY_LOG)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe,
		     (gpointer) PIPE_AWAY_LOG);

  mode = gtk_check_menu_item_new_with_label("Private Messages");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & PIPE_PRIVATE)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe,
		     (gpointer) PIPE_PRIVATE);

  mode = gtk_check_menu_item_new_with_label("Channel Operator Message");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & PIPE_CHWALLOP)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe,
		     (gpointer) PIPE_CHWALLOP);

  mode = gtk_check_menu_item_new_with_label("Operator Messages");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & PIPE_WALLOP)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe,
		     (gpointer) PIPE_WALLOP);

  mode = gtk_check_menu_item_new_with_label("Global Messages");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & PIPE_GLOBAL)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe,
		     (gpointer) PIPE_GLOBAL);

  mode = gtk_check_menu_item_new_with_label("Server Messages");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & PIPE_SERVER)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe,
		     (gpointer) PIPE_SERVER);

  mode = gtk_check_menu_item_new_with_label("Download Messages");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & PIPE_DOWNLOAD)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe,
		     (gpointer) PIPE_DOWNLOAD);

  mode = gtk_check_menu_item_new_with_label("Upload Messages");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & PIPE_UPLOAD)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe,
		     (gpointer) PIPE_UPLOAD);

  return mode_popup;
}

void on_toggle_pipe2(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  int value;
  GtkWidget *temp;
  int no = (int) user_data;

  temp = lookup_widget(global.options_win, "button361");
  value = (int) gtk_object_get_data(GTK_OBJECT(temp), "value");
  value = value ^ no;
  gtk_object_set_data(GTK_OBJECT(temp), "value", (gpointer) value);
}


GtkWidget *create_pipe2_popup(int val)
{
  GtkWidget *mode_popup;
  GtkAccelGroup *mode_popup_accels;
  GtkWidget *mode;

  mode_popup = gtk_menu_new();
  gtk_object_set_data(GTK_OBJECT(mode_popup), "mode_popup", mode_popup);
  mode_popup_accels =
      gtk_menu_ensure_uline_accel_group(GTK_MENU(mode_popup));

  mode = gtk_check_menu_item_new_with_label("Ignored messages");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & NOPIPE_IGNORE)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe2,
		     (gpointer) NOPIPE_IGNORE);

  mode = gtk_check_menu_item_new_with_label("Download Messages");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & NOPIPE_DOWNLOAD)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe2,
		     (gpointer) NOPIPE_DOWNLOAD);

  mode = gtk_check_menu_item_new_with_label("Upload Messages");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & NOPIPE_UPLOAD)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe2,
		     (gpointer) NOPIPE_UPLOAD);

  mode = gtk_check_menu_item_new_with_label("Incoming Protocol");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & NOPIPE_PROTOCOL1)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe2,
		     (gpointer) NOPIPE_PROTOCOL1);

  mode = gtk_check_menu_item_new_with_label("Outgoing Protocol");
  gtk_widget_show(mode);
  gtk_container_add(GTK_CONTAINER(mode_popup), mode);
  if (val & NOPIPE_PROTOCOL2)
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mode), TRUE);
  gtk_signal_connect(GTK_OBJECT(mode), "activate",
		     (GtkSignalFunc) on_toggle_pipe2,
		     (gpointer) NOPIPE_PROTOCOL2);

  return mode_popup;
}

void on_dir_select343(gchar * dir) {
  GtkWidget *temp;
  GtkWidget *entry;
  char *text;
  int row;

  if (!global.options_win) return;
  if (!dir || *dir == 0) return;

  if (dir[strlen(dir) - 1] == DIR_SEP) dir[strlen(dir) - 1] = 0;

  entry = lookup_widget(global.options_win, "combo_entry29");
  text = gtk_entry_get_text(GTK_ENTRY(entry));

  temp = lookup_widget(global.options_win, "clist19");

  strcpy(tstr[0], text);
  strcpy(tstr[1], dir);
  row = gtk_clist_append(GTK_CLIST(temp), list);
}

