/* Copyright (C) 2000/2001 sgop@users.sourceforge.net
   This is free software distributed under the terms of the
   GNU Public License.  See the file COPYING for details. */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/time.h>
#include <strings.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>

#include "lopster.h"
#include "support.h"
#include "md5.h"
#include "connection.h"
#include "commands.h"
#include "interface.h"
#include "callbacks.h"
#include "scheme.h"
#include "handler.h"
#include "log.h"
#include "global.h"
#include "chat.h"
#include "search.h"
#include "transfer.h"
#include "hotlist.h"
#include "resume.h"
#include "server.h"
#include "dialog.h"
#include "preferences.h"
#include "utils.h"

int get_color(char chr)
{
  switch (chr) {
  case 'r':
    return 4;
  case 'b':
    return 2;
  case 'g':
    return 3;
  case 'c':
    return 10;
  case 'y':
    return 8;
  case 'Y':
    return 5;
  case 'k':
    return 1;
  default:
    return -1;
  }
}

void text_print_text(GtkText * widget, char *fmt, ...)
{
  char *pos;
  char text2[2048];
  char *text;
  GdkColor *color = NULL;
  int temp;
  va_list ap;

  va_start(ap, fmt);
  vsprintf(text2, fmt, ap);
  va_end(ap);

  text = text2;
  while ((pos = strchr(text, '$')) != NULL) {
    gtk_text_insert(widget, NULL, color, NULL, text, pos - text);
    text = pos;
    temp = get_color(pos[1]);
    if (temp >= 0) {
      color = &global.color_table[temp];
      text += 2;
    } else {
      gtk_text_insert(widget, NULL, color, NULL, text, 1);
      text++;
    }
  }
  gtk_text_insert(widget, NULL, color, NULL, text, strlen(text));
}

void port_dialog(char *message) {
  GtkWidget *win;
  GtkText *text;

  win = create_information_win();
  gtk_widget_show(win);
  gtk_window_set_title(GTK_WINDOW(win), "Bind Error");
  text = GTK_TEXT(lookup_widget(win, "text15"));
  gtk_text_set_word_wrap(text, 1);

  text_print_text(text,
		  "$r-------------------------\n Information\n-------------------------\n\n");
  text_print_text(text, "$kCould not set up data port: $b%s.\n",
		  message);
  text_print_text(text, "$kMaybe other programs use theses ports.\n");
  text_print_text(text,
		  "$kAt the moment the data port was set to $b0$k, so you cannot download from users who set their port also to 0.\n");
  text_print_text(text,
		  "$kIf you do not want this, choose another port at $bPreferences->General->Port for Uploading Files $k and deactivate the $bFirewall $kbutton.\n");
}

void changes_dialog() {
  GtkWidget *win;
  GtkText *text;

  win = create_information_win();
  gtk_window_set_title(GTK_WINDOW(win), "Changes since Lopster 1.0.1");
  text = GTK_TEXT(lookup_widget(win, "text15"));
  gtk_text_set_word_wrap(text, 1);

  text_print_text(text, "$g-----------------------------\nMajor changes since version 1.0.1\n-----------------------------\n");

  text_print_text(text, "\n$k* $rMost important\n");
  text_print_text(text, "$k - $bMulti server support $k- connecting to more than one server\n");
  text_print_text(text, "$k - $bMulti source support $k- downloading a file from more than one source\n");

  text_print_text(text, "\n$k* $rServers\n");
  text_print_text(text, "$k - $bCompletely new server/network handling $k- create your own network groups\n");
  text_print_text(text, "$k - $bBasic IRC support $k- just create a network with type IRC and add a server there\n");
  text_print_text(text, "$k - $bCompression support on opennap-ng servers $k- ./configure --with-zlib\n");
  text_print_text(text, "$k - $bThread support $k- ./configure --with-pthread to get rid of gui freezes\n");

  text_print_text(text, "\n$k* $rLibrary and browse\n");
  text_print_text(text, "$k - $bQuick search $k- quickly find files in your library or browses\n");
  text_print_text(text, "$k - $bNew layout $k- two window view for direcotries and files\n");
  text_print_text(text, "$k - $bDirect browses handled like uploads $k- They are bandwidth restricted, you can abort them\n");
  text_print_text(text, "$k - $bBrowses are saved to disc $k- You can view the files offline and even queue files of offline users for downloading\n");

  text_print_text(text, "\n$k* $rSearch\n");
  text_print_text(text, "$k - $bTree view $k- Same files, same node\n");
  text_print_text(text, "$k - $bMore options $k- more power\n");

  text_print_text(text, "\n$k* $rChat\n");
  text_print_text(text, "$k - $bLots of right click tokens $k- Networks, channels, nicknames, files, urls. Try it!\n");
  text_print_text(text, "$k - $bLimit for chat buffers\n");

  text_print_text(text, "\n$k* $rTransfers\n");
  text_print_text(text, "$k - $bDownload layout changes $k- it is configurable - check prefs\n");
  text_print_text(text, "$k - $bDownload clone detection\n");
  text_print_text(text, "$k - $bAdvanced connection between Lopster users $k- You can download several segments with one single TCP connection\n");

  text_print_text(text, "\n$k* $rStatistic\n");
  text_print_text(text, "$k - $bNew layout $k- more options for the bandwidth graph (click)\n");
  
  text_print_text(text, "\n$k* $rAs always:\n");
  text_print_text(text, "$k - Lots of minor changes, lots of bug fixes\n");

  text_print_text(text, "\n$rHave Fun!!!  Sgop\n");
  gtk_my_widget_show(win);
}

GtkWidget *create_info_win(char *text, char **buttons,
			   GtkSignalFunc * func)
{
  GtkWidget *delete_win;
  GtkWidget *frame172;
  GtkWidget *vbox;
  GtkWidget *vbox1;
  GtkWidget *hbox263;
  GtkWidget *frame214;
  GtkWidget *pixmap30;
  GtkWidget *label435;
  GtkWidget *hseparator24;
  GtkWidget *frame173;
  GtkWidget *hbox262;
  GtkWidget *button170;
  int i1;

  delete_win = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(delete_win), "Information");
  gtk_window_set_policy(GTK_WINDOW(delete_win), FALSE, FALSE, FALSE);

  frame172 = gtk_frame_new(NULL);
  gtk_widget_show(frame172);
  gtk_container_add(GTK_CONTAINER(delete_win), frame172);
  gtk_container_set_border_width(GTK_CONTAINER(frame172), 5);

  vbox = gtk_vbox_new(FALSE, 5);
  gtk_widget_show(vbox);
  gtk_container_add(GTK_CONTAINER(frame172), vbox);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

  hbox263 = gtk_hbox_new(FALSE, 10);
  gtk_widget_show(hbox263);
  gtk_box_pack_start(GTK_BOX(vbox), hbox263, TRUE, TRUE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(hbox263), 12);

  vbox1 = gtk_vbox_new(FALSE, 5);
  gtk_widget_show(vbox1);
  gtk_box_pack_start(GTK_BOX(hbox263), vbox1, FALSE, FALSE, 0);

  frame214 = gtk_frame_new(NULL);
  gtk_widget_show(frame214);
  gtk_box_pack_start(GTK_BOX(vbox1), frame214, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type(GTK_FRAME(frame214), GTK_SHADOW_IN);

  pixmap30 = create_pixmap(delete_win, "info.xpm");
  gtk_widget_show(pixmap30);
  gtk_container_add(GTK_CONTAINER(frame214), pixmap30);

  label435 = gtk_label_new(text);
  gtk_widget_show(label435);
  gtk_box_pack_start(GTK_BOX(hbox263), label435, FALSE, FALSE, 0);
  gtk_label_set_justify(GTK_LABEL(label435), GTK_JUSTIFY_LEFT);

  hseparator24 = gtk_hseparator_new();
  gtk_widget_show(hseparator24);
  gtk_box_pack_start(GTK_BOX(vbox), hseparator24, FALSE, FALSE, 0);

  frame173 = gtk_frame_new(NULL);
  gtk_widget_show(frame173);
  gtk_box_pack_start(GTK_BOX(vbox), frame173, FALSE, FALSE, 0);
  gtk_widget_set_usize(frame173, -2, 41);
  gtk_frame_set_shadow_type(GTK_FRAME(frame173), GTK_SHADOW_IN);

  hbox262 = gtk_hbox_new(TRUE, 5);
  gtk_widget_show(hbox262);
  gtk_container_add(GTK_CONTAINER(frame173), hbox262);
  gtk_container_set_border_width(GTK_CONTAINER(hbox262), 5);

  gtk_signal_connect(GTK_OBJECT(delete_win), "destroy",
		     GTK_SIGNAL_FUNC(gtk_widget_destroy), delete_win);

  i1 = 0;
  while (buttons[i1]) {
    button170 = gtk_button_new_with_label(buttons[i1]);
    gtk_widget_show(button170);
    gtk_box_pack_start(GTK_BOX(hbox262), button170, TRUE, TRUE, 0);
    gtk_signal_connect(GTK_OBJECT(button170), "clicked",
		       func[i1], delete_win);
    i1++;
  }
  return delete_win;
}

void on_close_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}

void on_open_pref_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
  preferences_goto(3);
}

void openfile_dialog(char *text)
{
  GtkSignalFunc func[3];
  char *buttons[3];
  GtkWidget *temp;

  func[0] = (GtkSignalFunc) on_close_clicked;
  func[1] = (GtkSignalFunc) on_open_pref_clicked;
  func[2] = NULL;
  buttons[0] = l_strdup("Close");
  buttons[1] = l_strdup("Setup Applications");
  buttons[2] = NULL;

  temp = create_info_win(text, buttons, func);
  gtk_widget_show(temp);

  l_free(buttons[0]);
  l_free(buttons[1]);
}

void on_download1_pref_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
  preferences_goto(4);
}

void on_download2_pref_clicked(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
  preferences_goto(5);
}

void download_dialog(char *filename, int mime) {
  GtkSignalFunc func[4];
  char *buttons[4];
  GtkWidget *temp;
  char *text;

  if (global.path_warned) return;

  text =
    l_strdup_printf("Download of file %s failed.\nEither the incomplete path was not set or\nno valid path was specified for mime type %s.\n",
		    filename, MimeNames(mime, 2));
  func[0] = (GtkSignalFunc) on_close_clicked;
  func[1] = (GtkSignalFunc) on_download1_pref_clicked;
  func[2] = (GtkSignalFunc) on_download2_pref_clicked;
  func[3] = NULL;
  buttons[0] = l_strdup("Close");
  buttons[1] = l_strdup("Set incomplete path");
  buttons[2] = l_strdup("Set download path");
  buttons[3] = NULL;

  temp = create_info_win(text, buttons, func);
  gtk_widget_show(temp);

  l_free(buttons[0]);
  l_free(buttons[1]);
  l_free(buttons[2]);
  global.path_warned = 1;
}

void
on_delete_selected1_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  socket_t *socket;

  ctree = GTK_CTREE(global.popup_list);
  row_list = GTK_CLIST(ctree)->selection;

  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent != NULL) {
      socket = (socket_t *) gtk_ctree_node_get_row_data(ctree, node);
      socket_end(socket, S_DELETE);
    }
  }
  if (user_data)
    gtk_widget_destroy(GTK_WIDGET(user_data));
}

void delete_dialog(char *text)
{
  GtkSignalFunc func[4];
  char *buttons[4];
  GtkWidget *temp;

  if (global.options.confirm_delete) {
    func[0] = (GtkSignalFunc) on_delete_selected1_activate;
    func[1] = (GtkSignalFunc) on_close_clicked;
    func[2] = NULL;
    buttons[0] = l_strdup("Do it!");
    buttons[1] = l_strdup("Cancel");
    buttons[2] = NULL;

    temp = create_info_win(text, buttons, func);
    gtk_widget_show(temp);

    l_free(buttons[0]);
    l_free(buttons[1]);
  } else {
    on_delete_selected1_activate(NULL, NULL);
  }
}

void
on_delete_selected2_activate(GtkMenuItem * menuitem ATTR_UNUSED, gpointer user_data)
{
  GtkCTree *ctree;
  GList *row_list;
  GtkCTreeNode *node;
  resume_t *resume;
  GList* work = NULL;
  ctree = GTK_CTREE(global.popup_list);

  row_list = GTK_CLIST(ctree)->selection;
  while (row_list) {
    node = GTK_CTREE_NODE(row_list->data);
    row_list = row_list->next;
    if (GTK_CTREE_ROW(node)->parent == NULL) {
      resume = gtk_ctree_node_get_row_data(ctree, node);
      work = g_list_append(work, resume);
    }
  }
  for (row_list = work; row_list; row_list = row_list->next) {
    resume = row_list->data;
    resume_remove(resume);
  }
  if (work) g_list_free(work);

  if (user_data) gtk_widget_destroy(GTK_WIDGET(user_data));
}

void resume_delete_dialog(char *text)
{
  GtkSignalFunc func[4];
  char *buttons[4];
  GtkWidget *temp;

  if (global.options.confirm_delete) {
    func[0] = (GtkSignalFunc) on_delete_selected2_activate;
    func[1] = (GtkSignalFunc) on_close_clicked;
    func[2] = NULL;
    buttons[0] = l_strdup("Do it!");
    buttons[1] = l_strdup("Cancel");
    buttons[2] = NULL;

    temp = create_info_win(text, buttons, func);
    gtk_widget_show(temp);

    l_free(buttons[0]);
    l_free(buttons[1]);
  } else {
    on_delete_selected2_activate(NULL, NULL);
  }
}

void on_new_version_remember(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
  global.options.check_version = 1;
}

void on_new_version_noticed(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
  global.options.check_version = 2;
}

void new_version_dialog(char *text)
{
  GtkSignalFunc func[3];
  char *buttons[3];
  GtkWidget *temp;
  char *str;

  func[0] = (GtkSignalFunc) on_new_version_remember;
  func[1] = (GtkSignalFunc) on_new_version_noticed;
  func[2] = NULL;
  buttons[0] = l_strdup("Remember next time");
  buttons[1] = l_strdup("Noticed!");
  buttons[2] = NULL;

  str =
      l_strdup_printf("Lopster %s is available NOW!\nCheck out lopster.sourceforge.net!",
		      text);
  temp = create_info_win(str, buttons, func);
  gtk_widget_show(temp);
  l_free(str);

  l_free(buttons[0]);
  l_free(buttons[1]);
}

void on_check_version_close(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}

void check_version_dialog(char *text)
{
  GtkSignalFunc func[2];
  char *buttons[2];
  GtkWidget *temp;
  char *str;

  func[0] = (GtkSignalFunc) on_check_version_close;
  func[1] = NULL;
  buttons[0] = l_strdup("Close");
  buttons[1] = NULL;

  if (!version_is_up_to_date(text)) {
    str =
	l_strdup_printf("Latest release is %s\nYour version seems to be outdated!\n",
			text);
  } else {
    str =
      l_strdup_printf("Latest Lopster is %s\nYour version is up to date!\n",
		      text);
  }
  temp = create_info_win(str, buttons, func);
  gtk_widget_show(temp);
  l_free(str);

  l_free(buttons[0]);
}

void on_info_close(GtkButton * button ATTR_UNUSED, gpointer user_data)
{
  gtk_widget_destroy(GTK_WIDGET(user_data));
}

void info_dialog(char *text) {
  GtkSignalFunc func[2];
  char *buttons[2];
  GtkWidget *temp;

  func[0] = (GtkSignalFunc) on_info_close;
  func[1] = NULL;
  buttons[0] = l_strdup("Close");
  buttons[1] = NULL;

  temp = create_info_win(text, buttons, func);
  gtk_widget_show(temp);

  l_free(buttons[0]);
}
