/*
 * Copyright (C) 2014 Canonical Ltd.
 *
 * Contact: Alberto Mardegan <alberto.mardegan@canonical.com>
 *
 * This file is part of OnlineAccountsPlugin.
 *
 * OnlineAccountsClient is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * OnlineAccountsClient is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with OnlineAccountsClient.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "plugin.h"

#include "qml-loopback-server.h"

#include <OnlineAccountsPlugin/application-manager.h>
#include <OnlineAccountsPlugin/request-handler.h>
#include <QDebug>
#include <QQmlComponent>
#include <QQmlContext>
#include <QQmlEngine>

using namespace OnlineAccountsPlugin;

void Plugin::initializeEngine(QQmlEngine *engine, const char *uri)
{
    Q_UNUSED(uri);

    QQmlContext* context = engine->rootContext();
    context->setContextProperty("ApplicationManager",
                                OnlineAccountsUi::ApplicationManager::instance());
}

void Plugin::registerTypes(const char *uri)
{
    qDebug() << Q_FUNC_INFO << uri;

    qmlRegisterType<SignOnUi::RequestHandler>(uri, 1, 0, "RequestHandler");
    qmlRegisterType<QmlLoopbackServer>(uri, 1, 0, "LoopbackServer");
}
