#!/usr/bin/python

################################################################################
##3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
##      10        20        30        40        50        60        70        80
##
## Info:
##    Example of how to use libnotify correctly and at the same time comply to
##    the new jaunty notification spec (read: visual guidelines)
##
## Run:
##    chmod +x example.py
##    ./example.py
##
## Copyright 2012 Canonical Ltd.
##
## Author:
##    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
##
## This program is free software: you can redistribute it and/or modify it
## under the terms of the GNU General Public License version 3, as published
## by the Free Software Foundation.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranties of
## MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
## PURPOSE.  See the GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License along
## with this program.  If not, see <http://www.gnu.org/licenses/>.
##
################################################################################

import pynotify

# even in Python this is globally nasty :), do something nicer in your own code
capabilities = {'actions':                              False,
        'body':                                 False,
        'body-hyperlinks':                      False,
        'body-images':                          False,
        'body-markup':                          False,
        'icon-multi':                           False,
        'icon-static':                          False,
        'sound':                                False,
        'sound-file':                           False,
        'suppress-sound':                       False,
        'image/svg+xml':                        False,
        'urgency':                              False,
        'value':                                False,
        'x-lomiri-value-bar-tint':           False,
        'x-lomiri-private-synchronous':      False,
        'x-lomiri-private-icon-only':        False,
        'x-lomiri-truncation':               False,
        'x-lomiri-snap-decisions':             False,
        'x-lomiri-snap-decisions-timeout':   False,
        'x-lomiri-snap-decisions-swipe':     False,
        'x-lomiri-switch-to-application':    False,
        'x-lomiri-secondary-icon':           False,
        'x-lomiri-private-affirmative-tint': False,
        'x-lomiri-private-rejection-tint':   False,
        'x-lomiri-private-menu-model':       False,
        'x-lomiri-non-shaped-icon':          False}

def initCaps ():
    caps = pynotify.get_server_caps ()
    if caps is None:
            print "Failed to receive server caps."
        sys.exit (1)

    for cap in caps:
        capabilities[cap] = True

def printCaps ():
    info = pynotify.get_server_info ()
    print "Name:          " + info["name"]
    print "Vendor:        " + info["vendor"]
    print "Version:       " + info["version"]
    print "Spec. Version: " + info["spec-version"]

    caps = pynotify.get_server_caps ()
    if caps is None:
            print "Failed to receive server caps."
        sys.exit (1)

    print "Supported capabilities/hints:"
    if capabilities['actions']:
        print "\tactions"
    if capabilities['body']:
        print "\tbody"
    if capabilities['body-hyperlinks']:
        print "\tbody-hyperlinks"
    if capabilities['body-images']:
        print "\tbody-images"
    if capabilities['body-markup']:
        print "\tbody-markup"
    if capabilities['icon-multi']:
        print "\ticon-multi"
    if capabilities['icon-static']:
        print "\ticon-static"
    if capabilities['sound']:
        print "\tsound"
    if capabilities['sound-file']:
        print "\tsound-file"
    if capabilities['suppress-sound']:
        print "\tsuppress-sound"
    if capabilities['urgency']:
        print "\turgency"
    if capabilities['value']:
        print "\tvalue"
    if capabilities['x-lomiri-value-bar-tint']:
        print "\tx-lomiri-value-bar-tint"
    if capabilities['image/svg+xml']:
        print "\timage/svg+xml"
    if capabilities['x-lomiri-private-synchronous']:
        print "\tx-lomiri-private-synchronous"
    if capabilities['x-lomiri-private-icon-only']:
        print "\tx-lomiri-private-icon-only"
    if capabilities['x-lomiri-truncation']:
        print "\tx-lomiri-truncation"
    if capabilities['x-lomiri-snap-decisions']:
        print "\tx-lomiri-snap-decisions"
    if capabilities['x-lomiri-snap-decisions-timeout']:
        print "\tx-lomiri-snap-decisions-timeout"
    if capabilities['x-lomiri-snap-decisions-swipe']:
        print "\tx-lomiri-snap-decisions-swipe"
    if capabilities['x-lomiri-switch-to-application']:
        print "\tx-lomiri-switch-to-application"
    if capabilities['x-lomiri-secondary-icon']:
        print "\tx-lomiri-secondary-icon"
    if capabilities['x-lomiri-private-affirmative-tint']:
        print "\tx-lomiri-private-affirmative-tint"
    if capabilities['x-lomiri-private-rejection-tint']:
        print "\tx-lomiri-private-rejection-tint"
    if capabilities['x-lomiri-private-menu-model']:
        print "\tx-lomiri-private-menu-model"
    if capabilities['x-lomiri-non-shaped-icon']:
        print "\tx-lomiri-non-shaped-icon"

    print "Notes:"
    if info["name"] == "notify-osd":
        print "\tx- and y-coordinates hints are ignored"
        print "\texpire-timeout is ignored"
        print "\tbody-markup is accepted but filtered"
    else:
        print "\tnone"

def closedHandler (notification, loop):
    print "\"closed\"-handler called"
    loop.quit ()
