Running Autopilot tests
=======================

Lomiri Clock App follows a test driven development where autopilot tests are
run before every merge into trunk. If you are submitting your bugfix/patch to
the clock app, please follow the following steps below to ensure that all tests
pass before proposing a merge request.

If you are looking for more info about Autopilot or writing AP tests for the
clock app, here are some useful links to help you:

* https://developer.ubuntu.com/start/quality
* https://developer.ubuntu.com/api/autopilot/python/1.5.0/

For help and options on running tests, see:

* https://developer.ubuntu.com/en/start/platform/guides/running-autopilot-tests/

Prerequisites
=============

Install the following autopilot packages required to run the tests,
    $ sudo apt-get install python3-autopilot libautopilot-qt lomiri-ui-toolkit-autopilot python3-autopilot-vis

Running tests on the desktop
============================

Using terminal:

*  Get the clock app code,
    $ git clone git@gitlab.com:ubports/development/apps/lomiri-clock-app.git

*  Build the clock app,
    $ mkdir builddir && cd builddir
    $ cmake .. && cmake --build . -- -j 3
    $ cd ..

*  Navigate to the tests/autopilot directory.
    $ cd tests/autopilot

*  run all tests.
    $ autopilot3 run -vv lomiri_clock_app

    to list all tests:
    $ autopilot3 list lomiri_clock_app

    To run only one test (for instance: test_add_single_type_alarm_must_add_to_alarm_list in TestAlarm.py):
    $ autopilot3 run -vv lomiri_clock_app.tests.test_alarm.TestAlarm.test_add_single_type_alarm_must_add_to_alarm_list

    Debugging tests using autopilot vis
    $ autopilot3 launch -i Qt qmlscene ../../app/lomiri-clock-app.qml  -I ../../builddir/backend/
    $ autopilot3 vis


Running tests on device or emulator
===================================

Using autopkg:

1. navigate to the directory where the lomiri-clock-app branch is and run:
  $ adt-run lomiri-clock-app --click=clock.ubports --- ssh -s adb -p YOURPASSWORD
