/*
 * Copyright (C) 2015-2016 Canonical Ltd
 *
 * This file is part of Lomiri Clock App
 *
 * Lomiri Clock App is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * Lomiri Clock App is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.12
import QtTest 1.0
import Stopwatch 1.0
import Lomiri.Components 1.3
import "../../app/stopwatch"

TestCase {
    id: stopwatchFormatTimeTest
    name: "StopwatchFormatTimeLibrary"

    StopwatchFormatTime {
        id: stopwatchFormatTime
    }

    /*
     This test checks if the milliseconds is returned correctly in the format
     mmm (string length 3)
    */
    function test_returnMillisecond() {
        var result
        result = stopwatchFormatTime.millisToString(400)
        compare(result, "400", "Milliseconds not properly converted to the format required")
        result = stopwatchFormatTime.millisToString(4)
        compare(result, "004", "Milliseconds not properly converted to the format required")
    }

    /*
     This test checks if the time (in milliseconds) to converted to hh:mm:ss
     correctly.
    */
    function test_convertTimeInMillisecondsToString() {
        var timeInMilliseconds = 1123000, result
        result = stopwatchFormatTime.millisToTimeString(timeInMilliseconds, true)
        compare(result, "00:18:43", "Time not properly converted from milliseconds to hh:mm:ss")
        result = stopwatchFormatTime.millisToTimeString(timeInMilliseconds, false)
        compare(result, "18:43", "Time not properly converted from milliseconds to mm:ss")
    }

    /*
     This test checks if the zero prefix is added correctly to ensure that a
     string is always of the specified string length.
    */
    function test_zeroPrefixAddedCorrectly() {
        var str = "32", result
        result = stopwatchFormatTime.addZeroPrefix(str, 2)
        compare(result, "32", "Zero prefix not added correctly")
        result = stopwatchFormatTime.addZeroPrefix(str, 3)
        compare(result, "032", "Zero prefix not added correctly")
        result = stopwatchFormatTime.addZeroPrefix(str, 4)
        compare(result, "0032", "Zero prefix not added correctly")
    }
}
