/*
 * Copyright (C) 2015-2016 Canonical Ltd
 *
 * This file is part of Lomiri Clock App
 *
 * Lomiri Clock App is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * Lomiri Clock App is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QtQml>
#include <QtQml/QQmlContext>
#include "backend.h"
#include "geolocation.h"
#include "datetime.h"
#include "timezonemodel.h"
#include "generictimezonemodel.h"
#include "geonamestimezonemodel.h"
#include "statictimezonemodel.h"

void BackendPlugin::registerTypes(const char *uri)
{
    Q_ASSERT(uri == QLatin1String("WorldClock"));

    qmlRegisterType<GeoLocation>(uri, 1, 0, "GeoLocation");
    qmlRegisterType<DateTime>(uri, 1, 0, "DateTime");
    qmlRegisterType<GenericTimeZoneModel>(uri, 1, 0, "GenericTimeZoneModel");
    qmlRegisterType<GeonamesTimeZoneModel>(uri, 1, 0, "GeonamesTimeZoneModel");
    qmlRegisterType<StaticTimeZoneModel>(uri, 1, 0, "StaticTimeZoneModel");
}

void BackendPlugin::initializeEngine(QQmlEngine *engine, const char *uri)
{
    QQmlExtensionPlugin::initializeEngine(engine, uri);
}
