/*
 * logapp.h: Logapp main header file
 *
 *
 * Copyright (C) 2007-2009 Michael Brunner <mibru@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * General Public License for more details.
 */

#ifndef __LOGAPP_H__
#define __LOGAPP_H__

#define VERSION		"0.12"
#define EXECUTABLE	"logapp"
#define AUTHOR		"Michael Brunner <mibru@gmx.de>"

typedef enum { MESSAGE, WARNING, ERROR } t_printtype;
#define message(x...)	print(MESSAGE, x)
#define warning(x...)	print(WARNING, x)
#define error(x...)	print(ERROR, x)
#define STRING_WARNING	" warning: "
#define STRING_ERROR	" error: "
void print(t_printtype type, const char *format,...);
void error_outofmemory(void);

#define CONFIG_SUPPORT_PTY	1
#define CONFIG_USE_THREADS	1

#endif /* __LOGAPP_H__ */
