#!/usr/bin/perl
# This script configures XFree86 (sarge version 4.3.x)
# The difference of the woody script is in some of the debconf 
# values, otherwise they are similar.

use strict;
use warnings;

# We use preseed() helper subroutine so we have to include
# its definition
require '/usr/lib/localization-config/common/langmap.pl';
require '/usr/lib/localization-config/common/common.pl';
require '/usr/lib/localization-config/common/log.pl';
require '/usr/lib/localization-config/common/db_get.pl';

my %lang_console_map = (
    'be2-latin1'            => { XKBD => 'Belgian' },
    'bg'                    => { XKBD => 'Bulgarian' },
    'br-abnt2'              => { XKBD => 'Brazilian' },
    'br-latin1'             => { XKBD => 'Brazilian (latin1)' },
    'by'                    => { XKBD => 'Belarussian' },
    'cf'                    => { XKBD => 'French (CA)' },
    'croat'                 => { XKBD => 'Bosnian' },
    'cz-lat2'               => { XKBD => 'Czech' },
    'de-latin1-nodeadkeys'  => { XKBD => 'German (ndk)' },
    'dk-latin1'             => { XKBD => 'Danish' },
    'dvorak'                => { XKBD => 'Dvorak' },
    'es'                    => { XKBD => 'Spanish' },
    'et'                    => { XKBD => 'Estonian' },
    'fi-latin1'             => { XKBD => 'Finnish' },
    'fr_CH-latin1'          => { XKBD => 'Swiss (FR)' },
    'fr-latin9'             => { XKBD => 'French' },
    'gr'                    => { XKBD => 'Greek' },
    'hebrew'                => { XKBD => 'Hebrew' },
    'hu'                    => { XKBD => 'Hungarian' },
    'is-latin1'             => { XKBD => 'Icelandic' },
    'it'                    => { XKBD => 'Italian' },
    'jp106'                 => { XKBD => 'Japanese' },
    'la-latin1'             => { XKBD => 'Latin American' },
    'lt'                    => { XKBD => 'Lithuanian' },
    'lv-latin4'             => { XKBD => 'Latvian' },
    'mk'                    => { XKBD => 'Macedonian' },
    'nl'                    => { XKBD => 'Dutch (NL)' },
    'no-latin1'             => { XKBD => 'Norwegian' },
    'pl'                    => { XKBD => 'Polish' },
    'pt-latin1'             => { XKBD => 'Portuguese' },
    'ro'                    => { XKBD => 'Romanian' },
    'ru'                    => { XKBD => 'Russian' },
    'se-latin1'             => { XKBD => 'Swedish' },
    'sg-latin1'             => { XKBD => 'Swiss (DE)' },
    'sk-qwerty'             => { XKBD => 'Slovakian' },
    'slovene'               => { XKBD => 'Slovenian' },
    'sr-cy'                 => { XKBD => 'Serbian' },
    'sq'                    => { XKBD => 'Albanian' },
    'th-tis'                => { XKBD => 'Thai' },
    'trf'                   => { XKBD => 'Turkish (F layout)' },
    'trqu'                  => { XKBD => 'Turkish (Q layout)' },
    'ua'                    => { XKBD => 'Ukrainian' },
    'uk'                    => { XKBD => 'British' },
    'us'                    => { XKBD => 'American (US)' },
    # Mac USB keymaps
    'mac-usb-be'            => { XKBD => 'Belgian', XkbModel => 'macintosh' },
    'mac-usb-de_CH'         => { XKBD => 'Swiss (de)', XkbModel => 'macintosh' },
    'mac-usb-de-latin1-nodeadkeys'  => { XKBD => 'German (ndk)', XkbModel => 'macintosh' },
    'mac-usb-de-latin1'     => { XKBD => 'German', XkbModel => 'macintosh' },
    'mac-usb-dk-latin1'     => { XKBD => 'Danish', XkbModel => 'macintosh' },
    'mac-usb-dvorak'        => { XKBD => 'Dvorak', XkbModel => 'macintosh' },
    'mac-usb-es'            => { XKBD => 'Spanish', XkbModel => 'macintosh' },
    'mac-usb-fi-latin1'     => { XKBD => 'Finnish', XkbModel => 'macintosh' },
    'mac-usb-fr_CH-latin1'  => { XKBD => 'Swiss (fr)', XkbModel => 'macintosh' },
    'mac-usb-fr'            => { XKBD => 'French', XkbModel => 'macintosh' },
    'mac-usb-it'            => { XKBD => 'Italian', XkbModel => 'macintosh' },
    'mac-usb-pt-latin1'     => { XKBD => 'Portuguese', XkbModel => 'macintosh' },
    'mac-usb-se'            => { XKBD => 'Swedish', XkbModel => 'macintosh' },
    'mac-usb-uk'            => { XKBD => 'British', XkbModel => 'macintosh' },
    'mac-usb-us'            => { XKBD => 'American (US)', XkbModel => 'macintosh' },
    # Sun keymaps
    'sunkeymap'             => { XkbRules => 'sun', XKBD => 'American (US)', XkbModel => 'type5' },
    'sun-pl'                => { XkbRules => 'sun', XKBD => 'Polish', XkbModel => 'type5' },
    'sunt4-es'              => { XkbRules => 'sun', XKBD => 'Spanish', XkbModel => 'type4' },
    'sunt5-cz-us'           => { XkbRules => 'sun', XKBD => 'Czech', XkbModel => 'type5' },
    'sunt5-de-latin1'       => { XkbRules => 'sun', XKBD => 'German', XkbModel => 'type5' },
    'sunt5-es'              => { XkbRules => 'sun', XKBD => 'Spanish', XkbModel => 'type5' },
    'sunt5-fi-latin1'       => { XkbRules => 'sun', XKBD => 'Finnish', XkbModel => 'type5' },
    'sunt5-fr-latin1'       => { XkbRules => 'sun', XKBD => 'French', XkbModel => 'type5' },
    'sunt5-ru'              => { XkbRules => 'sun', XKBD => 'Russian', XkbModel => 'type5' },
    'sunt5-uk'              => { XkbRules => 'sun', XKBD => 'British', XkbModel => 'type5' },
);

sub get_lang_console_map() {
    return %lang_console_map;
}

# These keyboards might be eventually included...
# atari-us	US English
# atari-uk	English
# atari-de	German
# atari-fr	French
# atari-se	Swedish
# lk201-us	US English
# mac-us-std	U.S. English (82 keys)
# mac-us-ext	U.S. English (extended kbd)
# mac-es	Spanish
# mac-de2-ext	German (extended kbd)
# mac-fr2-ext	French (extended kbd)
# mac-fr3	French (alternate)               

# Define the subarch map. Subarches, esp. in the case of powerpc need
# special treatment. In particular, PowerMacs use 'macintosh' XKbModel,
# while PReP/CHRP use plain pc104/5. If our case we have a powermac/apus,
# then we don't set the XkbModel, but rather let X configuration to set
# it. If on the other hand, we have a PReP/CHRP system we can safely
# preseed the values according to the locale chosen.
my %subarch_map = (  'ppcbug'               => { Set_XkbModel => 'true' },
                     'prep'                 => { Set_XkbModel => 'true' },
                     'chrp'                 => { Set_XkbModel => 'true' },
                     'amiga'                => { Set_XkbModel => 'false' },
                     'pmac_newworld'        => { Set_XkbModel => 'false' },
                     'pmac_oldworld'        => { Set_XkbModel => 'false' },
                     'none'                 => { Set_XkbModel => 'true' }
                  );

sub get_subarch_map() {
    return %subarch_map;
}
                  
sub get_selected_Xkb_from_console {
    my ($console_kmap, $x_lang_map, $console_lang_map, $debconf_keys) = @_;
    
    my %selected;# = %$debconf_keys;
    my $xkbd = $console_lang_map->{$console_kmap}{'XKBD'};
    if (!defined($x_lang_map->{$xkbd})) {
        log_msg("$0:get_selected_Xkb_from_console(): Not defined in lang_map: ".$xkbd."!");
    }
    log_msg("$0:get_selected_Xkb_from_console(): console map: $console_kmap.:");
    for my $key (sort keys %$debconf_keys) {
        if (defined($console_lang_map->{$console_kmap}{$key})) {
            $selected{$key} = $console_lang_map->{$console_kmap}{$key};
            next;
        } 
        if (defined($x_lang_map->{$xkbd}{$key})) {
            $selected{$key} = $x_lang_map->{$xkbd}{$key};
            next;
        }
        delete $selected{$key};
    }
    return %selected;
}

sub get_selected_Xkb_from_locale {
    my ($lng, $x_lang_map, $debconf_keys) = @_;
    
    my %selected;# = %$debconf_keys;
    # Get the subarch
    my $subarch = get_subarch();

    # If SET_XkbModel is set to false, then remove the XkbModel from the keynames
    # associative array.
    if ($subarch_map{$subarch}{'Set_XkbModel'} eq 'false') {
        delete $debconf_keys->{'XkbModel'};
    }

    for my $key (sort keys %$debconf_keys) {
        if (defined($x_lang_map->{$lng}{$key})) {
            $selected{$key} = $x_lang_map->{$lng}{$key};
        }
    }
    
    return %selected;
}

sub select_Xkb {
    my ($lng, $x_lang_map, $console_lang_map, $debconf_keys) = @_;
    
    my $key;
    my %s;
    # Get the keymap set from the debian installer, using debconf
    my @res = db_get("debian-installer/keymap");
    if ($res[0] == 0) {
        log_msg("$0:get_selected_Xkb_from_console(): keymap: ".$res[1]." =>\t".$console_lang_map->{$res[1]}{'XKBD'});
        if (defined($console_lang_map->{$res[1]})) {
            %s = get_selected_Xkb_from_console($res[1], $x_lang_map, $console_lang_map, $debconf_keys);
            for $key (sort keys %s) {
                log_msg("$0:select_Xkb():\t".$debconf_keys->{$key}.":\t".$s{$key});
            }
            return %s;
        }
    } else {
        my %lngmap = get_lang_map();
        my $language = choose_language($lng, \%lngmap);
        log_msg("$0:select_Xkb(): Chosen locale: $language");
        %s = get_selected_Xkb_from_locale($language, $x_lang_map, $debconf_keys);
        for $key (sort keys %s) {
            log_msg("$0:select_Xkb():\t".$debconf_keys->{$key}.":\t".$s{$key});
        }
        return %s;
    }
}

1;
