/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * A LibreOffice extension to send the menubar structure through DBusMenu
 *
 * Copyright 2011 Canonical, Ltd.
 * Authors:
 *     Alberto Ruiz <alberto.ruiz@codethink.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the the GNU Lesser General Public License version 3, as published by the Free
 * Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR PURPOSE.  See the applicable
 * version of the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with this program. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include <com/sun/star/frame/XFrame.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/frame/XFrameActionListener.hpp>
#include <com/sun/star/frame/FrameAction.hpp>
#include <cppuhelper/implbase1.hxx>
#include <com/sun/star/lang/EventObject.hpp>

#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/menuitem.h>

using com::sun::star::uno::Reference;
using com::sun::star::frame::XFrame;
using com::sun::star::lang::XMultiServiceFactory;
using com::sun::star::lang::EventObject;
using com::sun::star::frame::XFrameActionListener;
using com::sun::star::frame::FrameActionEvent;
using com::sun::star::uno::RuntimeException;
using rtl::OUString;

/* This class is a helper in charge of closing the dbusmenu server when a frame is closed,
 * and also allows the menuitem callbacks to dispatch commands.
 */
 
class FrameHelper : public cppu::WeakImplHelper1 < XFrameActionListener >
{
  private:
	Reference < XFrame >                xFrame;
	Reference < XMultiServiceFactory >  xMSF;
	DbusmenuServer                     *server;
	DbusmenuMenuitem                   *root;
	gboolean                            watcher_set;
	guint                               watcher;

  public:
	FrameHelper(const Reference< XMultiServiceFactory >&  rServiceManager,
	                    const Reference< XFrame >&        xFrame,
	                    DbusmenuServer*                   server);

	virtual ~FrameHelper();
	virtual void SAL_CALL frameAction(const FrameActionEvent& action)
	  throw (RuntimeException) {}
	
	virtual void SAL_CALL disposing(const EventObject& aEvent)
	  throw (RuntimeException) {}
	
	void setRootItem (DbusmenuMenuitem *root);
	
	void setRegistrarWatcher (guint watcher);
	
	void setServer (DbusmenuServer *server);
	
	Reference < XFrame > getFrame ();
	
	unsigned long getXID ();
		
	void dispatchCommand (OUString command);
};
