/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * A LibreOffice extension to send the menubar structure through DBusMenu
 *
 * Copyright 2011 Canonical, Ltd.
 * Authors:
 *     Alberto Ruiz <alberto.ruiz@codethink.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the the GNU Lesser General Public License version 3, as published by the Free
 * Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranties of MERCHANTABILITY,
 * SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR PURPOSE.  See the applicable
 * version of the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with this program. If not, see <http://www.gnu.org/licenses/>
 *
 */

#include "FrameHelper.h"

#include <com/sun/star/frame/XDispatchHelper.hpp>
#include <com/sun/star/frame/XDispatchProvider.hpp>
#include <com/sun/star/awt/XSystemDependentWindowPeer.hpp>
#include <com/sun/star/awt/SystemDependentXWindow.hpp>
#include <com/sun/star/lang/SystemDependent.hpp>
#include <com/sun/star/beans/PropertyValue.hpp>

#include <rtl/process.h>

#include <gio/gio.h>

using com::sun::star::frame::XDispatchProvider;
using com::sun::star::frame::XDispatchHelper;
using com::sun::star::awt::XSystemDependentWindowPeer;
using com::sun::star::awt::SystemDependentXWindow;
using com::sun::star::uno::UNO_QUERY_THROW;
using com::sun::star::lang::SystemDependent::SYSTEM_XWINDOW;
using com::sun::star::uno::Sequence;
using com::sun::star::beans::PropertyValue;

FrameHelper::FrameHelper(const Reference< XMultiServiceFactory >&  rServiceManager,
                    const Reference< XFrame >&        xFrame,
                    DbusmenuServer*                   server)
{
	xMSF = rServiceManager;
	this->xFrame = xFrame;
	this->server = server;
	
	root = NULL;
	watcher_set = FALSE;
}

FrameHelper::~FrameHelper()
{
	if (server)
		g_object_unref (server);
		
	if (root)
		g_object_unref (root);

	if (watcher_set)
		g_bus_unwatch_name (watcher);
}

void
FrameHelper::setRootItem (DbusmenuMenuitem *root)
{
	this->root = root;
}

void
FrameHelper::setRegistrarWatcher (guint watcher)
{
	watcher_set = TRUE;
	this->watcher = watcher;
}

void
FrameHelper::setServer (DbusmenuServer *server)
{
	this->server = server;
}

Reference < XFrame >
FrameHelper::getFrame ()
{
	return xFrame;
}

unsigned long
FrameHelper::getXID ()
{
	Reference< XSystemDependentWindowPeer > xWin( xFrame->getContainerWindow(), UNO_QUERY_THROW );

	if (!xWin.is())
		return 0;

	sal_Int8 processID[16];
	rtl_getGlobalProcessId( (sal_uInt8*)processID );
	Sequence <signed char> pidSeq (processID, 16);

	SystemDependentXWindow xWindow;
	xWin->getWindowHandle (pidSeq, SYSTEM_XWINDOW) >>= xWindow;

	return xWindow.WindowHandle;
}
	
void
FrameHelper::dispatchCommand (OUString command)
{
	Reference < XDispatchHelper > rDispatchHelper (xMSF->createInstance(OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.frame.DispatchHelper"))),
	                                               UNO_QUERY_THROW);
	Reference < XDispatchHelper > xdh(rDispatchHelper);
	
	xdh->executeDispatch (Reference < XDispatchProvider > (xFrame, UNO_QUERY_THROW),
	                      command,
	                      OUString::createFromAscii(""),
	                      0,
	                      Sequence < PropertyValue > ());
}
